/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.parser.DTD;
import org.apache.camel.maven.AbstractApiMethodGeneratorMojo;
import org.apache.camel.maven.JavadocParser;
import org.apache.camel.support.component.ApiMethodParser;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="fromJavadoc", requiresDependencyResolution=ResolutionScope.TEST, requiresProject=true, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class JavadocApiMethodGeneratorMojo
extends AbstractApiMethodGeneratorMojo {
    protected static final String DEFAULT_EXCLUDE_PACKAGES = "javax?\\.lang.*";
    private static final Pattern RAW_ARGTYPES_PATTERN;
    @Parameter(property="org.apache.camel.excludePackages", defaultValue="javax?\\.lang.*")
    protected String excludePackages;
    @Parameter(property="org.apache.camel.excludeClasses")
    protected String excludeClasses;
    @Parameter(property="org.apache.camel.includeMethods")
    protected String includeMethods;
    @Parameter(property="org.apache.camel.excludeMethods")
    protected String excludeMethods;
    @Parameter(property="org.apache.camel.includeStaticMethods")
    protected Boolean includeStaticMethods;

    @Override
    public List<String> getSignatureList() throws MojoExecutionException {
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern packagePatterns = Pattern.compile(this.excludePackages);
        Pattern classPatterns = this.excludeClasses != null ? Pattern.compile(this.excludeClasses) : null;
        Pattern includeMethodPatterns = this.includeMethods != null ? Pattern.compile(this.includeMethods) : null;
        Pattern excludeMethodPatterns = this.excludeMethods != null ? Pattern.compile(this.excludeMethods) : null;
        for (Class<?> aClass = this.getProxyType(); !(aClass == null || packagePatterns.matcher(aClass.getPackage().getName()).matches() || classPatterns != null && classPatterns.matcher(aClass.getSimpleName()).matches()); aClass = aClass.getSuperclass()) {
            this.log.debug("Processing " + aClass.getName());
            String javaDocPath = aClass.getName().replace('.', '/').replace('$', '.') + ".html";
            try (InputStream inputStream = this.getProjectClassLoader().getResourceAsStream(javaDocPath);){
                if (inputStream == null) {
                    this.log.debug("JavaDoc not found on classpath for " + aClass.getName());
                    break;
                }
                DTD dtd = DTD.getDTD("html.dtd");
                JavadocParser htmlParser = new JavadocParser(dtd, javaDocPath);
                htmlParser.parse(new InputStreamReader(inputStream, "UTF-8"));
                String parseError = htmlParser.getErrorMessage();
                if (parseError != null) {
                    throw new MojoExecutionException(parseError);
                }
                Map<String, String> methodMap = htmlParser.getMethodText();
                for (String method : htmlParser.getMethods()) {
                    String resultType;
                    String[] types;
                    if (result.containsKey(method) || includeMethodPatterns != null && !includeMethodPatterns.matcher(method).find() || excludeMethodPatterns != null && excludeMethodPatterns.matcher(method).find()) continue;
                    int leftBracket = method.indexOf(40);
                    String name = method.substring(0, leftBracket);
                    String args = method.substring(leftBracket + 1, method.length() - 1);
                    if (args.isEmpty()) {
                        types = new String[]{};
                    } else {
                        ArrayList<String> rawTypes = new ArrayList<String>();
                        Matcher argTypesMatcher = RAW_ARGTYPES_PATTERN.matcher(args);
                        while (argTypesMatcher.find()) {
                            rawTypes.add(argTypesMatcher.group(1));
                        }
                        types = rawTypes.toArray(new String[rawTypes.size()]);
                    }
                    if ((resultType = this.getResultType(aClass, name, types)) == null) continue;
                    result.put(method, resultType + " " + name + methodMap.get(method));
                }
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (result.isEmpty()) {
            throw new MojoExecutionException("No public non-static methods found, make sure Javadoc is available as project test dependency");
        }
        return new ArrayList<String>(result.values());
    }

    private String getResultType(Class<?> aClass, String name, String[] types) throws MojoExecutionException {
        Class[] argTypes = new Class[types.length];
        ClassLoader classLoader = this.getProjectClassLoader();
        for (int i = 0; i < types.length; ++i) {
            try {
                try {
                    argTypes[i] = ApiMethodParser.forName((String)types[i], (ClassLoader)classLoader);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException(e.getCause().getMessage(), e.getCause());
            }
        }
        String result = null;
        try {
            Method method = aClass.getMethod(name, argTypes);
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers) || Boolean.TRUE.equals(this.includeStaticMethods)) {
                result = method.getReturnType().getName();
            }
        }
        catch (NoSuchMethodException e) {
            try {
                aClass.getDeclaredMethod(name, argTypes);
            }
            catch (NoSuchMethodException e1) {
                throw new MojoExecutionException(e1.getMessage(), (Exception)e1);
            }
        }
        return result;
    }

    static {
        System.setProperty("java.awt.headless", "true");
        RAW_ARGTYPES_PATTERN = Pattern.compile("\\s*([^<\\s,]+)\\s*(<[^>]+>)?\\s*,?");
    }
}

