/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.jms.WikittyActionMessage;
import org.sharengo.wikitty.jms.WikittyJMSUtil;

public class WikittyStorageSubscriberJMS
implements MessageListener {
    private static final Log log = LogFactory.getLog(WikittyStorageSubscriberJMS.class);
    protected final TopicConnectionFactory connectionFactory;
    protected final TopicConnection topicConnection;
    protected final Topic topic;
    protected final TopicSession topicSession;
    protected final TopicSubscriber topicSubscriber;
    protected final WikittyStorage delegateStorage;

    public WikittyStorageSubscriberJMS(WikittyStorage delegateStorage, Properties properties) throws NamingException, JMSException {
        if (delegateStorage == null) {
            throw new IllegalArgumentException("delegateStorage is null");
        }
        this.delegateStorage = delegateStorage;
        this.topic = new ActiveMQTopic("WikittyStorageTopic");
        String provider = properties.getProperty("java.naming.provider.url");
        this.connectionFactory = new ActiveMQConnectionFactory(provider);
        this.topicConnection = this.connectionFactory.createTopicConnection();
        this.topicConnection.setClientID("WikittyStorageSubscriberJMS");
        this.topicSession = this.topicConnection.createTopicSession(true, 0);
        this.topicSubscriber = this.topicSession.createDurableSubscriber(this.topic, "WikittyStorageSubscriberJMS");
        this.topicSubscriber.setMessageListener((MessageListener)this);
    }

    public void start() throws JMSException {
        this.topicConnection.start();
    }

    public void stop() throws JMSException {
        this.topicConnection.stop();
    }

    public void close() throws JMSException {
        this.topicConnection.close();
    }

    protected void finalize() throws Throwable {
        this.topicConnection.close();
    }

    public void onMessage(Message message) {
        WikittyTransaction transaction = new WikittyTransaction();
        boolean sessionCommit = false;
        try {
            transaction.begin();
            if (log.isDebugEnabled()) {
                WikittyJMSUtil.logMessageHeaders(log, message);
            }
            if (!(message instanceof ObjectMessage)) {
                throw new WikittyException("Unsupported message: " + message.getClass().getName());
            }
            WikittyActionMessage actionMessage = WikittyActionMessage.createReceiveMessage((ObjectMessage)message);
            this.onActionMessage(transaction, actionMessage);
            transaction.commit();
            sessionCommit = true;
        }
        catch (Exception e) {
            log.error((Object)"Exception while message dispatch", (Throwable)e);
            try {
                transaction.rollback();
            }
            catch (Exception e1) {
                log.error((Object)"Exception while transaction rollback", (Throwable)e1);
            }
            try {
                this.topicSession.rollback();
            }
            catch (JMSException e1) {
                log.error((Object)"JMSException while session rollback", (Throwable)e1);
            }
        }
        if (sessionCommit) {
            try {
                this.topicSession.commit();
            }
            catch (JMSException e) {
                log.error((Object)"JMSException while session commit", (Throwable)e);
            }
        }
    }

    protected void onActionMessage(WikittyTransaction transaction, WikittyActionMessage message) {
        block5: {
            try {
                String action = message.getAction();
                if ("store".equals(action)) {
                    this.actionStore(transaction, message);
                    break block5;
                }
                if ("clear".equals(action)) {
                    this.actionClear(transaction, message);
                    break block5;
                }
                if ("delete".equals(action)) {
                    this.actionDelete(transaction, message);
                    break block5;
                }
                throw new UnsupportedOperationException("Unsupported action: " + action);
            }
            catch (Exception e) {
                throw new WikittyException(e);
            }
        }
    }

    protected void actionStore(WikittyTransaction transaction, WikittyActionMessage message) throws JMSException {
        ArrayList wikitties = (ArrayList)message.getParameter("wikitties");
        Boolean disableAutoVersionIncrement = (Boolean)message.getParameter("disableAutoVersionIncrement");
        this.delegateStorage.store(transaction, (Collection)wikitties, disableAutoVersionIncrement.booleanValue());
    }

    protected void actionClear(WikittyTransaction transaction, WikittyActionMessage message) {
        this.delegateStorage.clear(transaction);
    }

    protected void actionDelete(WikittyTransaction transaction, WikittyActionMessage message) throws JMSException {
        ArrayList idList = (ArrayList)message.getParameter("ids");
        this.delegateStorage.delete(transaction, (Collection)idList);
    }
}

