/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.jms.WikittyActionMessage;
import org.sharengo.wikitty.jms.WikittyJMSUtil;

public class WikittyStorageJMS
implements WikittyStorage {
    protected final XATopicConnectionFactory connectionFactory;
    protected final Topic topic = new ActiveMQTopic("WikittyStorageTopic");
    protected final XATopicConnection topicConnection;
    protected final XATopicSession topicSession;
    protected final TopicPublisher topicPublisher;

    public WikittyStorageJMS(Properties properties) throws NamingException, JMSException {
        String provider = properties.getProperty("java.naming.provider.url");
        this.connectionFactory = new ActiveMQXAConnectionFactory(provider);
        this.topicConnection = this.connectionFactory.createXATopicConnection();
        this.topicSession = this.topicConnection.createXATopicSession();
        this.topicPublisher = this.topicSession.getTopicSession().createPublisher(this.topic);
    }

    public void close() throws JMSException {
        this.topicConnection.close();
    }

    protected void finalize() throws Throwable {
        this.topicConnection.close();
    }

    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) {
        try {
            WikittyJMSUtil.addXAResource(transaction, this.topicSession);
            WikittyActionMessage message = new WikittyActionMessage();
            message.setAction("store");
            message.addParameter("disableAutoVersionIncrement", Boolean.valueOf(disableAutoVersionIncrement));
            message.addParameter("wikitties", new ArrayList<Wikitty>(wikitties));
            ObjectMessage sendMessage = WikittyActionMessage.createSendMessage(message);
            this.topicPublisher.publish((Message)sendMessage);
            UpdateResponse result = new UpdateResponse();
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException("Error in WikittyStorageJMS", eee);
        }
    }

    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        try {
            WikittyJMSUtil.addXAResource(transaction, this.topicSession);
            WikittyActionMessage message = new WikittyActionMessage();
            message.setAction("delete");
            message.addParameter("ids", new ArrayList<String>(ids));
            ObjectMessage sendMessage = WikittyActionMessage.createSendMessage(message);
            this.topicPublisher.publish((Message)sendMessage);
            UpdateResponse result = new UpdateResponse();
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException("Error in WikittyStorageJMS", eee);
        }
    }

    public void clear(WikittyTransaction transaction) {
        try {
            WikittyJMSUtil.addXAResource(transaction, this.topicSession);
            WikittyActionMessage message = new WikittyActionMessage();
            message.setAction("clear");
            ObjectMessage sendMessage = WikittyActionMessage.createSendMessage(message);
            this.topicPublisher.publish((Message)sendMessage);
        }
        catch (Exception eee) {
            throw new WikittyException("Error in WikittyStorageJMS", eee);
        }
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isDeleted(WikittyTransaction transaction, String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Wikitty restore(WikittyTransaction transaction, String id, String ... fqFieldName) throws WikittyException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void scanWikitties(WikittyTransaction transaction, WikittyStorage.Scanner scanner) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

