/*
 * #%L
 * Wikitty :: ui-zk
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.ui;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.event.ListDataEvent;

/**
 *
 * @author sherkhan
 */
public class ProxyModel extends AbstractListModel implements BindingListModel {

    protected List<Data> _proxyDatas = new ArrayList<Data>();

    @Override
    public Object getElementAt(int index) {
        return _proxyDatas.get(index);
    }

    @Override
    public int getSize() {
        return _proxyDatas.size();
    }

    @Override
    public int indexOf(Object obj) {
        return _proxyDatas.indexOf(obj);
    }

    public void setProxyDatas(List<Data> fieldExtensions) {
        _proxyDatas = fieldExtensions;
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }

    public void addData(Data newData) {
        _proxyDatas.add(newData);
        fireEvent(ListDataEvent.INTERVAL_ADDED, _proxyDatas.size() - 1, _proxyDatas.size() - 1);
    }

    public void removeData(Data data) {
        int interval = _proxyDatas.indexOf(data);
        _proxyDatas.remove(data);
        fireEvent(ListDataEvent.INTERVAL_REMOVED, interval, interval);
    }

    public void reload() {
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }
}
