/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.ElementField;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyTokenHelper;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.query.FacetQuery;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.WikittyQueryResultTreeNode;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRegistry;
import org.nuiton.wikitty.services.WikittySecurityUtil;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyClient {
    private static final TimeLog timeLog = new TimeLog(WikittyClient.class);
    protected ApplicationConfig config = null;
    protected WikittyServiceEnhanced wikittyService;
    protected String securityToken;

    protected WikittyClient() {
    }

    public WikittyClient(ApplicationConfig config) {
        this(config, WikittyServiceFactory.buildWikittyService(config));
    }

    public WikittyClient(ApplicationConfig config, WikittyService wikittyService) {
        this(config, wikittyService, null);
    }

    public WikittyClient(ApplicationConfig config, WikittyService wikittyService, String securityToken) {
        if (config != null) {
            this.config = config;
            long timeToLogInfo = config.getOptionAsInt(WikittyConfigOption.WIKITTY_CLIENT_TIME_TO_LOG_INFO.getKey());
            long timeToLogWarn = config.getOptionAsInt(WikittyConfigOption.WIKITTY_CLIENT_TIME_TO_LOG_WARN.getKey());
            timeLog.setTimeToLogInfo(timeToLogInfo);
            timeLog.setTimeToLogWarn(timeToLogWarn);
        }
        this.setWikittyService(wikittyService);
        this.setSecurityToken(securityToken);
    }

    public static TimeLog getTimeTrace() {
        return timeLog;
    }

    public static Map<String, TimeLog.CallStat> getCallCount() {
        return timeLog.getCallCount();
    }

    public WikittyExtensionMigrationRegistry getMigrationRegistry() {
        WikittyExtensionMigrationRegistry result = (WikittyExtensionMigrationRegistry)this.config.getObject(WikittyExtensionMigrationRegistry.class);
        return result;
    }

    public void login(String login, String password) {
        long start = TimeLog.getTime();
        String result = this.wikittyService.login(login, password);
        this.setSecurityToken(result);
        timeLog.log(start, "login");
    }

    public void logout() {
        long start = TimeLog.getTime();
        this.wikittyService.logout(this.securityToken);
        timeLog.log(start, "logout");
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public WikittyUser getUser() {
        WikittyUser result = this.getUser(WikittyUser.class);
        return result;
    }

    public <E extends BusinessEntity> E getUser(Class<E> clazz) {
        Wikitty securityTokenWikitty;
        E result = null;
        if (this.securityToken != null && (securityTokenWikitty = this.restore(this.securityToken, new String[0])) != null) {
            String userId = WikittyTokenHelper.getUser(securityTokenWikitty);
            result = this.restore(clazz, userId, new String[0]);
        }
        return result;
    }

    public WikittyService getWikittyService() {
        return this.wikittyService.getDelegate();
    }

    public void setWikittyService(WikittyService wikittyService) {
        this.wikittyService = new WikittyServiceEnhanced(wikittyService);
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public Wikitty store(Wikitty w) {
        long start = TimeLog.getTime();
        WikittyEvent resp = this.wikittyService.store(this.securityToken, w);
        resp.update(w);
        this.preload(Collections.singletonList(w), new String[0]);
        timeLog.log(start, "store");
        return w;
    }

    public <E extends BusinessEntity> E store(E e) {
        Wikitty w = ((BusinessEntityImpl)e).getWikitty();
        this.store(w);
        return e;
    }

    public <E extends BusinessEntity> E[] store(E e1, E e2, E ... eN) {
        ArrayList es = new ArrayList(eN.length + 2);
        Collections.addAll(es, e1, e2);
        Collections.addAll(es, eN);
        List list = this.store(es);
        BusinessEntity[] result = list.toArray((BusinessEntity[])Array.newInstance(eN.getClass().getComponentType(), list.size()));
        return result;
    }

    public Wikitty[] store(Wikitty w1, Wikitty w2, Wikitty ... wN) {
        ArrayList<Wikitty> ws = new ArrayList<Wikitty>(wN.length + 2);
        Collections.addAll(ws, w1, w2);
        Collections.addAll(ws, wN);
        List<Wikitty> resultList = this.storeWikitty(ws);
        Wikitty[] result = resultList.toArray(new Wikitty[resultList.size()]);
        return result;
    }

    public <E extends BusinessEntity> List<E> store(List<E> objets) {
        long start = TimeLog.getTime();
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(objets.size());
        for (BusinessEntity e : objets) {
            if (e == null) {
                wikitties.add(null);
                continue;
            }
            Wikitty w = ((BusinessEntityImpl)e).getWikitty();
            wikitties.add(w);
        }
        this.storeWikitty(wikitties);
        timeLog.log(start, "store<list>");
        return objets;
    }

    public List<Wikitty> storeWikitty(List<Wikitty> wikitties) {
        long start = TimeLog.getTime();
        WikittyEvent resp = this.wikittyService.store(this.securityToken, wikitties);
        for (Wikitty w : wikitties) {
            resp.update(w);
        }
        this.preload(wikitties, new String[0]);
        timeLog.log(start, "storeWikitty<list>");
        return wikitties;
    }

    protected Set<Wikitty> getWikittyForPreload(Map<String, Wikitty> available, Wikitty w, FieldType type, String fqField) {
        HashSet<Wikitty> result = new HashSet<Wikitty>();
        HashSet<String> ids = new HashSet<String>();
        if (type.isCollection()) {
            ids.addAll((Collection)w.getFqField(fqField));
        } else {
            ids.add((String)w.getFqField(fqField));
        }
        Collection availableIds = CollectionUtils.intersection(ids, available.keySet());
        for (String id : availableIds) {
            result.add(available.get(id));
        }
        ids.removeAll(availableIds);
        Set<Wikitty> restored = this.restore(ids, new String[0]);
        for (Wikitty wikitty : restored) {
            if (wikitty == null) continue;
            available.put(wikitty.getId(), wikitty);
        }
        result.addAll(restored);
        return result;
    }

    protected void preload(Wikitty w, Map<String, Wikitty> available, Set<String> loaded, String preloadPattern) {
        String pattern = StringUtils.substringBefore((String)preloadPattern, (String)",");
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            pattern = pattern.trim();
            String nextPattern = StringUtils.substringAfter((String)preloadPattern, (String)",");
            String wid = w.getId();
            for (String fqField : w.fieldNames()) {
                FieldType type;
                if (loaded.contains(wid + "+" + fqField) || (type = w.getFieldType(fqField)).getType() != WikittyTypes.WIKITTY || !Pattern.matches(pattern, fqField)) continue;
                loaded.add(wid + "+" + fqField);
                Set<Wikitty> links = this.getWikittyForPreload(available, w, type, fqField);
                for (Wikitty link : links) {
                    if (link == null) continue;
                    w.addPreloaded(link);
                    this.preload(link, available, loaded, nextPattern);
                    this.preload(link, available, loaded);
                }
            }
        }
    }

    protected void preload(Wikitty w, Map<String, Wikitty> available, Set<String> loaded) {
        if (w != null) {
            for (String p : w.getAllPreloadPattern()) {
                this.preload(w, available, loaded, p);
            }
        }
    }

    public void preload(Collection<Wikitty> wikitties, String ... preloadPattern) {
        String patterns = StringUtils.join((Object[])preloadPattern, (String)";");
        HashMap<String, Wikitty> available = new HashMap<String, Wikitty>();
        for (Wikitty w : wikitties) {
            if (w == null) continue;
            available.put(w.getId(), w);
            if (!StringUtils.isNotBlank((CharSequence)patterns)) continue;
            w.setPreloadPattern(patterns);
        }
        HashSet<String> loaded = new HashSet<String>();
        for (Wikitty w : wikitties) {
            if (w == null) continue;
            this.preload(w, available, loaded);
        }
    }

    public List<Wikitty> restore(List<String> id, String ... preload) {
        ArrayList<Wikitty> result;
        long start = TimeLog.getTime();
        if (id == null) {
            result = new ArrayList();
        } else {
            result = this.wikittyService.restore(this.securityToken, id);
            this.preload(result, preload);
        }
        timeLog.log(start, "restore<list>");
        return result;
    }

    public Wikitty restore(String id, String ... preload) {
        long start = TimeLog.getTime();
        Wikitty result = null;
        if (id != null) {
            result = this.restore(Collections.singletonList(id), preload).get(0);
        }
        timeLog.log(start, "restore");
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id, boolean checkExtension, String ... preload) {
        long start = TimeLog.getTime();
        ArrayList<Object> result = new ArrayList<Object>();
        if (id != null) {
            List<Wikitty> wikitties = this.restore(id, preload);
            Collection<String> businessExtension = null;
            if (checkExtension) {
                BusinessEntityImpl sample = (BusinessEntityImpl)WikittyUtil.newInstance(clazz);
                businessExtension = sample.getExtensionNames();
            }
            for (Wikitty w : wikitties) {
                Object dto = null;
                if (!checkExtension || CollectionUtils.subtract(businessExtension, w.getExtensionNames()).isEmpty()) {
                    dto = WikittyUtil.newInstance(clazz, w);
                }
                result.add(dto);
            }
        }
        timeLog.log(start, "restore<list>");
        return result;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id, String ... preload) {
        E result = this.restore(clazz, id, false, preload);
        return result;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id, boolean checkExtension, String ... preload) {
        long start = TimeLog.getTime();
        BusinessEntity result = null;
        if (id != null) {
            result = (BusinessEntity)this.restore(clazz, Collections.singletonList(id), checkExtension, preload).get(0);
        }
        timeLog.log(start, "restore<Business>");
        return (E)result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id, String ... preload) {
        List<E> result = this.restore(clazz, id, false, preload);
        return result;
    }

    public Set<Wikitty> restore(Set<String> id, String ... preload) {
        ArrayList<String> list = null;
        if (id != null) {
            list = new ArrayList<String>(id);
        }
        List<Wikitty> resultList = this.restore(list, preload);
        LinkedHashSet<Wikitty> result = new LinkedHashSet<Wikitty>(resultList);
        return result;
    }

    public <E extends BusinessEntity> Set<E> restore(Class<E> clazz, Set<String> id, String ... preload) {
        Set<E> result = this.restore(clazz, id, false, preload);
        return result;
    }

    public <E extends BusinessEntity> Set<E> restore(Class<E> clazz, Set<String> id, boolean checkExtension, String ... preload) {
        ArrayList<String> list = null;
        if (id != null) {
            list = new ArrayList<String>(id);
        }
        List<E> resultList = this.restore(clazz, list, checkExtension, preload);
        LinkedHashSet<E> result = new LinkedHashSet<E>(resultList);
        return result;
    }

    public void delete(String id) {
        long start = TimeLog.getTime();
        this.wikittyService.delete(this.securityToken, id);
        timeLog.log(start, "delete");
    }

    public <E extends BusinessEntity> void delete(E object) {
        long start = TimeLog.getTime();
        if (object != null) {
            String id = object.getWikittyId();
            this.wikittyService.delete(this.securityToken, id);
        }
        timeLog.log(start, "delete(BusinessEntity)");
    }

    public void delete(Collection<String> ids) {
        long start = TimeLog.getTime();
        this.wikittyService.delete(this.securityToken, ids);
        timeLog.log(start, "delete<list>");
    }

    public <E extends BusinessEntity> void delete(List<E> objets) {
        long start = TimeLog.getTime();
        ArrayList<String> ids = new ArrayList<String>(objets.size());
        for (BusinessEntity e : objets) {
            if (e == null) continue;
            String id = e.getWikittyId();
            ids.add(id);
        }
        this.wikittyService.delete(this.securityToken, ids);
        timeLog.log(start, "delete<list<BusinessEntity>>");
    }

    public <E extends BusinessEntityImpl> WikittyQueryResult<E> findAllByExample(E e, int first, int limit, ElementField ... fieldFacet) {
        long start = TimeLog.getTime();
        WikittyQuery query = new WikittyQueryMaker().wikitty(e).end().setFirst(first).setLimit(limit).setFacetField(fieldFacet);
        WikittyQueryResult<String> queryResult = this.findAllByQuery(query);
        WikittyQueryResult<?> result = this.castTo(e.getClass(), queryResult);
        timeLog.log(start, "findAllByExample<limit>");
        return result;
    }

    public <E extends BusinessEntityImpl> E findByExample(E e) {
        long start = TimeLog.getTime();
        WikittyQuery query = new WikittyQueryMaker().wikitty(e).end();
        String id = this.findByQuery(query);
        BusinessEntityImpl result = (BusinessEntityImpl)this.restore(e.getClass(), id, new String[0]);
        timeLog.log(start, "findByExample");
        return (E)result;
    }

    protected <E> List<WikittyQueryResult<E>> findAllByQuery(Class<E> clazz, List<WikittyQuery> queries, boolean limitToFirst) {
        long start = TimeLog.getTime();
        ArrayList<WikittyQueryResult<E>> result = null;
        if (queries != null) {
            List<WikittyQuery> serviceQueries;
            if (BusinessEntity.class.isAssignableFrom(clazz)) {
                BusinessEntityImpl sample = (BusinessEntityImpl)WikittyUtil.newInstance(clazz);
                Wikitty wikitty = sample.getWikitty();
                Collection<String> extensions = wikitty.getExtensionNames();
                serviceQueries = new ArrayList<WikittyQuery>(queries.size());
                for (WikittyQuery criteria : queries) {
                    WikittyQuery serviceQuery = null;
                    if (criteria == null) {
                        serviceQuery = new WikittyQueryMaker().extContainsAll(extensions).end();
                    } else {
                        WikittyQueryMaker queryMaker;
                        serviceQuery = criteria.copy();
                        if (serviceQuery.getCondition() instanceof Select) {
                            Select select = (Select)serviceQuery.getCondition();
                            queryMaker = new WikittyQueryMaker().select(select.getElement()).and().condition(select.getSubCondition()).extContainsAll(extensions);
                        } else {
                            queryMaker = new WikittyQueryMaker().and().condition(serviceQuery.getCondition()).extContainsAll(extensions);
                        }
                        serviceQuery.setCondition(queryMaker.getCondition());
                    }
                    serviceQueries.add(serviceQuery);
                }
            } else {
                serviceQueries = queries;
            }
            if (limitToFirst) {
                for (WikittyQuery query : serviceQueries) {
                    query.setOffset(0);
                    query.setLimit(1);
                    query.setFacetExtension(false);
                    query.setFacetField(new Element[0]);
                    query.setFacetQuery(new FacetQuery[0]);
                }
            }
            List<WikittyQueryResult<String>> pagedResult = this.findAllByQuery(serviceQueries);
            result = new ArrayList<WikittyQueryResult<E>>(pagedResult.size());
            for (WikittyQueryResult<String> p : pagedResult) {
                result.add(this.castTo(clazz, p));
            }
        }
        timeLog.log(start, "findAllByQuery<E>(List, limitToFirst)");
        return result;
    }

    public <E> List<WikittyQueryResult<E>> findAllByQuery(Class<E> clazz, List<WikittyQuery> queries) {
        long start = TimeLog.getTime();
        List<WikittyQueryResult<E>> result = this.findAllByQuery(clazz, queries, false);
        timeLog.log(start, "findAllByQuery<E>(List)");
        return result;
    }

    public <E> WikittyQueryResult<E> findAllByQuery(Class<E> clazz, WikittyQuery query) {
        long start = TimeLog.getTime();
        WikittyQueryResult<E> result = this.findAllByQuery(clazz, Collections.singletonList(query), false).get(0);
        timeLog.log(start, "findAllByQuery<E>(One)");
        return result;
    }

    public <E> WikittyQueryResult<E>[] findAllByQuery(Class<E> clazz, WikittyQuery q1, WikittyQuery q2, WikittyQuery ... otherQueries) {
        long start = TimeLog.getTime();
        ArrayList<WikittyQuery> queries = new ArrayList<WikittyQuery>(otherQueries.length + 2);
        Collections.addAll(queries, q1, q2);
        Collections.addAll(queries, otherQueries);
        List<WikittyQueryResult<E>> resultList = this.findAllByQuery(clazz, queries, false);
        WikittyQueryResult[] result = resultList.toArray(new WikittyQueryResult[queries.size()]);
        timeLog.log(start, "findAllByQuery<Business>(Varargs)");
        return result;
    }

    public <E> List<E> findByQuery(Class<E> clazz, List<WikittyQuery> queries) {
        long start = TimeLog.getTime();
        List<WikittyQueryResult<E>> queryResult = this.findAllByQuery(clazz, queries, true);
        ArrayList<E> result = new ArrayList<E>(queryResult.size());
        for (WikittyQueryResult<E> r : queryResult) {
            if (r.size() > 0) {
                result.add(r.peek());
                continue;
            }
            result.add(null);
        }
        timeLog.log(start, "findByQuery<E>(List)");
        return result;
    }

    public <E> E findByQuery(Class<E> clazz, WikittyQuery query) {
        long start = TimeLog.getTime();
        E result = null;
        if (query != null) {
            result = this.findByQuery(clazz, Collections.singletonList(query)).get(0);
        }
        timeLog.log(start, "findByQuery<E>(One)");
        return result;
    }

    public <E> E[] findByQuery(Class<E> clazz, WikittyQuery q1, WikittyQuery q2, WikittyQuery ... otherQueries) {
        long start = TimeLog.getTime();
        ArrayList<WikittyQuery> queries = new ArrayList<WikittyQuery>(otherQueries.length + 2);
        Collections.addAll(queries, q1, q2);
        Collections.addAll(queries, otherQueries);
        List<E> resultList = this.findByQuery(clazz, queries);
        Object[] result = resultList.toArray((Object[])Array.newInstance(clazz, resultList.size()));
        timeLog.log(start, "findByQuery<E>(Varargs)");
        return result;
    }

    public List<WikittyQueryResult<String>> findAllByQuery(List<WikittyQuery> query) {
        long start = TimeLog.getTime();
        List<WikittyQueryResult<String>> result = null;
        if (query != null) {
            result = this.wikittyService.findAllByQuery(this.securityToken, query);
        }
        timeLog.log(start, "findAllByQuery(List)");
        return result;
    }

    public WikittyQueryResult<String> findAllByQuery(WikittyQuery query) {
        long start = TimeLog.getTime();
        WikittyQueryResult<String> result = null;
        if (query != null) {
            result = this.findAllByQuery(Collections.singletonList(query)).get(0);
        }
        timeLog.log(start, "findAllByQuery(One)");
        return result;
    }

    public WikittyQueryResult<String>[] findAllByQuery(WikittyQuery c1, WikittyQuery c2, WikittyQuery ... otherCriteria) {
        long start = TimeLog.getTime();
        ArrayList<WikittyQuery> criterias = new ArrayList<WikittyQuery>(otherCriteria.length + 2);
        Collections.addAll(criterias, c1, c2);
        Collections.addAll(criterias, otherCriteria);
        List<WikittyQueryResult<String>> resultList = this.findAllByQuery(criterias);
        WikittyQueryResult[] result = resultList.toArray(new WikittyQueryResult[criterias.size()]);
        timeLog.log(start, "findAllByCriteria(Varargs)");
        return result;
    }

    public List<String> findByQuery(List<WikittyQuery> query) {
        long start = TimeLog.getTime();
        List<String> result = null;
        if (query != null) {
            result = this.wikittyService.findByQuery(this.securityToken, query);
        }
        timeLog.log(start, "findByQuery(List)");
        return result;
    }

    public String findByQuery(WikittyQuery query) {
        long start = TimeLog.getTime();
        String result = null;
        if (query != null) {
            result = this.findByQuery(Collections.singletonList(query)).get(0);
        }
        timeLog.log(start, "findByQuery(One)");
        return result;
    }

    public String[] findByQuery(WikittyQuery q1, WikittyQuery q2, WikittyQuery ... otherQueries) {
        long start = TimeLog.getTime();
        ArrayList<WikittyQuery> queries = new ArrayList<WikittyQuery>(otherQueries.length + 2);
        Collections.addAll(queries, q1, q2);
        Collections.addAll(queries, otherQueries);
        List<String> resultList = this.findByQuery(queries);
        String[] result = resultList.toArray(new String[queries.size()]);
        timeLog.log(start, "findByQuery(Varargs)");
        return result;
    }

    public WikittyQueryResultTreeNode<Wikitty> findTreeNode(String wikittyId, int depth, boolean count, WikittyQuery filter) {
        long start = TimeLog.getTime();
        WikittyQueryResultTreeNode<String> resultId = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        WikittyQueryResultTreeNode result = null;
        if (resultId != null) {
            RetrieveIdVisitor retrieveIdVisitor = new RetrieveIdVisitor();
            resultId.acceptVisitor(retrieveIdVisitor);
            List<String> ids = retrieveIdVisitor.getIds();
            List<Wikitty> wikitties = this.restore(ids, new String[0]);
            IdToObjectConverter<Wikitty> converter = new IdToObjectConverter<Wikitty>(ids, wikitties);
            ConvertTreeVisitor convertVisitor = new ConvertTreeVisitor(converter);
            resultId.acceptVisitor(convertVisitor);
            result = convertVisitor.getTree();
        }
        timeLog.log(start, "findTreeNode<Wikitty>");
        return result;
    }

    public <E extends BusinessEntity> WikittyQueryResultTreeNode<E> findTreeNode(Class<E> clazz, String wikittyId, int depth, boolean count, WikittyQuery filter) {
        long start = TimeLog.getTime();
        WikittyQueryResultTreeNode<String> resultId = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        WikittyQueryResultTreeNode result = null;
        if (resultId != null) {
            RetrieveIdVisitor retrieveIdVisitor = new RetrieveIdVisitor();
            resultId.acceptVisitor(retrieveIdVisitor);
            List<String> ids = retrieveIdVisitor.getIds();
            List<E> wikitties = this.restore(clazz, ids, new String[0]);
            IdToObjectConverter<E> converter = new IdToObjectConverter<E>(ids, wikitties);
            ConvertTreeVisitor convertVisitor = new ConvertTreeVisitor(converter);
            resultId.acceptVisitor(convertVisitor);
            result = convertVisitor.getTree();
        }
        timeLog.log(start, "findTreeNode");
        return result;
    }

    public WikittyQueryResultTreeNode<String> findAllIdTreeNode(String wikittyId, int depth, boolean count, WikittyQuery filter) {
        long start = TimeLog.getTime();
        WikittyQueryResultTreeNode<String> result = this.wikittyService.findTreeNode(this.securityToken, wikittyId, depth, count, filter);
        timeLog.log(start, "findAllIdTreeNode");
        return result;
    }

    public WikittyEvent deleteTree(String treeNodeId) {
        long start = TimeLog.getTime();
        WikittyEvent result = this.wikittyService.deleteTree(this.securityToken, treeNodeId);
        timeLog.log(start, "deleteTree");
        return result;
    }

    public Wikitty restoreVersion(String wikittyId, String version) {
        long start = TimeLog.getTime();
        Wikitty result = this.wikittyService.restoreVersion(this.securityToken, wikittyId, version);
        timeLog.log(start, "restoreVersion");
        return result;
    }

    public WikittyEvent storeExtension(WikittyExtension ext) {
        long start = TimeLog.getTime();
        WikittyEvent response = this.wikittyService.storeExtension(this.securityToken, ext);
        timeLog.log(start, "storeExtension");
        return response;
    }

    public WikittyEvent storeExtension(Collection<WikittyExtension> exts) {
        long start = TimeLog.getTime();
        WikittyEvent response = this.wikittyService.storeExtension(this.securityToken, exts);
        timeLog.log(start, "storeExtension<list>");
        return response;
    }

    public WikittyExtension restoreExtension(String extensionId) {
        long start = TimeLog.getTime();
        WikittyExtension extension = this.wikittyService.restoreExtension(this.securityToken, extensionId);
        timeLog.log(start, "restoreExtension");
        return extension;
    }

    public WikittyExtension restoreExtensionLastVersion(String extensionName) {
        long start = TimeLog.getTime();
        WikittyExtension extension = this.wikittyService.restoreExtensionLastVersion(this.securityToken, extensionName);
        timeLog.log(start, "restoreExtensionLastVersion");
        return extension;
    }

    public Collection<WikittyExtension> restoreExtensionLastVersion(String extensionName1, String extensionName2, String ... extensionName) {
        long start = TimeLog.getTime();
        ArrayList<String> extName = new ArrayList<String>(extensionName.length + 2);
        extName.add(extensionName1);
        extName.add(extensionName2);
        extName.addAll(Arrays.asList(extensionName));
        Collection<WikittyExtension> result = this.restoreExtensionLastVersion(extName);
        timeLog.log(start, "restoreExtensionLastVersion[...]");
        return result;
    }

    public Collection<WikittyExtension> restoreExtensionLastVersion(String[] extensionName) {
        long start = TimeLog.getTime();
        ArrayList<String> extName = new ArrayList<String>();
        if (extensionName != null) {
            extName.addAll(Arrays.asList(extensionName));
        }
        Collection<WikittyExtension> result = this.restoreExtensionLastVersion(extName);
        timeLog.log(start, "restoreExtensionLastVersion[]");
        return result;
    }

    public Collection<WikittyExtension> restoreExtensionLastVersion(Collection<String> extensionNames) {
        long start = TimeLog.getTime();
        if (CollectionUtils.isEmpty(extensionNames)) {
            extensionNames = new LinkedHashSet<String>();
            List<String> extIds = this.getAllExtensionIds();
            for (String id : extIds) {
                String name = WikittyExtension.computeName(id);
                extensionNames.add(name);
            }
        }
        LinkedHashMap<String, WikittyExtension> extensionMaps = new LinkedHashMap<String, WikittyExtension>();
        List<WikittyExtension> exts = this.restoreExtensionAndDependenciesLastVesion(extensionNames);
        for (WikittyExtension ext : exts) {
            extensionMaps.put(ext.getName(), ext);
        }
        extensionMaps.keySet().retainAll(extensionNames);
        Collection<WikittyExtension> result = extensionMaps.values();
        timeLog.log(start, "restoreExtensionLastVersion");
        return result;
    }

    public List<WikittyExtension> restoreExtensionAndDependenciesLastVesion(Collection<String> extensionNames) {
        long start = TimeLog.getTime();
        List<WikittyExtension> result = this.wikittyService.restoreExtensionAndDependenciesLastVesion(this.securityToken, extensionNames);
        timeLog.log(start, "restoreExtensionAndDependenciesLastVesion");
        return result;
    }

    public void deleteExtension(String extName) {
        long start = TimeLog.getTime();
        this.wikittyService.deleteExtension(this.securityToken, extName);
        timeLog.log(start, "deleteExtension");
    }

    public void deleteExtension(Collection<String> extNames) {
        long start = TimeLog.getTime();
        this.wikittyService.deleteExtension(this.securityToken, extNames);
        timeLog.log(start, "deleteExtension<list>");
    }

    public List<String> getAllExtensionIds() {
        long start = TimeLog.getTime();
        List<String> result = this.wikittyService.getAllExtensionIds(this.securityToken);
        timeLog.log(start, "getAllExtensionIds");
        return result;
    }

    public List<String> getAllExtensionsRequires(String extensionName) {
        long start = TimeLog.getTime();
        List<String> result = this.wikittyService.getAllExtensionsRequires(this.securityToken, extensionName);
        timeLog.log(start, "getAllExtensionsRequires");
        return result;
    }

    public WikittyEvent clear() {
        long start = TimeLog.getTime();
        WikittyEvent result = this.wikittyService.clear(this.securityToken);
        timeLog.log(start, "clear");
        return result;
    }

    public void syncSearchEngine() {
        long start = TimeLog.getTime();
        this.wikittyService.syncSearchEngine(this.securityToken);
        timeLog.log(start, "syncSearchEngine");
    }

    @Deprecated
    public Wikitty getWikitty(BusinessEntity entity) {
        Wikitty result;
        long start = TimeLog.getTime();
        if (entity instanceof BusinessEntityImpl) {
            result = ((BusinessEntityImpl)entity).getWikitty();
        } else {
            String id = entity.getWikittyId();
            result = this.restore(id, new String[0]);
            try {
                Field[] fields;
                Class<?> entityClass = entity.getClass();
                for (Field field : fields = entityClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(WikittyField.class)) continue;
                    WikittyField annotation = field.getAnnotation(WikittyField.class);
                    String fieldFQN = annotation.fqn();
                    Method m = entityClass.getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                    Object value = m.invoke((Object)entity, new Object[0]);
                    result.setFqField(fieldFQN, value);
                }
            }
            catch (Exception eee) {
                throw new WikittyException("Could not transform entity to Wikitty", eee);
            }
            result.setVersion(entity.getWikittyVersion());
        }
        timeLog.log(start, "getWikitty");
        return result;
    }

    public boolean isMember(String groupName) {
        long start = TimeLog.getTime();
        boolean result = false;
        WikittyUser user = this.getLoggedInUser();
        WikittyQuery criteria = new WikittyQueryMaker().and().exteq("WikittyGroup").eq("WikittyGroup.name", (Object)groupName).end();
        Wikitty group = this.findByQuery(Wikitty.class, criteria);
        if (group != null && user != null) {
            result = WikittySecurityUtil.isMember(this.wikittyService, this.securityToken, user.getWikittyId(), group.getId());
        }
        timeLog.log(start, "isMember");
        return result;
    }

    public WikittyUser getLoggedInUser() {
        long start = TimeLog.getTime();
        String userId = WikittySecurityUtil.getUserForToken(this.wikittyService, this.securityToken);
        WikittyUser user = this.restore(WikittyUser.class, userId, new String[0]);
        timeLog.log(start, "getLoggedInUser");
        return user;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <E, F> List<E> castTo(Class<E> target, List<F> objects) {
        List<Object> result;
        if (objects == null) {
            return null;
        }
        if (objects.size() == 0) {
            return new ArrayList();
        }
        if (Wikitty.class.isAssignableFrom(target)) {
            String first = objects.get(0);
            if (first instanceof Wikitty) {
                return objects;
            }
            if (first instanceof BusinessEntityImpl) {
                result = new ArrayList(objects.size());
                Iterator<String> iterator = objects.iterator();
                while (iterator.hasNext()) {
                    BusinessEntityImpl businessEntityImpl = (BusinessEntityImpl)((Object)iterator.next());
                    result.add(businessEntityImpl.getWikitty());
                }
                return result;
            }
            if (first instanceof BusinessEntity) {
                ArrayList<String> arrayList = new ArrayList<String>(objects.size());
                for (BusinessEntity businessEntity : objects) {
                    arrayList.add(businessEntity.getWikittyId());
                }
                result = this.restore(arrayList, new String[0]);
                try {
                    Field[] fields;
                    BusinessEntity[] businessEntityArray = objects.toArray(new BusinessEntity[objects.size()]);
                    Wikitty[] wikittyArray = result.toArray(new Wikitty[result.size()]);
                    Class<?> entityClass = first.getClass();
                    for (Field field : fields = entityClass.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(WikittyField.class)) continue;
                        WikittyField annotation = field.getAnnotation(WikittyField.class);
                        String fieldFQN = annotation.fqn();
                        Method m = entityClass.getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                        for (int i = 0; i < businessEntityArray.length; ++i) {
                            if (wikittyArray[i] == null) continue;
                            Object value = m.invoke((Object)businessEntityArray[i], new Object[0]);
                            wikittyArray[i].setFqField(fieldFQN, value);
                        }
                    }
                    int i = 0;
                    while (i < businessEntityArray.length) {
                        if (wikittyArray[i] != null) {
                            wikittyArray[i].setVersion(businessEntityArray[i].getWikittyVersion());
                        }
                        ++i;
                    }
                    return result;
                }
                catch (Exception exception) {
                    throw new WikittyException("Could not transform entity to Wikitty", exception);
                }
            }
            if (!(first instanceof String)) throw new ClassCastException("WikittyQueryResult don't contains object convertible to Wikitty (accepted Wikitty, BusinessEntityImpl, String id) but not " + first.getClass());
            List<String> list = objects;
            return this.restore(list, new String[0]);
        }
        if (BusinessEntity.class.isAssignableFrom(target)) {
            List<Wikitty> resultTmp = this.castTo(Wikitty.class, objects);
            return WikittyUtil.newInstance(target, resultTmp);
        }
        if (Number.class.isAssignableFrom(target)) {
            result = new ArrayList(objects.size());
            Iterator<String> i$ = objects.iterator();
            while (i$.hasNext()) {
                String string = i$.next();
                BigDecimal bigDecimal = WikittyUtil.toBigDecimal(string);
                Number number = this.toNumber(target, bigDecimal);
                result.add(number);
            }
            return result;
        }
        if (Date.class.isAssignableFrom(target)) {
            result = new ArrayList(objects.size());
            Iterator<String> i$ = objects.iterator();
            while (i$.hasNext()) {
                String string = i$.next();
                Date date = WikittyUtil.toDate(string);
                result.add(date);
            }
            return result;
        }
        if (Boolean.class.isAssignableFrom(target)) {
            result = new ArrayList(objects.size());
            Iterator<String> i$ = objects.iterator();
            while (i$.hasNext()) {
                String string = i$.next();
                Boolean bl = WikittyUtil.toBoolean(string);
                result.add(bl);
            }
            return result;
        }
        if (byte[].class.isAssignableFrom(target)) {
            result = new ArrayList(objects.size());
            Iterator<String> i$ = objects.iterator();
            while (i$.hasNext()) {
                String string = i$.next();
                byte[] byArray = WikittyUtil.toBinary(string);
                result.add(byArray);
            }
            return result;
        }
        if (!String.class.isAssignableFrom(target)) throw new ClassCastException(String.format("Object list don't contains object convertible to %s (accepted Wikitty, BusinessEntityImpl, String id, Date, BigDecimal, Boolean, byte[]) but not '%s'", target.getName(), objects.get(0).getClass()));
        result = new ArrayList(objects.size());
        Iterator<String> i$ = objects.iterator();
        while (i$.hasNext()) {
            String string = i$.next();
            String string2 = WikittyUtil.toString(string);
            result.add(string2);
        }
        return result;
    }

    protected Number toNumber(Class target, BigDecimal v) {
        Number result = v;
        if (Byte.class.isAssignableFrom(target)) {
            result = v.byteValue();
        } else if (Double.class.isAssignableFrom(target)) {
            result = v.doubleValue();
        } else if (Float.class.isAssignableFrom(target)) {
            result = Float.valueOf(v.floatValue());
        } else if (Integer.class.isAssignableFrom(target)) {
            result = v.intValue();
        } else if (Long.class.isAssignableFrom(target)) {
            result = v.longValue();
        } else if (Short.class.isAssignableFrom(target)) {
            result = v.shortValue();
        } else if (BigInteger.class.isAssignableFrom(target)) {
            result = v.toBigInteger();
        }
        return result;
    }

    public <E> E castTo(Class<E> target, Object e) {
        E result;
        if (e == null) {
            result = null;
        } else {
            List<E> tmp = this.castTo(target, Collections.singletonList(e));
            result = tmp.get(0);
        }
        return result;
    }

    public <E> WikittyQueryResult<E> castTo(Class<E> target, WikittyQueryResult queryResult) {
        long startTime = System.nanoTime();
        List<E> castedResult = this.castTo(target, queryResult.getAll());
        long estimatedTime = System.nanoTime() - startTime;
        WikittyQueryResult<E> result = new WikittyQueryResult<E>(queryResult.getQueryName(), queryResult.getOffset(), queryResult.getTotalResult(), queryResult.getQueryString(), queryResult.getFacets(), castedResult, queryResult.getTimeQuery(), estimatedTime);
        return result;
    }

    private static class ConvertTreeVisitor<TARGET extends Serializable>
    implements WikittyQueryResultTreeNode.Visitor<String> {
        protected Converter<String, TARGET> converter;
        protected WikittyQueryResultTreeNode<TARGET> tree = null;
        protected LinkedList<WikittyQueryResultTreeNode<TARGET>> stack = new LinkedList();

        public ConvertTreeVisitor(Converter<String, TARGET> converter) {
            this.converter = converter;
            if (converter == null) {
                throw new IllegalArgumentException("Converter can't be null");
            }
        }

        public WikittyQueryResultTreeNode<TARGET> getTree() {
            return this.tree;
        }

        @Override
        public boolean visitEnter(WikittyQueryResultTreeNode<String> node) {
            String id = node.getObject();
            int count = node.getAttCount();
            Serializable object = (Serializable)this.converter.convert(id);
            WikittyQueryResultTreeNode<Serializable> newNode = new WikittyQueryResultTreeNode<Serializable>(object, count);
            WikittyQueryResultTreeNode<TARGET> parent = this.stack.peekLast();
            if (parent == null) {
                this.tree = newNode;
            } else {
                parent.add(newNode);
            }
            this.stack.offerLast(newNode);
            return true;
        }

        @Override
        public boolean visitLeave(WikittyQueryResultTreeNode<String> node) {
            this.stack.pollLast();
            return true;
        }

        private static interface Converter<SOURCE, TARGET> {
            public TARGET convert(SOURCE var1);
        }
    }

    private static class IdToObjectConverter<T>
    implements ConvertTreeVisitor.Converter<String, T> {
        protected Map<String, T> objects = new HashMap<String, T>();

        public IdToObjectConverter(List<String> ids, List<T> objectList) {
            for (int i = 0; i < ids.size(); ++i) {
                this.objects.put(ids.get(i), objectList.get(i));
            }
        }

        @Override
        public T convert(String id) {
            T result = this.objects.get(id);
            return result;
        }
    }

    private static class RetrieveIdVisitor
    implements WikittyQueryResultTreeNode.Visitor<String> {
        protected List<String> ids = new ArrayList<String>();

        private RetrieveIdVisitor() {
        }

        public List<String> getIds() {
            return this.ids;
        }

        @Override
        public boolean visitEnter(WikittyQueryResultTreeNode<String> node) {
            String id = node.getObject();
            this.ids.add(id);
            return true;
        }

        @Override
        public boolean visitLeave(WikittyQueryResultTreeNode<String> node) {
            return true;
        }
    }
}

