/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.query.FacetTopic;

public class WikittyQueryResult<T>
implements Serializable,
Iterable<T> {
    private static Log log = LogFactory.getLog(WikittyQueryResult.class);
    private static final long serialVersionUID = 1L;
    protected String queryName;
    protected int first;
    protected int totalResult;
    protected String queryString;
    protected List<T> results;
    protected Map<String, List<FacetTopic>> facets;
    protected Map<String, Map<String, FacetTopic>> facetsAsMap = null;

    public WikittyQueryResult(String queryName, int first, int totalResult, String queryString, Map<String, List<FacetTopic>> facets, List<T> results) {
        this.queryName = queryName;
        this.first = first;
        this.totalResult = totalResult;
        this.queryString = queryString;
        this.facets = facets;
        this.results = Collections.unmodifiableList(results);
    }

    public String getQueryName() {
        return this.queryName;
    }

    public int getFirst() {
        return this.first;
    }

    public int getTotalResult() {
        return this.totalResult;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Collection<String> getFacetNames() {
        Set<String> result = this.facets.keySet();
        return result;
    }

    public List<FacetTopic> getTopic(String facetName) {
        List<FacetTopic> result = this.facets.get(facetName);
        return result;
    }

    public FacetTopic getTopic(String facetName, String topicName) {
        FacetTopic result = this.getFacetsAsMap().get(facetName).get(topicName);
        return result;
    }

    public int getTopicCount(String facetName, String topicName) {
        FacetTopic topic;
        Map<String, FacetTopic> topics;
        int result = 0;
        if (this.getFacetsAsMap() != null && (topics = this.getFacetsAsMap().get(facetName)) != null && (topic = topics.get(topicName)) != null) {
            result = topic.getCount();
        }
        return result;
    }

    public Map<String, List<FacetTopic>> getFacets() {
        return this.facets;
    }

    public Map<String, Map<String, FacetTopic>> getFacetsAsMap() {
        if (this.facetsAsMap == null && this.facets != null) {
            HashMap<String, Map<String, FacetTopic>> localFacetsAsMap = new HashMap<String, Map<String, FacetTopic>>();
            for (Map.Entry<String, List<FacetTopic>> e : this.getFacets().entrySet()) {
                HashMap<String, FacetTopic> topics = new HashMap<String, FacetTopic>();
                localFacetsAsMap.put(e.getKey(), topics);
                for (FacetTopic t : e.getValue()) {
                    topics.put(t.getTopicName(), t);
                }
            }
            this.facetsAsMap = localFacetsAsMap;
        }
        return this.facetsAsMap;
    }

    public T peek() {
        T result = this.get(0);
        return result;
    }

    public T get(int i) {
        T result = this.results.get(i);
        return result;
    }

    public List<T> getAll() {
        return this.results;
    }

    public int size() {
        int result = this.results.size();
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> result = this.getAll().iterator();
        return result;
    }

    public String toString() {
        String result = this.getQueryString() + " results " + this.getAll();
        if (!this.getFacetNames().isEmpty()) {
            result = result + "\nfacets " + this.getFacets();
        }
        return result;
    }
}

