/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

public class ExtensionFactory {
    protected String name;
    protected String version;
    protected Map<String, String> tagValues;
    protected String requiredExtension;
    protected LinkedHashMap<String, FieldType> fields;

    protected ExtensionFactory(String name, String version) {
        this.name = name;
        this.version = version;
        this.fields = new LinkedHashMap();
    }

    public static ExtensionFactory create(String name, String version) {
        return new ExtensionFactory(name, version);
    }

    public FieldFactory addField(String name, FieldType.TYPE fieldType) {
        return new FieldFactory(this, name, fieldType);
    }

    public WikittyExtension extension() {
        WikittyExtension ext = new WikittyExtension(this.name, this.version, this.tagValues, this.requiredExtension, this.fields);
        return ext;
    }

    public ExtensionFactory addTagValues(Map<String, String> tagValues) {
        if (this.tagValues == null) {
            this.tagValues = new HashMap<String, String>();
        }
        this.tagValues.putAll(tagValues);
        return this;
    }

    public ExtensionFactory addTagValues(String tagValues) {
        if (this.tagValues == null) {
            this.tagValues = new HashMap<String, String>();
        }
        Map<String, String> tv = WikittyUtil.tagValuesToMap(tagValues);
        this.tagValues.putAll(tv);
        return this;
    }

    protected void add(String fieldName, FieldType fieldType) {
        this.fields.put(fieldName, fieldType);
    }
}

