package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class ProductEntityHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private ProductEntityHelper() {// empty
}

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_NAME);
        return value;
}

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_NAME, name);
        return oldValue;
}

    public static int getPrice(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_PRICE);
        return value;
}

    public static int setPrice(Wikitty wikitty, int price) {
        int oldValue = getPrice(wikitty);
        wikitty.setField(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_PRICE, price);
        return oldValue;
}

    public static Set<String> getColors(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_COLORS, String.class);
        return result;
}

    public static void setColors(Wikitty wikitty, Set<String> colors) {
        wikitty.setField(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_COLORS, colors);
}

    public static void addAllColors(Wikitty wikitty, Collection<String> colors) {
        if(colors != null){
            for (String v:colors){
                addColors(wikitty, v);
            }
        }
}

    public static void addColors(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_COLORS, v);
        }
}

    public static void removeColors(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_COLORS, v);
        }
}

    public static void clearColors(Wikitty wikitty) {
        wikitty.clearField(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_COLORS);
}

    public static String getCategoryEntity(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_CATEGORYENTITY);
        return value;
}

    public static String setCategoryEntity(Wikitty wikitty, String categoryEntity) {
        String oldValue = getCategoryEntity(wikitty);
        wikitty.setField(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_CATEGORYENTITY, categoryEntity);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_NAME);
            Object f2 = w2.getFieldAsObject(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_PRICE);
            Object f2 = w2.getFieldAsObject(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_PRICE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_COLORS);
            Object f2 = w2.getFieldAsObject(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_COLORS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_CATEGORYENTITY);
            Object f2 = w2.getFieldAsObject(ProductEntity.EXT_PRODUCTENTITY, ProductEntity.FIELD_PRODUCTENTITY_CATEGORYENTITY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(ProductEntity.EXT_PRODUCTENTITY);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : ProductEntityAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(ProductEntity.EXT_PRODUCTENTITY);
}

} //ProductEntityHelper
