package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class BirdHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private BirdHelper() {// empty
}

    public static int getFly(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Bird.EXT_BIRD, Bird.FIELD_BIRD_FLY);
        return value;
}

    public static int setFly(Wikitty wikitty, int fly) {
        int oldValue = getFly(wikitty);
        wikitty.setField(Bird.EXT_BIRD, Bird.FIELD_BIRD_FLY, fly);
        return oldValue;
}

    public static String getColor(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Bird.EXT_BIRD, Bird.FIELD_BIRD_COLOR);
        return value;
}

    public static String setColor(Wikitty wikitty, String color) {
        String oldValue = getColor(wikitty);
        wikitty.setField(Bird.EXT_BIRD, Bird.FIELD_BIRD_COLOR, color);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Bird.EXT_BIRD, Bird.FIELD_BIRD_FLY);
            Object f2 = w2.getFieldAsObject(Bird.EXT_BIRD, Bird.FIELD_BIRD_FLY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Bird.EXT_BIRD, Bird.FIELD_BIRD_COLOR);
            Object f2 = w2.getFieldAsObject(Bird.EXT_BIRD, Bird.FIELD_BIRD_COLOR);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Bird.EXT_BIRD);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : BirdAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(Bird.EXT_BIRD);
}

} //BirdHelper
