/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAuthorisationHelper;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyGroupHelper;
import org.nuiton.wikitty.entities.WikittyMetaExtensionUtil;
import org.nuiton.wikitty.entities.WikittyTokenHelper;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.query.WikittyQueryResultTreeNode;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyServiceDelegator;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyServiceAuthorisation
extends WikittyServiceDelegator {
    private static final Log log = LogFactory.getLog(WikittyServiceAuthorisation.class);
    private static final TimeLog timeLog = new TimeLog(WikittyServiceAuthorisation.class);
    public static final String PUBLIC = "all";
    protected transient String appAdminGroupId = null;

    public WikittyServiceAuthorisation(ApplicationConfig config, WikittyService ws) {
        super(ws);
        if (config != null) {
            long timeToLogInfo = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SERVICE_TIME_TO_LOG_INFO.getKey());
            long timeToLogWarn = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SERVICE_TIME_TO_LOG_WARN.getKey());
            timeLog.setTimeToLogInfo(timeToLogInfo);
            timeLog.setTimeToLogWarn(timeToLogWarn);
        }
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (this.isAppAdmin(securityToken, userId)) {
            WikittyEvent result = this.getDelegate().clear(securityToken);
            return result;
        }
        throw new SecurityException(String.format("user %s can't clear data", userId));
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        long start = TimeLog.getTime();
        String userId = this.getUserId(securityToken);
        for (WikittyEvent e : events) {
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_WIKITTY) || e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_EXTENSION)) {
                if (this.isAppAdmin(securityToken, userId)) break;
                throw new SecurityException(String.format("user %s can't replay data", userId));
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_WIKITTY)) {
                this.checkStore(securityToken, e.getWikitties().values());
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_WIKITTY)) {
                this.checkDelete(securityToken, e.getRemoveDate().keySet());
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_EXTENSION)) {
                this.checkStoreExtension(securityToken, e.getExtensions().values());
            }
            if (!e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_EXTENSION)) continue;
            this.checkDeleteExtension(securityToken, e.getDeletedExtensions());
        }
        timeLog.log(start, "replay");
        WikittyEvent result = this.getDelegate().replay(securityToken, events, force);
        return result;
    }

    protected boolean userIsAnonymousOrAppAdmin(String securityToken, String userId) {
        boolean userIsAnonymousOrAppAdmin = false;
        if (this.getAppAdminGroup(securityToken) == null) {
            if (securityToken == null) {
                userIsAnonymousOrAppAdmin = true;
            }
        } else if (this.isAppAdmin(securityToken, userId)) {
            userIsAnonymousOrAppAdmin = true;
        }
        return userIsAnonymousOrAppAdmin;
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        long start = TimeLog.getTime();
        this.checkStore(securityToken, wikitties);
        timeLog.log(start, "store");
        WikittyEvent result = this.getDelegate().store(securityToken, wikitties, force);
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        String userId = this.getUserId(securityToken);
        List<Wikitty> wikitties = this.getDelegate().restore(securityToken, ids);
        long start = TimeLog.getTime();
        for (Wikitty wikitty : wikitties) {
            if (wikitty == null) continue;
            this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        }
        timeLog.log(start, "restore");
        return wikitties;
    }

    @Override
    public List<WikittyQueryResult<Map<String, Object>>> findAllByQuery(String securityToken, List<WikittyQuery> queries) {
        ArrayList<WikittyQuery> qs = new ArrayList<WikittyQuery>(queries.size());
        for (WikittyQuery q : queries) {
            if (q != null && q.isCheckAuthorisation()) {
                q = this.addAuthorisationCondition(q);
            }
            qs.add(q);
        }
        return super.findAllByQuery(securityToken, qs);
    }

    @Override
    public List<Map<String, Object>> findByQuery(String securityToken, List<WikittyQuery> queries) {
        ArrayList<WikittyQuery> qs = new ArrayList<WikittyQuery>(queries.size());
        for (WikittyQuery q : queries) {
            if (q != null && q.isCheckAuthorisation()) {
                q = this.addAuthorisationCondition(q);
            }
            qs.add(q);
        }
        return super.findByQuery(securityToken, qs);
    }

    @Override
    public WikittyQueryResultTreeNode<String> findTreeNode(String securityToken, String wikittyId, int depth, boolean count, WikittyQuery filter) {
        if (filter != null && filter.isCheckAuthorisation()) {
            filter = this.addAuthorisationCondition(filter);
        }
        return super.findTreeNode(securityToken, wikittyId, depth, count, filter);
    }

    protected WikittyQuery addAuthorisationCondition(WikittyQuery q) {
        return q;
    }

    protected void checkStore(String securityToken, Collection<Wikitty> wikitties) {
        String userId = this.getUserId(securityToken);
        for (Wikitty wikitty : wikitties) {
            if (wikitty == null) continue;
            Wikitty oldVersion = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, wikitty.getWikittyId());
            ArrayList<String> newExtensions = new ArrayList<String>(wikitty.getExtensionNames());
            if (oldVersion != null) {
                newExtensions.removeAll(oldVersion.getExtensionNames());
            }
            for (String extensionName : newExtensions) {
                Wikitty extensionRights = this.restoreExtensionAuthorisation(securityToken, extensionName);
                boolean canCreate = extensionRights == null || this.canRead(securityToken, userId, null, extensionRights);
                if (canCreate) continue;
                throw new SecurityException(String.format("user %s can't create instance of extension %s", userId, extensionRights));
            }
            if (oldVersion == null) continue;
            for (String fqFieldDirtyName : wikitty.getDirty()) {
                boolean fieldRequireAdminRights;
                boolean canChange;
                String concernedExtensionName = WikittyUtil.getExtensionNameFromFQFieldName(fqFieldDirtyName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("will update field %s from extension %s", fqFieldDirtyName, concernedExtensionName));
                }
                if (canChange = (fieldRequireAdminRights = "WikittyAuthorisation".equals(concernedExtensionName) || "WikittyAuthorisation".equals(WikittyUtil.getMetaExtensionNameFromFQMetaExtensionName(concernedExtensionName))) ? this.canAdmin(securityToken, userId, concernedExtensionName, wikitty) : this.canWrite(securityToken, userId, concernedExtensionName, wikitty)) continue;
                throw new SecurityException(String.format("user %s can't write field %s on wikitty %s", userId, fqFieldDirtyName, wikitty));
            }
        }
    }

    protected void refuseUnauthorizedRead(String securityToken, String userId, Wikitty wikitty) {
        if (wikitty != null) {
            for (String extensionName : wikitty.getExtensionNames()) {
                if (this.canRead(securityToken, userId, extensionName, wikitty)) continue;
                throw new SecurityException(String.format("user %s can't read extension %s on wikitty %s, it may be due to a global policy on the wikitty", userId, extensionName, wikitty));
            }
        }
    }

    protected boolean canRead(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canRead = false;
        if (wikitty.hasMetaExtension("WikittyAuthorisation", extensionName)) {
            boolean bl = canRead = this.isReader(securityToken, userId, wikitty, extensionName) || this.canWrite(securityToken, userId, extensionName, wikitty);
        }
        canRead = !canRead && wikitty.hasExtension("WikittyAuthorisation") ? this.isReader(securityToken, userId, wikitty, null) || this.canWrite(securityToken, userId, extensionName, wikitty) : true;
        return canRead;
    }

    protected boolean canWrite(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canWrite = false;
        if (wikitty.hasMetaExtension("WikittyAuthorisation", extensionName)) {
            boolean bl = canWrite = this.isWriter(securityToken, userId, wikitty, extensionName) || this.canAdmin(securityToken, userId, extensionName, wikitty);
        }
        canWrite = !canWrite && wikitty.hasExtension("WikittyAuthorisation") ? this.isWriter(securityToken, userId, wikitty, null) || this.canAdmin(securityToken, userId, extensionName, wikitty) : true;
        return canWrite;
    }

    protected boolean canAdmin(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canAdmin = false;
        if (wikitty.hasMetaExtension("WikittyAuthorisation", extensionName)) {
            boolean bl = canAdmin = this.isAdmin(securityToken, userId, wikitty, extensionName) || this.isOwner(securityToken, userId, wikitty, extensionName);
        }
        if (!canAdmin && wikitty.hasExtension("WikittyAuthorisation")) {
            boolean bl = canAdmin = this.isAdmin(securityToken, userId, wikitty, null) || this.isOwner(securityToken, userId, wikitty, null);
        }
        if (!canAdmin) {
            canAdmin = this.isAppAdmin(securityToken, userId);
        }
        return canAdmin;
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        long start = TimeLog.getTime();
        this.checkDelete(securityToken, ids);
        timeLog.log(start, "delete");
        WikittyEvent result = this.getDelegate().delete(securityToken, ids);
        return result;
    }

    public void checkDelete(String securityToken, Collection<String> ids) {
        String userId = this.getUserId(securityToken);
        ArrayList<String> idsAsList = new ArrayList<String>(ids);
        List<Wikitty> wikitties = this.getDelegate().restore(securityToken, idsAsList);
        for (Wikitty wikitty : wikitties) {
            if (wikitty == null) continue;
            for (String extensionName : wikitty.getExtensionNames()) {
                if (this.canWrite(securityToken, userId, extensionName, wikitty)) continue;
                throw new SecurityException(String.format("user %s doesn't have rights on extension %s on wikitty %s", userId, extensionName, wikitty));
            }
        }
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        boolean result = true;
        String userId = this.getUserId(securityToken);
        for (String extName : wikitty.getExtensionNames()) {
            if (result = result && this.isWriter(securityToken, userId, wikitty, extName)) continue;
            break;
        }
        return result;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        boolean result = true;
        Wikitty wikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, wikittyId);
        if (wikitty != null) {
            String userId = this.getUserId(securityToken);
            for (String extName : wikitty.getExtensionNames()) {
                if (result = result && this.isWriter(securityToken, userId, wikitty, extName)) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        boolean result = true;
        String userId = this.getUserId(securityToken);
        Wikitty wikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, wikittyId);
        if (wikitty == null) {
            result = false;
        } else {
            for (String extName : wikitty.getExtensionNames()) {
                if (result = result && this.isReader(securityToken, userId, wikitty, extName)) continue;
                break;
            }
        }
        return result;
    }

    protected void checkStoreExtension(String securityToken, Collection<WikittyExtension> exts) {
        String userId = this.getUserId(securityToken);
        if (!this.isAppAdmin(securityToken, userId)) {
            for (WikittyExtension extension : exts) {
                boolean canWrite;
                Wikitty extensionAuthorisation = this.restoreExtensionAuthorisation(securityToken, extension.getName());
                if (extensionAuthorisation == null || (canWrite = this.canWrite(securityToken, userId, null, extensionAuthorisation))) continue;
                throw new SecurityException(String.format("user %s don't have write right for extension %s", userId, extension));
            }
        }
    }

    protected void checkDeleteExtension(String securityToken, Collection<String> extNames) {
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        long start = TimeLog.getTime();
        this.checkStoreExtension(securityToken, exts);
        timeLog.log(start, "storeExtension");
        return this.getDelegate().storeExtension(securityToken, exts);
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        long start = TimeLog.getTime();
        this.checkDeleteExtension(securityToken, extNames);
        timeLog.log(start, "deleteExtension");
        return this.getDelegate().deleteExtension(securityToken, extNames);
    }

    private void checkRestoreTreeNode(String securityToken, String userId, WikittyTreeNode treeNode) {
        Wikitty treeNodeWikitty = WikittyUtil.getWikitty(this.getDelegate(), securityToken, treeNode);
        this.refuseUnauthorizedRead(securityToken, userId, treeNodeWikitty);
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String treeNodeId) {
        Wikitty treeNodeWikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, treeNodeId);
        long start = TimeLog.getTime();
        List<Wikitty> wikitties = Collections.singletonList(treeNodeWikitty);
        this.checkStore(securityToken, wikitties);
        timeLog.log(start, "deleteTree");
        return this.getDelegate().deleteTree(securityToken, treeNodeId);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        Wikitty wikitty = this.getDelegate().restoreVersion(securityToken, wikittyId, version);
        long start = TimeLog.getTime();
        String userId = this.getUserId(securityToken);
        this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        timeLog.log(start, "restoreVersion");
        return wikitty;
    }

    @Override
    public void syncSearchEngine(String securityToken) {
        long start = TimeLog.getTime();
        String userId = this.getUserId(securityToken);
        if (!this.isAppAdmin(securityToken, userId)) {
            throw new SecurityException(String.format("user %s can't sync search engine", this.getUserId(securityToken)));
        }
        timeLog.log(start, "syncSearchEngine");
        this.getDelegate().syncSearchEngine(securityToken);
    }

    protected String getUserId(String securityToken) {
        String result = null;
        if (securityToken != null) {
            Wikitty securityTokenWikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, securityToken);
            if (securityTokenWikitty == null) {
                throw new SecurityException("bad (obsolete ?) token");
            }
            result = WikittyTokenHelper.getUser(securityTokenWikitty);
        }
        return result;
    }

    protected boolean isReader(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "reader");
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName, true);
        return result;
    }

    protected boolean isWriter(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "writer");
        log.trace((Object)("meta field name " + metaFieldName));
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName);
        return result;
    }

    protected boolean isAdmin(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "admin");
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName);
        return result;
    }

    protected boolean isOwner(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String fieldName;
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "owner");
        String actualExtensionName = WikittyUtil.getExtensionNameFromFQFieldName(metaFieldName);
        String owner = wikitty.getFieldAsString(actualExtensionName, fieldName = WikittyUtil.getFieldNameFromFQFieldName(metaFieldName));
        boolean isOwner = owner == null ? false : owner.equals(userId);
        return isOwner;
    }

    protected boolean isMember(String securityToken, String userId, Wikitty extensionRights, String fqFieldName) {
        return this.isMember(securityToken, userId, extensionRights, fqFieldName, false);
    }

    protected boolean isMember(String securityToken, String userId, Wikitty extensionRights, String fqFieldName, boolean considerEmptyGroupAsMembership) {
        boolean isMember;
        block1: {
            boolean groupOrUserIsEmpty;
            String extensionName = WikittyUtil.getExtensionNameFromFQFieldName(fqFieldName);
            String fieldName = WikittyUtil.getFieldNameFromFQFieldName(fqFieldName);
            Set<String> groupOrUser = extensionRights.getFieldAsSet(extensionName, fieldName, String.class);
            Set<String> parentsId = WikittyAuthorisationHelper.getParent(extensionRights);
            boolean bl = groupOrUserIsEmpty = groupOrUser == null || groupOrUser.isEmpty();
            isMember = groupOrUserIsEmpty ? considerEmptyGroupAsMembership && CollectionUtils.isEmpty(parentsId) : this.isMember(securityToken, userId, groupOrUser);
            if (isMember || !CollectionUtils.isNotEmpty(parentsId)) break block1;
            List<Wikitty> parents = this.getDelegate().restore(securityToken, new ArrayList<String>(parentsId));
            for (Wikitty parent : parents) {
                if (parent != null && (isMember = this.isMember(securityToken, userId, parent, fqFieldName, considerEmptyGroupAsMembership && groupOrUserIsEmpty))) break;
            }
        }
        return isMember;
    }

    protected boolean isAppAdmin(String securityToken, String userId) {
        boolean result = true;
        Wikitty group = this.getAppAdminGroup(securityToken);
        if (group != null) {
            Set<String> ids = WikittyGroupHelper.getMembers(group);
            result = this.isMember(securityToken, userId, ids);
        }
        return result;
    }

    protected Wikitty getAppAdminGroup(String securityToken) {
        Wikitty group = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, this.appAdminGroupId);
        if (group == null) {
            String groupId;
            WikittyQuery criteria = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyGroup.name", (Object)"WikittyAppAdmin")).end();
            this.appAdminGroupId = groupId = this.getClient(securityToken).findByQuery(criteria);
            group = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, this.appAdminGroupId);
        }
        return group;
    }

    protected boolean isMember(String securityToken, String userId, Set<String> groupOrUser) {
        if (groupOrUser != null) {
            for (String id : groupOrUser) {
                if (StringUtils.equals((CharSequence)id, (CharSequence)PUBLIC) || StringUtils.equals((CharSequence)id, (CharSequence)userId)) {
                    return true;
                }
                Wikitty groupWikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, id);
                if (groupWikitty == null || !WikittyGroupHelper.hasExtension(groupWikitty)) continue;
                Set<String> members = WikittyGroupHelper.getMembers(groupWikitty);
                return this.isMember(securityToken, userId, members);
            }
        }
        return false;
    }

    protected Wikitty restoreExtensionAuthorisation(String securityToken, WikittyExtension extension) {
        return this.restoreExtensionAuthorisation(securityToken, extension.getName());
    }

    protected Wikitty restoreExtensionAuthorisation(String securityToken, String extensionName) {
        String wikittyAuthorisationId = WikittyMetaExtensionUtil.generateId("WikittyAuthorisation", extensionName);
        Wikitty wikittyAuthorisation = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, wikittyAuthorisationId);
        if (wikittyAuthorisation == null) {
            log.debug((Object)(extensionName + " has no authorisation attached"));
        }
        return wikittyAuthorisation;
    }
}

