/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Arrays;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyToken;
import org.nuiton.wikitty.entities.WikittyTokenHelper;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.services.WikittySecurityUtil;
import org.nuiton.wikitty.services.WikittyServiceDelegator;

public abstract class WikittyServiceAuthenticationAbstract
extends WikittyServiceDelegator {
    private static Log log = LogFactory.getLog(WikittyServiceAuthenticationAbstract.class);
    private static final TimeLog timeLog = new TimeLog(WikittyServiceAuthenticationAbstract.class);
    protected ApplicationConfig config;

    public WikittyServiceAuthenticationAbstract(WikittyService delegate) {
        this(null, delegate);
    }

    public WikittyServiceAuthenticationAbstract(ApplicationConfig config, WikittyService delegate) {
        super(delegate);
        this.config = config;
        if (config != null) {
            long timeToLogInfo = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SERVICE_TIME_TO_LOG_INFO.getKey());
            long timeToLogWarn = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SERVICE_TIME_TO_LOG_WARN.getKey());
            timeLog.setTimeToLogInfo(timeToLogInfo);
            timeLog.setTimeToLogWarn(timeToLogWarn);
        }
    }

    @Override
    public abstract String login(String var1, String var2);

    protected String getToken(Wikitty user) {
        WikittyQuery query = ((WikittyQueryMaker)new WikittyQueryMaker().eq(WikittyToken.ELEMENT_FIELD_WIKITTYTOKEN_USER, (Object)user.getWikittyId())).end().setLimit(1);
        String tokenId = this.getAnonymousClient().findByQuery(query);
        if (tokenId != null && WikittySecurityUtil.isOutdated(this.config, this.getDelegate(), tokenId)) {
            this.getDelegate().delete(tokenId, Arrays.asList(tokenId));
            tokenId = null;
        }
        if (tokenId == null) {
            tokenId = WikittyUtil.genSecurityTokenId();
            WikittyImpl wikittyToken = new WikittyImpl(tokenId);
            WikittyTokenHelper.addExtension(wikittyToken);
            WikittyTokenHelper.setUser((Wikitty)wikittyToken, user.getWikittyId());
            WikittyTokenHelper.setDate(wikittyToken, new Date());
            this.getDelegate().store(null, Arrays.asList(wikittyToken), false);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("token '%s' is for login '%s'", tokenId, WikittyUserHelper.getLogin(user)));
            }
        }
        return tokenId;
    }

    @Override
    public void logout(String securityToken) {
        long start = TimeLog.getTime();
        if (securityToken != null) {
            this.getDelegate().delete(securityToken, Arrays.asList(securityToken));
        }
        timeLog.log(start, "logout");
    }
}

