/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyI18nAbstract;

public class WikittyI18nImpl
extends WikittyI18nAbstract
implements PropertyChangeListener {
    private static final long serialVersionUID = 3824481585361443459L;
    private static Log log = LogFactory.getLog(WikittyI18nImpl.class);
    protected transient Map<String, Map<String, String>> translationsCache = null;

    public WikittyI18nImpl() {
    }

    public WikittyI18nImpl(Wikitty wikitty) {
        super(wikitty);
    }

    public WikittyI18nImpl(BusinessEntityImpl businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
    }

    public WikittyI18nImpl(WikittyExtension extension, Wikitty wikitty) {
        this(wikitty);
        this.setExtensionForMetaExtension(extension);
    }

    @Override
    public void setWikitty(Wikitty wikitty) {
        if (this.wikitty != null) {
            this.wikitty.removePropertyChangeListener("WikittyI18n.translations", this);
        }
        super.setWikitty(wikitty);
        if (this.wikitty != null) {
            this.wikitty.addPropertyChangeListener("WikittyI18n.translations", this);
        }
    }

    @Override
    public String getTranslation(String lang, String field) {
        Map<String, String> l;
        this.parseAndCacheTranslations();
        String result = null;
        if (this.translationsCache != null && (l = this.translationsCache.get(lang)) != null) {
            result = l.get(field);
        }
        if (result == null) {
            result = field;
        }
        return result;
    }

    @Override
    public void setTranslation(String lang, String field, String trad) {
        this.parseAndCacheTranslations();
        this.putInTranslationCache(lang, field, trad);
        Map<String, Map<String, String>> tmp = this.translationsCache;
        String trans = this.convertToString(tmp);
        this.setTranslations(trans);
        this.translationsCache = tmp;
        if (this.getLang() == null || !this.getLang().contains(lang)) {
            this.addLang(lang);
        }
    }

    protected void parseAndCacheTranslations() {
        if (this.translationsCache == null) {
            String[] langsFields;
            String trans = this.getTranslations();
            for (String langFields : langsFields = StringUtil.split((String)trans, (String)",")) {
                String[] fields;
                langFields = langFields.substring(1, langFields.length() - 1);
                int colonPos = langFields.indexOf(":");
                String lang = langFields.substring(0, colonPos);
                langFields = langFields.substring(colonPos + 1);
                for (String field : fields = StringUtil.split((String)langFields, (String)",")) {
                    String[] fieldNameAndTrad = StringUtil.split((String)field, (String)"=");
                    String fieldName = fieldNameAndTrad[0];
                    String fieldTrad = fieldNameAndTrad[1];
                    fieldName = fieldName.substring(1, fieldName.length() - 1);
                    fieldTrad = fieldTrad.substring(1, fieldTrad.length() - 1);
                    this.putInTranslationCache(lang, fieldName, fieldTrad);
                }
            }
        }
    }

    protected void putInTranslationCache(String lang, String field, String trans) {
        Map<String, String> l;
        if (this.translationsCache == null) {
            this.translationsCache = new HashMap<String, Map<String, String>>();
        }
        if ((l = this.translationsCache.get(lang)) == null) {
            l = new HashMap<String, String>();
            this.translationsCache.put(lang, l);
        }
        l.put(field, trans);
    }

    protected String convertToString(Map<String, Map<String, String>> trans) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> l : trans.entrySet()) {
            String lang = l.getKey();
            result.append("[" + lang + ":");
            for (Map.Entry<String, String> t : l.getValue().entrySet()) {
                result.append("\"" + t.getKey() + "\"=\"" + t.getValue() + "\",");
            }
            if (result.charAt(result.length() - 1) == ',') {
                result.deleteCharAt(result.length() - 1);
            }
            result.append("],");
        }
        if (result.charAt(result.length() - 1) == ',') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("WikittyI18n.translations".equals(propName)) {
            this.translationsCache = null;
        }
    }
}

