/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  class WikittyUserHelper {

    /**
     * WikittyUserHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyUserHelper() {// empty
}

    /**
     * getLogin :
     * @param wikitty 
     * @return String 
     */

    public static String getLogin(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
        return value;
}

    /**
     * setLogin :
     * @param wikitty 
     * @param login 
     * @return String 
     */

    public static String setLogin(Wikitty wikitty, String login) {
        String oldValue = getLogin(wikitty);
        wikitty.setField(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN, login);
        return oldValue;
}

    /**
     * getPassword :
     * @param wikitty 
     * @return String 
     */

    public static String getPassword(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
        return value;
}

    /**
     * setPassword :
     * @param wikitty 
     * @param password 
     * @return String 
     */

    public static String setPassword(Wikitty wikitty, String password) {
        String oldValue = getPassword(wikitty);
        wikitty.setField(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD, password);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
            Object f2 = w2.getFieldAsObject(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
            Object f2 = w2.getFieldAsObject(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyUser.EXT_WIKITTYUSER);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyUserAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyUserHelper
