/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class WikittyTreeNodeAbstract extends BusinessEntityImpl implements WikittyTreeNode {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyTreeNode;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = WikittyTreeNodeHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        WikittyTreeNodeHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME, oldValue, getName());
}

    /**
     * getAttachment :
     * @return Set<String> 
     */

    @Override
    public Set<String> getAttachment() {
        Set<String> result = WikittyTreeNodeHelper.getAttachment(getWikitty());
        return result;
}

    /**
     * setAttachment :
     * @param attachment 
     */

    @Override
    public void setAttachment(Set<String> attachment) {
        Set<String> oldValue = getAttachment();
        WikittyTreeNodeHelper.setAttachment(getWikitty(), attachment);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, oldValue, getAttachment());
}

    /**
     * addAllAttachment :
     * @param attachment 
     */

    @Override
    public void addAllAttachment(Set<String> attachment) {
        Set<String> oldValue = getAttachment();
        WikittyTreeNodeHelper.addAllAttachment(getWikitty(), attachment);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, oldValue, getAttachment());
}

    /**
     * addAttachment :
     * @param element 
     */

    @Override
    public void addAttachment(String element) {
        WikittyTreeNodeHelper.addAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * removeAttachment :
     * @param element 
     */

    @Override
    public void removeAttachment(String element) {
        WikittyTreeNodeHelper.removeAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * clearAttachment :
     */

    @Override
    public void clearAttachment() {
        WikittyTreeNodeHelper.clearAttachment(getWikitty());
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * getParent :
     * @return String 
     */

    @Override
    public String getParent() {
        String value = WikittyTreeNodeHelper.getParent(getWikitty());
        return value;
}

    /**
     * setParent :
     * @param parent 
     */

    @Override
    public void setParent(String parent) {
        String oldValue = getParent();
        WikittyTreeNodeHelper.setParent(getWikitty(), parent);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT, oldValue, getParent());
}

    /**
     * WikittyTreeNodeAbstract :
     */

    public WikittyTreeNodeAbstract() {
        super();
}

    /**
     * WikittyTreeNodeAbstract :
     * @param wikitty 
     */

    public WikittyTreeNodeAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyTreeNodeAbstract :
     * @param businessEntityImpl 
     */

    public WikittyTreeNodeAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyTreeNode =
                new WikittyExtension(EXT_WIKITTYTREENODE,
                                     "2.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=\"true\"", 
                                             "Wikitty attachment[0-*] unique=\"true\" version=\"2.0\"", 
                                             "Wikitty parent unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyTreeNode);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyTreeNodeAbstract
