/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class WikittyI18nAbstract extends BusinessEntityImpl implements WikittyI18n {

    /**
     * the metaExtension operations target this extension, may be null
     */
    protected WikittyExtension extensionForMetaExtension;
    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyI18n;
    /**
     * setExtensionForMetaExtension :
     * add WikittyI18n meta-extension on given extension to this entity
     * @param extension 
     */

    public void setExtensionForMetaExtension(WikittyExtension extension) {
        extensionForMetaExtension = extension;
        WikittyI18nHelper.addMetaExtension(extension, getWikitty());
}

    /**
     * getTranslatableValues :
     * @return Set<String> 
     */

    @Override
    public Set<String> getTranslatableValues() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyI18nHelper.getTranslatableValues(getWikitty());
        } else {
            result = WikittyI18nHelper.getTranslatableValues(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    /**
     * setTranslatableValues :
     * @param values 
     */

    @Override
    public void setTranslatableValues(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.setTranslatableValues(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, null, getTranslatableValues());
        } else {
            WikittyI18nHelper.setTranslatableValues(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getTranslatableValues());
        }
}

    /**
     * addAllTranslatableValues :
     * @param values 
     */

    @Override
    public void addAllTranslatableValues(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.addAllTranslatableValues(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, null, getTranslatableValues());
        } else {
            WikittyI18nHelper.addAllTranslatableValues(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getTranslatableValues());
        }
}

    /**
     * addTranslatableValues :
     * @param element 
     */

    @Override
    public void addTranslatableValues(String element) {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.addTranslatableValues(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, null, getTranslatableValues());
        } else {
            WikittyI18nHelper.addTranslatableValues(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getTranslatableValues());
        }
}

    /**
     * removeTranslatableValues :
     * @param element 
     */

    @Override
    public void removeTranslatableValues(String element) {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.removeTranslatableValues(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, null, getTranslatableValues());
        } else {
            WikittyI18nHelper.removeTranslatableValues(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getTranslatableValues());
        }
}

    /**
     * clearTranslatableValues :
     */

    @Override
    public void clearTranslatableValues() {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.clearTranslatableValues(getWikitty());
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, null, getTranslatableValues());
        } else {
            WikittyI18nHelper.clearTranslatableValues(extensionForMetaExtension.getName(), getWikitty());
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translatableValues");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getTranslatableValues());
        }
}

    /**
     * getLang :
     * @return Set<String> 
     */

    @Override
    public Set<String> getLang() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyI18nHelper.getLang(getWikitty());
        } else {
            result = WikittyI18nHelper.getLang(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    /**
     * setLang :
     * @param values 
     */

    @Override
    public void setLang(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.setLang(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_LANG, null, getLang());
        } else {
            WikittyI18nHelper.setLang(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getLang());
        }
}

    /**
     * addAllLang :
     * @param values 
     */

    @Override
    public void addAllLang(Set<String> values) {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.addAllLang(getWikitty(), values);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_LANG, null, getLang());
        } else {
            WikittyI18nHelper.addAllLang(extensionForMetaExtension.getName(), getWikitty(), values);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getLang());
        }
}

    /**
     * addLang :
     * @param element 
     */

    @Override
    public void addLang(String element) {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.addLang(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_LANG, null, getLang());
        } else {
            WikittyI18nHelper.addLang(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getLang());
        }
}

    /**
     * removeLang :
     * @param element 
     */

    @Override
    public void removeLang(String element) {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.removeLang(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_LANG, null, getLang());
        } else {
            WikittyI18nHelper.removeLang(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getLang());
        }
}

    /**
     * clearLang :
     */

    @Override
    public void clearLang() {
        if (extensionForMetaExtension == null) {
            WikittyI18nHelper.clearLang(getWikitty());
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_LANG, null, getLang());
        } else {
            WikittyI18nHelper.clearLang(extensionForMetaExtension.getName(), getWikitty());
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "lang");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getLang());
        }
}

    /**
     * getTranslations :
     * @return String 
     */

    @Override
    public String getTranslations() {
        String value;
        if (extensionForMetaExtension == null) {
            value = WikittyI18nHelper.getTranslations(getWikitty());
        } else {
            value = WikittyI18nHelper.getTranslations(extensionForMetaExtension.getName(), getWikitty());
        }
        return value;
}

    /**
     * setTranslations :
     * @param translations 
     */

    @Override
    public void setTranslations(String translations) {
        String oldValue;
        if (extensionForMetaExtension == null) {
            oldValue = getTranslations();
            WikittyI18nHelper.setTranslations(getWikitty(), translations);
            getPropertyChangeSupport().firePropertyChange(WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS, oldValue, getTranslations());
        } else {
            oldValue = getTranslations();
            WikittyI18nHelper.setTranslations(extensionForMetaExtension.getName(), getWikitty(), translations);
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionForMetaExtension, "translations");
            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getTranslations());
        }
}

    /**
     * WikittyI18nAbstract :
     */

    public WikittyI18nAbstract() {
        super();
}

    /**
     * WikittyI18nAbstract :
     * @param wikitty 
     */

    public WikittyI18nAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyI18nAbstract :
     * @param businessEntityImpl 
     */

    public WikittyI18nAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyI18n =
                new WikittyExtension(EXT_WIKITTYI18N,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String translatableValues[0-*] unique=\"true\"", 
                                             "String lang[0-*] unique=\"true\"", 
                                             "String translations unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyI18n);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyI18nAbstract
