/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyExtensionMigration;
import org.nuiton.wikitty.services.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.services.WikittyListener;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyExtensionStorage;
import org.nuiton.wikitty.storage.WikittySearchEngine;
import org.nuiton.wikitty.storage.WikittyStorage;

public class WikittyServiceStorage
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceStorage.class);
    protected WikittyExtensionMigration defaultExtensionMigration = new WikittyExtensionMigrationRename();
    protected WikittySearchEngine searchEngine;
    protected WikittyExtensionStorage extensionStorage;
    protected WikittyStorage wikittyStorage;

    protected WikittyServiceStorage() {
    }

    public WikittyServiceStorage(WikittyExtensionStorage extensionStorage, WikittyStorage wikittyStorage, WikittySearchEngine searchEngine) {
        this.extensionStorage = extensionStorage;
        this.wikittyStorage = wikittyStorage;
        this.searchEngine = searchEngine;
    }

    public WikittySearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public WikittyExtensionStorage getExtensionStorage() {
        return this.extensionStorage;
    }

    public WikittyStorage getWikittyStorage() {
        return this.wikittyStorage;
    }

    @Override
    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("Can't add listener on " + WikittyServiceStorage.class.getName());
    }

    @Override
    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("Can't remove listener on " + WikittyServiceStorage.class.getName());
    }

    @Override
    public String login(String login, String password) {
        log.warn((Object)"login asked, but there is no security service");
        return null;
    }

    @Override
    public void logout(String securityToken) {
        log.warn((Object)"logout asked, but there is no security service");
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return true;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return true;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return true;
    }

    protected void checkConstraint(Collection<Wikitty> wikitties) {
        for (Wikitty w : wikitties) {
            for (WikittyExtension ext : w.getExtensions()) {
                for (String fieldName : ext.getFieldNames()) {
                    FieldType type = ext.getFieldType(fieldName);
                    if (!type.isNotNull() || null != w.getFieldAsObject(ext.getName(), fieldName)) continue;
                    throw new WikittyException(String.format("Field '%s' must not be null", fieldName));
                }
            }
        }
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        if (!(wikitties instanceof Set)) {
            wikitties = new LinkedHashSet<Wikitty>(wikitties);
        }
        this.checkConstraint(wikitties);
        LinkedHashSet<WikittyExtension> allExtensions = new LinkedHashSet<WikittyExtension>();
        for (Wikitty w : wikitties) {
            allExtensions.addAll(w.getExtensions());
        }
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            WikittyEvent extUpdate = this.getExtensionStorage().store(tx, allExtensions);
            WikittyEvent wikUpdate = this.getWikittyStorage().store(tx, wikitties, force);
            this.getSearchEngine().store(tx, wikitties);
            WikittyEvent result = new WikittyEvent(this);
            result.add(extUpdate);
            result.add(wikUpdate);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't store wikitty", eee);
        }
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            List<String> result = this.getExtensionStorage().getAllExtensionIds(tx);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't retrieve all extension's ids", eee);
        }
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            List<String> result = this.getExtensionStorage().getAllExtensionsRequires(tx, extensionName);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException(String.format("Can't retrieve all required extension for %s", extensionName), eee);
        }
    }

    protected void checkExtension(Collection<WikittyExtension> exts) {
        for (WikittyExtension ext : exts) {
            if (WikittyUtil.versionGreaterThan("0", ext.getVersion())) {
                throw new WikittyException(String.format("Invalide extension version %s", ext.getVersion()));
            }
            if (!ext.getName().matches("\\w+")) {
                throw new WikittyException(String.format("Invalide extension name %s", ext.getName()));
            }
            for (String fieldName : ext.getFieldNames()) {
                if (fieldName.matches("\\w+")) continue;
                throw new WikittyException(String.format("Invalide extension field name '%s' for extension '%s'", fieldName, ext.getName()));
            }
        }
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            this.checkExtension(exts);
            WikittyEvent result = this.getExtensionStorage().store(tx, exts);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't store extensions", eee);
        }
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            for (String name : extNames) {
                Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, name).criteria();
                criteria.setEndIndex(0);
                PagedResult<String> wikittyWithExt = this.findAllByCriteria(securityToken, criteria);
                int numFound = wikittyWithExt.getNumFound();
                if (numFound <= 0) continue;
                throw new WikittyException(String.format("Can't delete %s extension, this extension is in used by %s wikitty", name, numFound));
            }
            WikittyEvent result = this.getExtensionStorage().delete(tx, extNames);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't delete extensions", eee);
        }
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String extensionId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            String name = WikittyExtension.computeName(extensionId);
            String version = WikittyExtension.computeVersion(extensionId);
            WikittyExtension result = this.getExtensionStorage().restore(tx, name, version);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore extensions", eee);
        }
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            String version;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            if ((version = this.getExtensionStorage().getLastVersion(tx, name)) == null) {
                if (txBeginHere) {
                    tx.commit();
                }
                return null;
            }
            WikittyExtension result = this.getExtensionStorage().restore(tx, name, version);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't store extensions", eee);
        }
    }

    protected Wikitty restore(String securityToken, String id) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            if (id == null) {
                return null;
            }
            if (!this.getWikittyStorage().exists(tx, id)) {
                return null;
            }
            if (this.getWikittyStorage().isDeleted(tx, id)) {
                return null;
            }
            Wikitty result = this.getWikittyStorage().restore(tx, id, new String[0]);
            if (result != null) {
                result = this.upgradeData(securityToken, result);
            }
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't store extensions", eee);
        }
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        ArrayList<Wikitty> result = new ArrayList<Wikitty>();
        WikittyTransaction transaction = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!transaction.isStarted()) {
                transaction.begin();
                txBeginHere = true;
            }
            for (String id : ids) {
                Wikitty w = this.restore(securityToken, id);
                result.add(w);
            }
            if (txBeginHere) {
                transaction.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new WikittyException("Can't restore wikitty", eee);
        }
    }

    protected Wikitty upgradeData(String securityToken, Wikitty wikitty) {
        Wikitty result = wikitty;
        Collection<WikittyExtension> extensions = wikitty.getExtensions();
        for (WikittyExtension extension : extensions) {
            WikittyExtensionMigration migration;
            String extensionName = extension.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("extensionName=" + extensionName));
            }
            WikittyExtension currentExtension = extension;
            String currentExtensionVersion = currentExtension.getVersion();
            WikittyExtension lastExtension = this.restoreExtensionLastVersion(securityToken, extensionName);
            String lastExtensionVersion = lastExtension.getVersion();
            if (log.isDebugEnabled()) {
                log.debug((Object)("lastExtensionVersion=" + lastExtensionVersion));
            }
            if ((migration = WikittyExtensionMigration.migrationRegistry.get(extensionName)) == null) {
                migration = this.defaultExtensionMigration;
            }
            while (WikittyUtil.versionGreaterThan(lastExtensionVersion, currentExtensionVersion)) {
                String nextExtensionVersion = WikittyUtil.incrementMajorRevision(currentExtensionVersion);
                String nextExtensionId = WikittyExtension.computeId(extensionName, nextExtensionVersion);
                WikittyExtension nextExtension = this.restoreExtension(securityToken, nextExtensionId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("currentExtensionVersion=" + currentExtensionVersion));
                    log.debug((Object)("nextExtensionVersion=" + nextExtensionVersion));
                }
                if (nextExtension != null) {
                    result = migration.migrate(this, result, currentExtension, nextExtension);
                    currentExtension = nextExtension;
                }
                currentExtensionVersion = nextExtensionVersion;
            }
        }
        return result;
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) throws WikittyException {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            LinkedHashSet<Wikitty> storedWikitties = new LinkedHashSet<Wikitty>();
            LinkedHashSet<String> idSet = new LinkedHashSet<String>(ids);
            Iterator i = idSet.iterator();
            while (i.hasNext()) {
                Wikitty treeNode;
                String id = (String)i.next();
                if (!this.getWikittyStorage().exists(tx, id)) {
                    i.remove();
                    continue;
                }
                if (this.getWikittyStorage().isDeleted(tx, id)) {
                    i.remove();
                    continue;
                }
                Criteria criteria = Search.query().eq("WikittyTreeNode.parent", id).criteria();
                List<String> wikittyNodesId = this.findAllByCriteria(securityToken, criteria).getAll();
                for (String wikittyNodeId : wikittyNodesId) {
                    if (idSet.contains(wikittyNodeId)) continue;
                    treeNode = this.restore(securityToken, wikittyNodeId);
                    WikittyTreeNodeHelper.setParent(treeNode, null);
                    storedWikitties.add(treeNode);
                }
                criteria = Search.query().eq("WikittyTreeNode.attachment", id).criteria();
                wikittyNodesId = this.findAllByCriteria(securityToken, criteria).getAll();
                for (String wikittyNodeId : wikittyNodesId) {
                    if (idSet.contains(wikittyNodeId)) continue;
                    treeNode = this.restore(securityToken, wikittyNodeId);
                    WikittyTreeNodeHelper.removeAttachment(treeNode, id);
                    storedWikitties.add(treeNode);
                }
            }
            WikittyEvent eventDelete = this.getWikittyStorage().delete(tx, idSet);
            this.getSearchEngine().delete(tx, idSet);
            WikittyEvent eventStore = this.store(securityToken, storedWikitties, false);
            WikittyEvent result = new WikittyEvent(this);
            result.add(eventDelete);
            result.add(eventStore);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't delete wikitty", eee);
        }
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            this.getSearchEngine().clear(tx);
            WikittyEvent eventWik = this.getWikittyStorage().clear(tx);
            WikittyEvent eventExt = this.getExtensionStorage().clear(tx);
            WikittyEvent result = new WikittyEvent(this);
            result.add(eventWik);
            result.add(eventExt);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't clear all data", eee);
        }
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            PagedResult<String> result = this.getSearchEngine().findAllByCriteria(tx, criteria);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Error during find", eee);
        }
    }

    @Override
    public String findByCriteria(String securityToken, Criteria criteria) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            criteria.setFirstIndex(0).setEndIndex(1);
            PagedResult<String> pages = this.findAllByCriteria(securityToken, criteria);
            String result = null;
            if (pages.size() > 0) {
                result = pages.getFirst();
            }
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Error during find", eee);
        }
    }

    @Override
    public WikittyTree restoreTree(String securityToken, String wikittyId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            Wikitty w;
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            if ((w = this.restore(securityToken, wikittyId)) == null) {
                if (txBeginHere) {
                    tx.commit();
                }
                return null;
            }
            if (!w.hasExtension("WikittyTreeNode")) {
                throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "WikittyTreeNode"));
            }
            WikittyTree tree = new WikittyTree();
            WikittyTreeNodeImpl node = new WikittyTreeNodeImpl(w);
            tree.setNode(node);
            WikittyTreeNodeImpl exempleNode = new WikittyTreeNodeImpl();
            exempleNode.setParent(wikittyId);
            Criteria criteria = Search.query(exempleNode.getWikitty()).criteria().setFirstIndex(0).setEndIndex(-1);
            PagedResult<String> childNodesId = this.findAllByCriteria(securityToken, criteria);
            for (String childNodeId : childNodesId.getAll()) {
                tree.addChild(this.restoreTree(securityToken, childNodeId));
            }
            if (txBeginHere) {
                tx.commit();
            }
            return tree;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore tree", eee);
        }
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String thesaurusId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            List<String> allTreeNodeId = this.getRecursiveTreeNodeId(securityToken, thesaurusId);
            WikittyEvent result = this.delete(securityToken, allTreeNodeId);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't delete tree", eee);
        }
    }

    protected List<String> getRecursiveTreeNodeId(String securityToken, String treeNodeId) {
        Search search = Search.query();
        search = search.eq("WikittyTreeNode.parent", treeNodeId);
        Criteria criteria = search.criteria();
        PagedResult<String> childTreeNodeIds = this.findAllByCriteria(securityToken, criteria);
        ArrayList<String> treeNodeIds = new ArrayList<String>();
        treeNodeIds.add(treeNodeId);
        for (String childTreeNodeId : childTreeNodeIds.getAll()) {
            List<String> subTreeNodeIds = this.getRecursiveTreeNodeId(securityToken, childTreeNodeId);
            treeNodeIds.addAll(subTreeNodeIds);
        }
        return treeNodeIds;
    }

    @Override
    public Map.Entry<String, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            AbstractMap.SimpleEntry<String, Integer> result = null;
            Wikitty w = this.restore(securityToken, wikittyId);
            if (w != null) {
                if (!w.hasExtension("WikittyTreeNode")) {
                    throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "WikittyTreeNode"));
                }
                Integer count = this.getSearchEngine().findNodeCount(tx, w, filter);
                result = new AbstractMap.SimpleEntry<String, Integer>(wikittyId, count);
            }
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore node", eee);
        }
    }

    @Override
    public Map<String, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            Map<String, Integer> result = null;
            Wikitty w = this.restore(securityToken, wikittyId);
            if (w != null) {
                if (!w.hasExtension("WikittyTreeNode")) {
                    throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "WikittyTreeNode"));
                }
                result = this.getSearchEngine().findAllChildrenCount(tx, w, filter);
            }
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't restore children", eee);
        }
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void syncSearchEngine(final String securityToken) {
        final WikittyTransaction tx = WikittyTransaction.get();
        if (tx.isStarted()) {
            throw new WikittyException("Transaction must be not started for syncSearchEngine method");
        }
        boolean txBeginHere = false;
        try {
            int numberForCommit = 1000;
            final WikittySearchEngine searchEngine = this.getSearchEngine();
            final ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(1000);
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            searchEngine.clear(tx);
            if (txBeginHere) {
                tx.commit();
            }
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            this.getWikittyStorage().scanWikitties(tx, new WikittyStorage.Scanner(){
                int count = 0;

                @Override
                public void scan(String wikittyId) {
                    Wikitty wikitty = WikittyServiceStorage.this.restore(securityToken, wikittyId);
                    Date deleteDate = wikitty.getDeleteDate();
                    if (deleteDate == null) {
                        ++this.count;
                        wikitties.add(wikitty);
                        if (this.count == 1000) {
                            searchEngine.store(tx, wikitties);
                            tx.commit();
                            this.count = 0;
                            wikitties.clear();
                            tx.begin();
                        }
                    }
                }
            });
            searchEngine.store(tx, wikitties);
            if (txBeginHere) {
                tx.commit();
            }
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't sync searchable index with data", eee);
        }
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        boolean mustClear = false;
        LinkedHashMap<String, Wikitty> toAddWikitty = new LinkedHashMap<String, Wikitty>();
        LinkedHashMap toRemoveWikitty = new LinkedHashMap();
        LinkedHashSet<WikittyExtension> toAddExt = new LinkedHashSet<WikittyExtension>();
        LinkedHashSet<String> toDeleteExt = new LinkedHashSet<String>();
        for (WikittyEvent e : events) {
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_WIKITTY) || e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_EXTENSION)) {
                mustClear = true;
                toAddWikitty.clear();
                toRemoveWikitty.clear();
                toAddExt.clear();
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_WIKITTY)) {
                for (Wikitty wikitty : e.getWikitties().values()) {
                    toAddWikitty.put(wikitty.getId(), wikitty);
                }
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_WIKITTY)) {
                for (Map.Entry entry : e.getRemoveDate().entrySet()) {
                    toAddWikitty.remove(entry.getKey());
                    toRemoveWikitty.put(entry.getKey(), entry.getValue());
                }
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_EXTENSION)) {
                for (WikittyExtension wikittyExtension : e.getExtensions().values()) {
                    toAddExt.add(wikittyExtension);
                }
            }
            if (!e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_EXTENSION)) continue;
            for (String string : e.getDeletedExtensions()) {
                toDeleteExt.add(string);
            }
        }
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            WikittyEvent result = new WikittyEvent(this);
            if (mustClear) {
                WikittyEvent wikittyEvent = this.clear(securityToken);
                result.add(wikittyEvent);
            }
            WikittyEvent wikittyEvent = this.storeExtension(securityToken, toAddExt);
            result.add(wikittyEvent);
            WikittyEvent eventDeleteExtension = this.deleteExtension(securityToken, toDeleteExt);
            result.add(eventDeleteExtension);
            WikittyEvent eventStoreWikitty = this.store(securityToken, toAddWikitty.values(), force);
            result.add(eventStoreWikitty);
            WikittyEvent eventDeleteWikitty = this.delete(securityToken, toRemoveWikitty.keySet());
            result.add(eventDeleteWikitty);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't replay data", eee);
        }
    }

    @Override
    public boolean exists(String securityToken, String wikittyId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            boolean result = this.getWikittyStorage().exists(null, wikittyId);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't test existance", eee);
        }
    }

    @Override
    public boolean isDeleted(String securityToken, String wikittyId) {
        WikittyTransaction tx = WikittyTransaction.get();
        boolean txBeginHere = false;
        try {
            if (!tx.isStarted()) {
                tx.begin();
                txBeginHere = true;
            }
            boolean result = this.getWikittyStorage().isDeleted(tx, wikittyId);
            if (txBeginHere) {
                tx.commit();
            }
            return result;
        }
        catch (WikittyException ex) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw ex;
        }
        catch (Exception eee) {
            if (tx != null && tx.isStarted()) {
                tx.rollback();
            }
            throw new WikittyException("Can't test existance", eee);
        }
    }
}

