/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: AbstractTestConformance.java 599 2010-12-11 00:56:27Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.5/wikitty-api/src/test/java/org/nuiton/wikitty/conform/AbstractTestConformance.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.conform;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map.Entry;

import junit.framework.Assert;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.FieldType.TYPE;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.WikittyUtil;

public abstract class AbstractTestConformance {
    
    public static final String EXTNAME = "wikittyExt";
    public static final String EXTREQUIRED = "wikittyRequired";
    public static final String EXTREQUIRES = "wikittyRequires";
    
    private final static Log log = LogFactory.getLog(AbstractTestConformance.class);
    
    public static final WikittyExtension EXT_REQUIRED =
        createExtension(EXTREQUIRED, null);
    
    public static final WikittyExtension EXT_REQUIRES =
        createExtension(EXTREQUIRES, EXTREQUIRED);
    
    public static final WikittyExtension EXT_TEST =
        createExtension(EXTNAME, null,
            createType(TYPE.STRING, 0, 1),
            createType(TYPE.NUMERIC, 1, 1),
            createType(TYPE.DATE, 1, 1)
        );

    private WikittyService ws;
    protected WikittyProxy proxy = null;

    abstract public ApplicationConfig getConfig();

    public WikittyProxy getProxy() {
        if (proxy == null) {
            proxy = new WikittyProxy(getWikittyService());
        }
        return proxy;
    }

    public WikittyService getWikittyService() {
        if (ws == null) {
            ws = WikittyServiceFactory.buildWikittyService(getConfig());
        }
        return ws;
    }
    
    public void setWikittyService(WikittyService wikittyService) {
        this.ws = wikittyService;
    }
    
    
    protected static FieldType createType( TYPE type, int lower, int upper ) {
        FieldType fieldType = new FieldType(type, lower, upper);
        return fieldType;
    }
    
    protected static Wikitty createBasicWikitty() {
        return createWikitty( EXT_TEST );
    }
    
    protected static Wikitty createWikitty( WikittyExtension... extensions ) {
        Wikitty w = new WikittyImpl();
        for ( WikittyExtension ext : extensions ) {
            w.addExtension( ext );
        }
        return w;
    }
    
    protected static WikittyExtension createExtension(String extName, String requires,
            FieldType... types) {
        LinkedHashMap<String, FieldType> fieldsMap = new LinkedHashMap<String, FieldType>();
        for ( int i = 0; i < types.length; i++ ) {
            fieldsMap.put( "fieldName" + i,  types[i] );
        }
        return new WikittyExtension(extName, "1", requires, fieldsMap);
    }
    
    public static String format(String dateTestFormat) {
        try {
            return WikittyUtil.formatDate(
                    dateTestFormat == null || dateTestFormat.isEmpty()
                    ? new Date()
                    : parse(dateTestFormat)
                );
        } catch (ParseException e) {
            Assert.fail( "Error format date : " + dateTestFormat );
            e.printStackTrace();
            return null;
        }
    }

    public static Date parse(String dateAsString) {
        try {
            return WikittyUtil.parseDate(dateAsString);
        } catch (ParseException e) {
            Assert.fail( "Error parsing date : " + dateAsString );
            e.printStackTrace();
            return null;
        }
    }
    
    protected static ArrayList<Wikitty> createSampleWikitty( WikittyService ws ) {
        ArrayList<Wikitty> result = new ArrayList<Wikitty>();
        String[] wValues = new String[] {
                // wikitty[ 0 ]
                "fieldName0 = table," +
                "fieldName1 = 003300," +
                "fieldName2 = " + format("23/01/1982"),

                // wikitty[ 1 ]
                "fieldName0 = chaise," +
                "fieldName1 = 113311," +
                "fieldName2 = " + format("26/09/2009"),

                // wikitty[ 2 ]
                "fieldName0 = bureau," +
                "fieldName1 = 223322," +
                "fieldName2 = " + format("25/12/2029")
        };
        for ( String wValue : wValues ) {
            Wikitty w = createWikitty( wValue, EXTNAME, EXT_TEST );
            result.add( w );
        }
        ws.store(null, result, false);
        return result;
    }
    
    

    public static Wikitty createWikitty( String values, String defaultExtName, WikittyExtension... exts ) {
        Wikitty w = new WikittyImpl();
        for (WikittyExtension ext : exts) {
            w.addExtension(ext);
        }
        for( Entry<String, String> keyValuePair : getKeyPairs(values) ) {
            String[] s = keyValuePair.getKey().split("\\.");
            String fieldName = null, extName = null;
            if ( s.length > 1 ) {
                fieldName = s[1].trim();
                extName = s[0].trim();
            }
            else {
                fieldName = s[0].trim();
                extName = defaultExtName;
            }
            w.setField(extName, fieldName, keyValuePair.getValue());
        }
        return w;
    }
    
    protected static Iterable<Entry<String, String>> getKeyPairs(String values) {
        LinkedHashMap<String, String> keyPairs = new LinkedHashMap<String, String>();
        for ( String keyValuePair : values.split(",") ) {
            String[] l = keyValuePair.split("=");
            String key = l[0].trim();
            String value = l.length > 1 ? l[1].trim() : null;
            keyPairs.put(key, value);
        }
        return keyPairs.entrySet();
    }
    
    
}
