/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.util.Date;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;

public class WikittyEvent
extends EventObject {
    private static final long serialVersionUID = 9017732163643700599L;
    protected long eventId;
    protected boolean remote;
    protected EnumSet<WikittyEventType> type;
    protected long time = System.currentTimeMillis();
    protected Map<String, Wikitty> wikitties;
    protected Map<String, Date> removeDate;
    protected Map<String, WikittyExtension> extensions;
    protected Set<String> deletedExtensions;

    public WikittyEvent(Object source) {
        super(source);
        this.type = EnumSet.noneOf(WikittyEventType.class);
    }

    public long getTime() {
        return this.time;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public EnumSet<WikittyEventType> getType() {
        return this.type;
    }

    public void addType(WikittyEventType type) {
        this.type.add(type);
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public long getEventId() {
        return this.eventId;
    }

    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    public Map<String, Wikitty> getWikitties() {
        return this.wikitties;
    }

    public void addWikitty(Wikitty wikitty) {
        if (this.wikitties == null) {
            this.wikitties = new LinkedHashMap<String, Wikitty>();
            this.addType(WikittyEventType.PUT_WIKITTY);
        }
        this.wikitties.put(wikitty.getId(), wikitty);
    }

    public Map<String, Date> getRemoveDate() {
        return this.removeDate;
    }

    public void addRemoveDate(String wikittyId, Date date) {
        if (this.removeDate == null) {
            this.removeDate = new HashMap<String, Date>();
            this.addType(WikittyEventType.REMOVE_WIKITTY);
        }
        this.removeDate.put(wikittyId, date);
    }

    public Map<String, WikittyExtension> getExtensions() {
        return this.extensions;
    }

    public void addExtension(WikittyExtension extension) {
        if (this.extensions == null) {
            this.extensions = new LinkedHashMap<String, WikittyExtension>();
            this.addType(WikittyEventType.PUT_EXTENSION);
        }
        this.extensions.put(extension.getId(), extension);
    }

    public Set<String> getDeletedExtensions() {
        return this.deletedExtensions;
    }

    public void addDeletedExtension(String extName) {
        if (this.deletedExtensions == null) {
            this.deletedExtensions = new LinkedHashSet<String>();
            this.addType(WikittyEventType.REMOVE_EXTENSION);
        }
        this.deletedExtensions.add(extName);
    }

    public void add(WikittyEvent e) {
        this.getType().addAll(e.getType());
        if (e.getWikitties() != null) {
            for (Map.Entry<String, Serializable> entry : e.getWikitties().entrySet()) {
                this.addWikitty((Wikitty)entry.getValue());
            }
        }
        if (e.getExtensions() != null) {
            for (Map.Entry<String, Serializable> entry : e.getExtensions().entrySet()) {
                this.addExtension((WikittyExtension)entry.getValue());
            }
        }
        if (e.getRemoveDate() != null) {
            for (Map.Entry<String, Serializable> entry : e.getRemoveDate().entrySet()) {
                this.addRemoveDate(entry.getKey(), (Date)entry.getValue());
            }
        }
    }

    public Wikitty update(Wikitty e) {
        String id = e.getId();
        if (this.type.contains((Object)WikittyEventType.CLEAR_WIKITTY)) {
            e = null;
        } else {
            Wikitty newWikitty;
            if (this.type.contains((Object)WikittyEventType.PUT_WIKITTY) && (newWikitty = this.getWikitties().get(id)) != null) {
                e.replaceWith(newWikitty);
            }
            if (this.type.contains((Object)WikittyEventType.REMOVE_WIKITTY)) {
                Date date = this.getRemoveDate().get(id);
                e.setDeleteDate(date);
            }
            e.clearDirty();
        }
        return e;
    }

    @Override
    public String toString() {
        String toString = this.getClass().getName() + "[source=" + this.source + ", eventId=" + this.eventId + ", time=" + this.time + ", type=" + this.type + ", remote=" + this.remote + ", wikitties=" + this.wikitties + ", removeDate=" + this.removeDate + ", extensions=" + this.extensions + "]";
        return toString;
    }

    public String toXML() {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.alias("event", WikittyEvent.class);
        String result = xstream.toXML((Object)this);
        return result;
    }

    public static WikittyEvent fromXML(String xml) {
        XStream xstream = new XStream();
        xstream.alias("event", WikittyEvent.class);
        WikittyEvent result = (WikittyEvent)xstream.fromXML(xml);
        return result;
    }

    public static enum WikittyEventType {
        PUT_WIKITTY("putWikitty"),
        REMOVE_WIKITTY("removeWikitty"),
        CLEAR_WIKITTY("clearWikitty"),
        PUT_EXTENSION("putExtension"),
        REMOVE_EXTENSION("removeExtension"),
        CLEAR_EXTENSION("clearExtension");

        public String listenerMethodName;

        private WikittyEventType(String listenerMethodName) {
            this.listenerMethodName = listenerMethodName;
        }
    }
}

