/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.HashMap;
import java.util.Map;
import org.nuiton.wikitty.ExtensionFactory;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.WikittyExtension;

public class FieldFactory {
    protected ExtensionFactory parentFactory;
    protected String fieldName;
    protected FieldType.TYPE type;
    protected int minOccur = 0;
    protected int maxOccur = 1;
    protected boolean unique = false;
    protected Map<String, String> tagValues = new HashMap<String, String>();

    public FieldFactory(ExtensionFactory parentFactory, String fieldName, FieldType.TYPE type) {
        this.parentFactory = parentFactory;
        this.fieldName = fieldName;
        this.type = type;
    }

    public FieldFactory addField(String name, FieldType.TYPE type) {
        this.append();
        return this.parentFactory.addField(name, type);
    }

    public WikittyExtension extension() {
        this.append();
        return this.parentFactory.extension();
    }

    protected void append() {
        FieldType fieldType = new FieldType(this.type, this.minOccur, this.maxOccur);
        for (Map.Entry<String, String> entry : this.tagValues.entrySet()) {
            String tag = entry.getKey();
            String value = entry.getValue();
            fieldType.addTagValue(tag, value);
        }
        this.parentFactory.add(this.fieldName, fieldType);
    }

    public FieldFactory maxOccur(int max) {
        this.maxOccur = max;
        return this;
    }

    public FieldFactory minOccur(int min) {
        this.minOccur = min;
        return this;
    }

    public FieldFactory unique() {
        this.addTagValue(FieldType.UNIQUE, "true");
        return this;
    }

    public FieldFactory notNull() {
        this.addTagValue(FieldType.NOT_NULL, "true");
        return this;
    }

    public FieldFactory addTagValue(String tag, String value) {
        this.tagValues.put(tag, value);
        return this;
    }
}

