/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.api;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.LabelImpl;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.api.AbstractTestApi;

public class WikittyUtilTest
extends AbstractTestApi {
    private static Log log = LogFactory.getLog(WikittyUtilTest.class);

    @Test
    public void testNormalizeVersion() {
        String version = null;
        String expResult = "0.0";
        String result = WikittyUtil.normalizeVersion(version);
        Assert.assertEquals((Object)expResult, (Object)result);
        version = "";
        expResult = "0.0";
        result = WikittyUtil.normalizeVersion((String)version);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testVersionEquals() {
        String v1 = "0.4";
        String v2 = "0.4";
        boolean expResult = true;
        boolean result = WikittyUtil.versionEquals((String)v1, (String)v2);
        Assert.assertEquals((Object)expResult, (Object)result);
        v1 = "0.4.0";
        v2 = "0.4";
        expResult = false;
        result = WikittyUtil.versionEquals((String)v1, (String)v2);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testVersionGreaterThan() {
        String v1 = "4.5";
        String v2 = "4.4";
        boolean expResult = true;
        boolean result = WikittyUtil.versionGreaterThan((String)v1, (String)v2);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testIncrementMinorRevision() {
        String v = "";
        String expResult = "0.1";
        String result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "0";
        expResult = "0.1";
        result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "1.0";
        expResult = "1.1";
        result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "1.4";
        expResult = "1.5";
        result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "1.9";
        expResult = "1.10";
        result = WikittyUtil.incrementMinorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testPerfIncrementMinorRevision() {
        int MAX = 3000000;
        String v = "0";
        long time = System.currentTimeMillis();
        for (int cpt = 0; cpt < MAX; ++cpt) {
            int i = Integer.parseInt(v) + 1;
            v = String.valueOf(i);
        }
        long timeParse = System.currentTimeMillis() - time;
        v = "0";
        time = System.currentTimeMillis();
        for (int cpt = 0; cpt < MAX; ++cpt) {
            v = this.inc(v);
        }
        long timeCall = System.currentTimeMillis() - time;
        v = "0";
        time = System.currentTimeMillis();
        for (int cpt = 0; cpt < MAX; ++cpt) {
            char[] c = v.toCharArray();
            boolean retenue = true;
            block14: for (int i = c.length - 1; retenue && i >= 0; --i) {
                switch (c[i]) {
                    case '0': {
                        c[i] = 49;
                        retenue = false;
                        continue block14;
                    }
                    case '1': {
                        c[i] = 50;
                        retenue = false;
                        continue block14;
                    }
                    case '2': {
                        c[i] = 51;
                        retenue = false;
                        continue block14;
                    }
                    case '3': {
                        c[i] = 52;
                        retenue = false;
                        continue block14;
                    }
                    case '4': {
                        c[i] = 53;
                        retenue = false;
                        continue block14;
                    }
                    case '5': {
                        c[i] = 54;
                        retenue = false;
                        continue block14;
                    }
                    case '6': {
                        c[i] = 55;
                        retenue = false;
                        continue block14;
                    }
                    case '7': {
                        c[i] = 56;
                        retenue = false;
                        continue block14;
                    }
                    case '8': {
                        c[i] = 57;
                        retenue = false;
                        continue block14;
                    }
                    default: {
                        c[i] = 48;
                    }
                }
            }
            v = retenue ? "1" + String.valueOf(c) : String.valueOf(c);
        }
        long timeSwitch = System.currentTimeMillis() - time;
        log.info((Object)("Inc parse: " + timeParse + " call: " + timeCall + " switch: " + timeSwitch + " (" + v + ")"));
    }

    protected String inc(String v) {
        char[] c = v.toCharArray();
        boolean retenue = true;
        block11: for (int i = c.length - 1; retenue && i >= 0; --i) {
            switch (c[i]) {
                case '0': {
                    c[i] = 49;
                    retenue = false;
                    continue block11;
                }
                case '1': {
                    c[i] = 50;
                    retenue = false;
                    continue block11;
                }
                case '2': {
                    c[i] = 51;
                    retenue = false;
                    continue block11;
                }
                case '3': {
                    c[i] = 52;
                    retenue = false;
                    continue block11;
                }
                case '4': {
                    c[i] = 53;
                    retenue = false;
                    continue block11;
                }
                case '5': {
                    c[i] = 54;
                    retenue = false;
                    continue block11;
                }
                case '6': {
                    c[i] = 55;
                    retenue = false;
                    continue block11;
                }
                case '7': {
                    c[i] = 56;
                    retenue = false;
                    continue block11;
                }
                case '8': {
                    c[i] = 57;
                    retenue = false;
                    continue block11;
                }
                default: {
                    c[i] = 48;
                }
            }
        }
        v = retenue ? "1" + String.valueOf(c) : String.valueOf(c);
        return v;
    }

    @Test
    public void testIncrementMajorRevision() {
        String v = "";
        String expResult = "1.0";
        String result = WikittyUtil.incrementMajorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "0";
        expResult = "1.0";
        result = WikittyUtil.incrementMajorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
        v = "1.5";
        expResult = "2.0";
        result = WikittyUtil.incrementMajorRevision((String)v);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testToBigDecimal() {
        Object value = null;
        BigDecimal expResult = new BigDecimal(0);
        BigDecimal result = WikittyUtil.toBigDecimal(value);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testToBoolean() {
        Object value = null;
        boolean expResult = false;
        boolean result = WikittyUtil.toBoolean(value);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testToString() {
        Object value = null;
        Object expResult = null;
        String result = WikittyUtil.toString(value);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testToDate() {
        Object value = null;
        Object expResult = null;
        Date result = WikittyUtil.toDate(value);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testToWikitty() {
        Object value = null;
        Object expResult = null;
        String result = WikittyUtil.toWikitty(value);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testToList() {
        Object value = null;
        Class<Object> clazz = Object.class;
        Object expResult = null;
        List result = WikittyUtil.toList(value, clazz);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testGetClass() {
        Object value = null;
        Object expResult = null;
        Class result = WikittyUtil.getClass(value);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testCast() {
        Object obj = null;
        Class<Object> clazz = null;
        Object expResult = null;
        Object result = WikittyUtil.cast(obj, clazz);
        Assert.assertEquals(expResult, (Object)result);
        obj = "Toto";
        clazz = Object.class;
        expResult = "Toto";
        result = WikittyUtil.cast((Object)obj, clazz);
        Assert.assertEquals((Object)expResult, (Object)result);
        obj = new Object();
        clazz = String.class;
        expResult = obj;
        try {
            result = WikittyUtil.cast((Object)obj, clazz);
            Assert.fail((String)"cast object to string !!!");
        }
        catch (Exception eee) {
            // empty catch block
        }
    }

    @Test
    public void testUID() throws Exception {
        for (int i = 0; i < 8; ++i) {
            String uid = WikittyUtil.genUID();
            log.info((Object)("uid = " + uid));
        }
    }

    @Test
    public void testWikittyExtensionBuild() {
        String extName = "Produit";
        LinkedHashMap fields = WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name", "Numeric amount", "Date buildDate"});
        Assert.assertNotNull(fields.get("name"));
        Assert.assertNotNull(fields.get("amount"));
        Assert.assertNotNull(fields.get("buildDate"));
        WikittyExtension ext = new WikittyExtension(extName, "1", null, fields);
        Assert.assertNotNull((Object)ext.getFieldType("name"));
        Assert.assertNotNull((Object)ext.getFieldType("amount"));
        Assert.assertNotNull((Object)ext.getFieldType("buildDate"));
    }

    @Test
    public void testWikittyExtensionTagValue() {
        String accentValue = "Av\u00e8c_d\u00e9s_a\u00e7cents";
        String floatValue = "3.3";
        String dateValue = "2009-12-10T12:45:31:551Z";
        String whitespaceCharacters = "ertyuio\n   <df ds \r\rf sf >sd f\n\tdf";
        LinkedHashMap fields = WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name test=" + accentValue, "Numeric amount defaultValue=" + floatValue, "Date buildDate now=" + dateValue});
        FieldType fieldName = (FieldType)fields.get("name");
        Assert.assertEquals((Object)accentValue, (Object)fieldName.getTagValue("test"));
        Assert.assertEquals((Object)floatValue, (Object)((FieldType)fields.get("amount")).getTagValue("defaultValue"));
        Assert.assertEquals((Object)dateValue, (Object)((FieldType)fields.get("buildDate")).getTagValue("now"));
        fieldName.addTagValue("whitespaceCharacters", whitespaceCharacters);
        String toDefinition = fieldName.toDefinition("name");
        WikittyUtil.parseField((String)toDefinition, (FieldType)fieldName);
    }

    @Test
    public void testDateConsistency() throws Exception {
        Date date = WikittyUtil.parseDate((String)"30/01/2009");
        Date dateFormatedAndParsed = WikittyUtil.parseDate((String)WikittyUtil.formatDate((Date)date));
        Assert.assertEquals((Object)date, (Object)dateFormatedAndParsed);
        date = new Date();
        dateFormatedAndParsed = WikittyUtil.parseDate((String)WikittyUtil.formatDate((Date)date));
        Assert.assertEquals((Object)date, (Object)dateFormatedAndParsed);
    }

    @Test
    public void testParseDate() throws ParseException {
        String date = "1982-01-22T23:00:00.000+0000Z";
        Date date2 = WikittyUtil.parseDate((String)date);
        Assert.assertNotNull((Object)date2);
    }

    static class MonLabel
    extends LabelImpl {
        MonLabel() {
        }
    }
}

