/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.nuiton.wikitty;

import java.util.HashMap;
import java.util.Map;

/**
 * Interface used to migrate Wikitty data from one WikittyExtension version
 * to another version
 * 
 * @author poussin
 * @version $Revision: 129 $
 *
 * Last update: $Date: 2010-06-15 17:23:54 +0200 (mar., 15 juin 2010) $
 * by : $Author: echatellier $
 */
public interface WikittyExtensionMigration {

    // TODO poussin 20090902 permit configuration of migrationRegistry by spring
    /**
     * use to put migration class for extension.
     * key: extensionName, value: migration class
     */
    static public Map<String, WikittyExtensionMigration> migrationRegistry =
            new HashMap<String, WikittyExtensionMigration>();

    /**
     * Migrate wikitty data from oldExt version to newExt.
     * 
     * @param service Wikitty service that do migration
     * @param transaction current transaction to use
     * @param wikitty Wikitty object that contains data in old version
     * extension format
     * @param oldExt old extension definition
     * @param newExt new extension definition
     * @return same wikitty as argument if nothing to do, or new wikitty
     * if some modification is done
     */
    public Wikitty migrate(WikittyService service, WikittyTransaction transaction,
            Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt);

}
