package org.nuiton.web.security;

/*-
 * #%L
 * Nuiton Web :: Nuiton Security
 * %%
 * Copyright (C) 2010 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Thu Sep 07 10:56:15 CEST 2017")
public abstract class SecurityRoleAbstract extends AbstractTopiaEntity implements SecurityRole {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : permissions
     */
    protected Collection<String> permissions;

    private static final long serialVersionUID = 4049127909472219447L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_PERMISSIONS, Collection.class, String.class, permissions);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void addPermissions(String permissions) {
        if (this.permissions == null) {
            this.permissions = new LinkedList<String>();
        }
        this.permissions.add(permissions);
    }

    @Override
    public void addAllPermissions(Iterable<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String item : permissions) {
            addPermissions(item);
        }
    }

    @Override
    public void setPermissions(Collection<String> permissions) {
        this.permissions = permissions;
    }

    @Override
    public void removePermissions(String permissions) {
        if (this.permissions == null || !this.permissions.remove(permissions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearPermissions() {
        if (this.permissions == null) {
            return;
        }
        this.permissions.clear();
    }

    @Override
    public Collection<String> getPermissions() {
        return permissions;
    }

    @Override
    public int sizePermissions() {
        if (permissions == null) {
            return 0;
        }
        return permissions.size();
    }

    @Override
    public boolean isPermissionsEmpty() {
        int size = sizePermissions();
        return size == 0;
    }

    @Override
    public boolean isPermissionsNotEmpty() {
        boolean empty = isPermissionsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsPermissions(String permissions) {
        boolean contains = this.permissions !=null && this.permissions.contains(permissions);
        return contains;
    }

} //SecurityRoleAbstract
