/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.rss;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.rss.Field;

public class FeedRendererConfig {
    protected String feedString = "indat";
    protected List<Field> feedList;
    protected String itemString = "indat";
    protected List<Field> itemList;

    public FeedRendererConfig() {
    }

    public FeedRendererConfig(String representation) {
        this.setString(representation);
    }

    protected List<Field> createList(String value) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (char c : value.toCharArray()) {
            Field field = Field.valueOf((char)c);
            if (field == null) continue;
            result.add(field);
        }
        return result;
    }

    public List<Field> getFeedFieldOrder() {
        if (this.feedList == null) {
            this.feedList = this.createList(this.feedString);
        }
        return this.feedList;
    }

    public List<Field> getItemFieldOrder() {
        if (this.itemList == null) {
            this.itemList = this.createList(this.itemString);
        }
        return this.itemList;
    }

    public void setString(String f) {
        String[] fi = f.split("-");
        if (fi.length > 1) {
            this.feedString = fi[0];
            this.itemString = fi[1];
        } else {
            this.feedString = "";
            this.itemString = fi[0];
        }
        this.feedList = null;
        this.itemList = null;
    }

    public String getString() {
        String result = "";
        if (!"".equals(this.feedString)) {
            result = this.feedString + "-";
        }
        result = result + this.itemString;
        return result;
    }
}

