package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaService.java 3088 2014-04-30 11:17:38Z bleny $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-4/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaService.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Map;

/**
 * Used to implement a service for Topia.
 *
 * A TopiaService is started at the very beginning of the {@link org.nuiton.topia.persistence.TopiaApplicationContext}
 * startup and provides user extra operations not available in the topia core such as migrations,
 * replication, IO, etc.
 */
public interface TopiaService {

    void setConfiguration(Map<String, String> serviceConfiguration);

    /**
     * Retrieve entities of this service needed for persistence.
     *
     * @return List of entities full qualified name separated by a comma
     */
    Class<?>[] getPersistenceClasses();

    /**
     * Initiliaze the service before create the {@code context}.
     *
     * @param context
     * @return true if service need to be activated or not
     */
    void preInit(TopiaApplicationContext context);

    /**
     * Initiliaze the service after create the {@code context}.
     *
     * @param context
     * @return true if service need to be activated or not
     */
    void postInit(TopiaApplicationContext context);

}
