/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaIdFactory;

public class DefaultTopiaIdFactory
implements TopiaIdFactory {
    private static final Log log = LogFactory.getLog(DefaultTopiaIdFactory.class);

    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException("Only interface is permit to create id: " + entityClass);
        }
        String result = entityClass.getName() + this.getSeparator() + UUID.randomUUID().toString();
        return result;
    }

    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String className = StringUtils.substringBefore((String)topiaId, (String)this.getSeparator());
        try {
            Class<?> entityClass = Class.forName(className);
            return entityClass;
        }
        catch (ClassNotFoundException e) {
            throw new TopiaException("can't find class for topiaId = '" + topiaId + "'", e);
        }
    }

    @Override
    public String getSeparator() {
        return "_";
    }

    @Override
    public String getRandomPart(String topiaId) {
        return StringUtils.substringAfter((String)topiaId, (String)this.getSeparator());
    }

    @Override
    public boolean isTopiaId(String str) {
        boolean isTopiaId;
        block3: {
            String[] split;
            isTopiaId = false;
            if (str != null && (split = str.split(this.getSeparator())).length == 2) {
                String className = split[0];
                try {
                    Class.forName(className);
                    isTopiaId = StringUtils.isNotBlank((CharSequence)split[1]);
                }
                catch (ClassNotFoundException eee) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)eee);
                }
            }
        }
        return isTopiaId;
    }
}

