/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.plugin.ConfigMojoSupport;
import org.nuiton.config.plugin.model.ConfigModel;
import org.nuiton.config.plugin.templates.ApplicationConfigTransformer;
import org.nuiton.config.plugin.templates.ApplicationConfigTransformerConfig;
import org.nuiton.eugene.DefaultTemplateConfiguration;
import org.nuiton.eugene.TemplateConfiguration;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends ConfigMojoSupport
implements ApplicationConfigTransformerConfig {
    @Parameter(property="config.packageName")
    private String packageName;
    @Parameter(property="config.modelName")
    private String modelName;
    @Parameter(property="config.optionsClassName")
    private String optionsClassName;
    @Parameter(property="config.actionsClassName")
    private String actionsClassName;
    @Parameter(property="config.generateProvider", defaultValue="true")
    private boolean generateProvider;
    @Parameter(property="config.generatePropertyChangeSupport", defaultValue="false")
    private boolean generatePropertyChangeSupport;
    @Parameter(property="config.useNuitonI18n")
    private boolean useNuitonI18n;
    @Parameter(property="config.sourceDirectory", defaultValue="${basedir}/src/main/java", required=true)
    private File sourceDirectory;
    @Parameter(property="config.outputDirectory", defaultValue="${project.build.directory}/generated-sources/java", required=true)
    private File outputDirectory;
    @Parameter(property="config.skip", defaultValue="false")
    private boolean skip;
    private ApplicationConfigTransformer template;
    private String configClassName;
    private String configProviderClassName;
    private ConfigModel configModel;

    @Override
    protected void init() throws Exception {
        File modelFile;
        if (this.skip) {
            return;
        }
        super.init();
        if (this.modelName == null) {
            ArrayList<String> artifactIdPaths = new ArrayList<String>();
            for (String artifactIdPath : Arrays.asList(this.getProject().getArtifactId().replaceAll("-", ".").split("\\."))) {
                artifactIdPaths.add(StringUtils.capitalize((String)artifactIdPath));
            }
            this.modelName = Joiner.on((String)"").join(artifactIdPaths);
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Use model name: " + this.modelName));
            }
        }
        if (this.getModelFile() == null) {
            this.setModelFile(this.modelName);
        }
        if (!(modelFile = this.getModelFile()).exists()) {
            throw new MojoExecutionException("No model file found at: " + modelFile);
        }
        if (this.packageName == null) {
            ArrayList<String> groupIdPaths = new ArrayList<String>(Arrays.asList(this.getProject().getGroupId().split("\\.")));
            ArrayList<String> artifactIdPaths = new ArrayList<String>(Arrays.asList(this.getProject().getArtifactId().replaceAll("-", ".").split("\\.")));
            if (((String)Iterables.getLast(groupIdPaths)).equals(Iterables.getFirst(artifactIdPaths, null))) {
                artifactIdPaths.remove(0);
            }
            groupIdPaths.addAll(artifactIdPaths);
            this.packageName = Joiner.on((String)".").join(groupIdPaths);
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Use package name: " + this.packageName));
            }
        }
        if (this.optionsClassName == null) {
            this.optionsClassName = this.modelName + "ConfigOption";
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Configuration options class: " + this.optionsClassName));
            }
        }
        if (this.actionsClassName == null) {
            this.actionsClassName = this.modelName + "ConfigAction";
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Configuration actions class: " + this.actionsClassName));
            }
        }
        URLClassLoader loader = this.initClassLoader(this.getProject(), this.sourceDirectory, true, false, false, true, true);
        this.configClassName = this.modelName + "Config";
        this.getLog().info((CharSequence)("Config class name: " + this.configClassName));
        if (this.generateProvider) {
            this.configProviderClassName = this.configClassName + "Provider";
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Config provider class name: " + this.configClassName));
            }
        }
        this.configModel = this.getIO().read(modelFile.toPath());
        Properties templateProperties = new Properties();
        templateProperties.put("encoding", StandardCharsets.UTF_8.name());
        templateProperties.put("verbose", (Object)this.isVerbose());
        templateProperties.put("overwrite", (Object)true);
        templateProperties.put("classLoader", loader);
        templateProperties.put("config", this);
        this.template = new ApplicationConfigTransformer();
        this.template.setConfiguration((TemplateConfiguration)new DefaultTemplateConfiguration(templateProperties));
        if (!this.getProject().getCompileSourceRoots().contains(this.outputDirectory.getPath())) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Add compile source root : " + this.outputDirectory));
            }
            this.getProject().addCompileSourceRoot(this.outputDirectory.getPath());
        }
    }

    protected void doAction() throws Exception {
        if (this.skip) {
            this.getLog().info((CharSequence)"Generate mojo is skip.");
            return;
        }
        this.getLog().info((CharSequence)("Generate file(s) to: " + this.outputDirectory));
        ObjectModelImpl objectModel = new ObjectModelImpl();
        objectModel.setName(this.modelName);
        this.template.applyTemplate((Model)objectModel, this.outputDirectory);
        if (this.generateProvider) {
            String content = this.packageName + "." + this.configClassName + "Provider";
            File serviceLoaderFile = PluginHelper.getFile((File)this.outputDirectory, (String[])new String[]{"META-INF", "services", ApplicationConfigProvider.class.getName()});
            Files.createParentDirs((File)serviceLoaderFile);
            Files.write((byte[])content.getBytes(), (File)serviceLoaderFile);
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Generate serviceLoader provider file: " + serviceLoaderFile));
            }
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            resource.setIncludes(Collections.singletonList("**/" + ApplicationConfigProvider.class.getName()));
            this.getProject().addResource(resource);
        }
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public String getOptionsClassName() {
        return this.optionsClassName;
    }

    @Override
    public String getActionsClassName() {
        return this.actionsClassName;
    }

    @Override
    public boolean isGenerateProvider() {
        return this.generateProvider;
    }

    @Override
    public boolean isGeneratePropertyChangeSupport() {
        return this.generatePropertyChangeSupport;
    }

    @Override
    public String getConfigProviderClassName() {
        return this.configProviderClassName;
    }

    @Override
    public String getConfigClassName() {
        return this.configClassName;
    }

    @Override
    public ConfigModel getConfigModel() {
        return this.configModel;
    }

    @Override
    public boolean isUseNuitonI18n() {
        return this.useNuitonI18n;
    }
}

