/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.util.config;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.EnumMap;
import java.util.EnumSet;
import javax.swing.JLabel;
import org.nuiton.jaxx.util.DialogUIHandler;
import org.nuiton.jaxx.util.config.DialogConfigUI;
import org.nuiton.jaxx.util.config.DialogConfigUIModel;
import org.nuiton.util.ConverterUtil;
import org.nuiton.util.config.Property;

public abstract class DialogConfigUIHandler<E extends Enum<E>, M extends DialogConfigUIModel<E, ?>, U extends DialogConfigUI<E, ?>>
extends DialogUIHandler<M, U> {
    protected DialogConfigUIHandler(U ui, M model) {
        super(ui, model);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String action;
        if (log.isDebugEnabled()) {
            log.debug((Object)(evt.getPropertyName() + " old:" + evt.getOldValue() + ", new:" + evt.getNewValue()));
        }
        if ("config".equals(action = evt.getPropertyName())) {
            this.populateUI();
            this.doCheckAll();
            return;
        }
        if ("modify".equals(action)) {
            Boolean newValue = (Boolean)evt.getNewValue();
            boolean modified = newValue != null && newValue != false;
            ((DialogConfigUI)this.getUi()).getReset().setEnabled(modified);
            ((DialogConfigUI)this.getUi()).getOk().setEnabled(modified && ((DialogConfigUIModel)this.getModel()).isConfigValid());
            return;
        }
        if ("unvalid".equals(action)) {
            this.updateUI();
            return;
        }
        throw new IllegalStateException("unimplemented property changed : " + evt + " for " + this);
    }

    public void doCheck(E key) {
        Object uiValue = ((DialogConfigUI)this.getUi()).getElementValue(key);
        DialogConfigUIModel model = (DialogConfigUIModel)this.getModel();
        Object currentValue = model.getCurrent().getProperty(key);
        currentValue = currentValue == null ? "" : String.valueOf(currentValue);
        model.validateProperty(key, uiValue);
        model.changeModifiedState(key, uiValue, currentValue);
    }

    public void doCheckAll() {
        DialogConfigUIModel model = (DialogConfigUIModel)this.getModel();
        EnumSet<Enum> unvalids = EnumSet.noneOf(model.klass);
        for (Enum e : model.getCheckedKeysSet()) {
            Object uiValue;
            if (model.isValid(e, uiValue = ((DialogConfigUI)this.getUi()).getElementValue(e))) continue;
            unvalids.add(e);
        }
        model.setUnvalids(unvalids);
        unvalids.clear();
    }

    protected boolean prepareSave() {
        DialogConfigUI ui = (DialogConfigUI)this.getUi();
        DialogConfigUIModel model = (DialogConfigUIModel)this.getModel();
        Object current = model.getCurrent();
        if (!model.isConfigValid()) {
            log.warn((Object)("do not save a unvalid config : " + model.getUnvalids()));
            return false;
        }
        if (!model.isModified()) {
            log.warn((Object)"nothing to save");
            return false;
        }
        EnumSet toTreate = model.getCheckedKeysSet();
        for (Enum key : model.getModifieds()) {
            if (!toTreate.contains(key)) continue;
            Object value = ui.getElementValue(key);
            Class type = ((Property)key).getType();
            Object newValue = ConverterUtil.convert((Class)type, (Object)value);
            current.setProperty(key, newValue);
        }
        return true;
    }

    protected void populateUI() {
        DialogConfigUI ui = (DialogConfigUI)this.getUi();
        EnumMap map = ((DialogConfigUIModel)this.getModel()).getCurrent().getProperties();
        for (Enum e : ((DialogConfigUIModel)this.getModel()).getCheckedKeysSet()) {
            Object value = map.get(e);
            this.populateUI(ui, e, value);
        }
    }

    protected void populateUI(U ui, E key, Object value) {
        ((DialogConfigUI)ui).setElementValue(key, value);
    }

    protected void updateUI() {
        EnumSet unvalids = ((DialogConfigUIModel)this.getModel()).getUnvalids();
        for (Enum key : unvalids) {
            this.setLabelColor(key, false);
        }
        for (Enum key : EnumSet.complementOf(unvalids)) {
            this.setLabelColor(key, true);
        }
    }

    protected void setLabelColor(E key, boolean valid) {
        JLabel component = ((DialogConfigUI)this.getUi()).getElementLabel(key);
        if (component != null && component.isVisible()) {
            component.setForeground(valid ? Color.black : Color.red);
        }
    }
}

