/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.action;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.nuiton.jaxx.action.ActionNameProvider;
import org.nuiton.jaxx.action.ActionProvider;
import org.nuiton.jaxx.action.ActionProviderAnnotation;
import org.nuiton.jaxx.action.ActionProviderFromProperties;
import org.nuiton.util.SortedProperties;

@SupportedAnnotationTypes(value={"org.nuiton.jaxx.action.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"jaxx.verbose"})
public class ActionAnnotationProcessing
extends AbstractProcessor {
    protected String providerDeclarationLocation = "META-INF/services/" + ActionProvider.class.getName();
    protected String actionsFileLocation = "META-INF/jaxx-%1$s-actions.properties";
    protected boolean verbose;
    protected List<String> processedClass;
    protected Properties actions;
    protected AnnotationValueVisitor<Object, Void> annotationValueExtractor;
    protected TypeElement baseActionElement;
    protected String providerFQN;
    protected String baseFQN;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.parseOptions();
        this.printDebug("verbose      : " + this.verbose);
        this.printDebug("FileLocation : " + this.actionsFileLocation);
        this.processedClass = new ArrayList<String>();
        this.actions = new SortedProperties();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedWith = roundEnv.getElementsAnnotatedWith(typeElement);
            if (typeElement.getQualifiedName().toString().equals(ActionProviderAnnotation.class.getName())) {
                if (annotatedWith.size() != 1) {
                    throw new IllegalStateException("can have only one provider defined by the annotation " + ActionProviderAnnotation.class);
                }
                this.baseActionElement = (TypeElement)annotatedWith.iterator().next();
                this.baseFQN = ((Object)this.baseActionElement.asType()).toString();
                int index = this.baseFQN.lastIndexOf(".") + 1;
                String string = this.baseFQN.substring(index);
                String packageName = this.baseFQN.substring(0, index);
                this.providerFQN = packageName + string + "Provider";
                this.printDebug("providerFQN " + this.providerFQN);
                this.actionsFileLocation = String.format(this.actionsFileLocation, string);
                continue;
            }
            for (Element element : annotatedWith) {
                String className = element.toString();
                if (this.processedClass.contains(className)) {
                    this.printWarning("class already processed " + className);
                    continue;
                }
                boolean wasTreated = this.registerActionsForClass(typeElement.asType(), element);
                if (wasTreated) {
                    this.printDebug("process class " + className);
                    this.processedClass.add(className);
                    continue;
                }
                this.printDebug("class was not processed " + element);
            }
        }
        if (roundEnv.processingOver()) {
            this.printDebug("round is over " + roundEnv);
            try {
                if (this.baseActionElement != null) {
                    this.writeProviderClass();
                    this.writeProviderServiceDeclaration();
                } else {
                    this.actionsFileLocation = this.findMappingFile();
                    this.printInfo("reused actionFilesLocation " + this.actionsFileLocation);
                }
                this.writeActionMapping();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.processedClass.clear();
                this.actions.clear();
            }
        }
        return true;
    }

    protected String findMappingFile() throws IOException {
        String path = String.format(this.actionsFileLocation, "dummy_" + System.nanoTime());
        FileObject oldFo = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", path);
        File dummyFile = new File(oldFo.toUri().toString()).getParentFile();
        File[] files = dummyFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("jaxx-") && name.endsWith("-actions.properties");
            }
        });
        if (files.length < 1) {
            throw new IllegalStateException("no provider name found, you must add on baseaction the annotation " + ActionProviderAnnotation.class);
        }
        File f = files[0];
        int index = f.getAbsolutePath().indexOf("META-INF");
        return f.getAbsolutePath().substring(index);
    }

    protected boolean registerActionsForClass(TypeMirror annotationType, Element e) {
        boolean doTreate = false;
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().equals(annotationType)) continue;
            doTreate = true;
            this.printDebug("found a annotation to treate : " + annotationMirror + " for action : " + e.toString());
            for (String name : this.getActionNames(annotationMirror)) {
                this.actions.put("action." + name, e.toString());
                this.printDebug("registerActionForClass " + name + " : " + e.toString());
            }
        }
        return doTreate;
    }

    protected void parseOptions() {
        Map<String, String> options = this.processingEnv.getOptions();
        this.verbose = options.containsKey("jaxx.verbose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeProviderClass() throws IOException, NotFoundException, CannotCompileException, ClassNotFoundException {
        OutputStream outputStream = null;
        try {
            ClassPool pool = ClassPool.getDefault();
            pool.appendClassPath((ClassPath)new LoaderClassPath(ActionProviderFromProperties.class.getClassLoader()));
            CtClass superClass = pool.get(ActionProviderFromProperties.class.getName());
            CtClass clazz = pool.makeClass(this.providerFQN);
            pool.makeClass(this.baseFQN);
            clazz.setSuperclass(superClass);
            CtConstructor constructor = new CtConstructor(null, clazz);
            constructor.setBody("super( " + this.baseFQN + ".class);");
            clazz.addConstructor(constructor);
            byte[] byteCode = clazz.toBytecode();
            JavaFileObject fo = this.processingEnv.getFiler().createClassFile(this.providerFQN, new Element[0]);
            this.printInfo("writing " + fo.toUri());
            outputStream = fo.openOutputStream();
            outputStream.write(byteCode);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeProviderServiceDeclaration() throws IOException {
        BufferedWriter w = null;
        try {
            FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", this.providerDeclarationLocation, new Element[0]);
            this.printInfo("writing " + fo.toUri());
            w = new BufferedWriter(fo.openWriter());
            w.append("# generated by ").append(this.getClass().getName()).append("\n").toString();
            w.append("#").append(new Date().toString()).append("\n").toString();
            w.append(this.providerFQN);
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeActionMapping() throws IOException {
        if (this.actions.isEmpty()) {
            return;
        }
        BufferedWriter w = null;
        try {
            Properties oldProps = this.loadOldActionMapping();
            if (oldProps != null) {
                oldProps.putAll((Map<?, ?>)this.actions);
                this.actions = oldProps;
            }
            FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", this.actionsFileLocation, new Element[0]);
            this.printInfo("writing " + fo.toUri());
            w = new BufferedWriter(fo.openWriter());
            this.actions.store(w, "generated by " + this.getClass().getName());
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadOldActionMapping() throws IOException {
        FileObject oldFo = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", this.actionsFileLocation);
        if (!new File(oldFo.toUri().toString()).exists()) {
            return null;
        }
        SortedProperties oldProps = new SortedProperties();
        InputStream inputStream = null;
        try {
            inputStream = oldFo.openInputStream();
            if (inputStream != null) {
                oldProps.load(inputStream);
            }
            oldFo.delete();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return oldProps;
    }

    protected String[] getActionNames(AnnotationMirror element) {
        String[] result = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : element.getElementValues().entrySet()) {
            ExecutableElement type = entry.getKey();
            String name = type.getSimpleName().toString();
            if ("actionCommands".equals(name)) {
                List stringList = (List)entry.getValue().accept(this.getAnnotationValueExtractor(), null);
                result = stringList.toArray(new String[stringList.size()]);
                break;
            }
            if ("actionCommandProvider".equals(name)) {
                TypeMirror t = (TypeMirror)entry.getValue().accept(this.getAnnotationValueExtractor(), null);
                String classname = ((Object)t).toString();
                this.printDebug("actionCommandProvider = " + classname);
                if (classname.equals(ActionNameProvider.class.getName())) continue;
                result = new String[]{":" + classname};
                break;
            }
            if (!"actionCommand".equals(name)) continue;
            result = new String[]{(String)entry.getValue().accept(this.getAnnotationValueExtractor(), null)};
        }
        return result;
    }

    protected AnnotationValueVisitor<Object, Void> getAnnotationValueExtractor() {
        if (this.annotationValueExtractor == null) {
            this.annotationValueExtractor = new SimpleAnnotationValueVisitor6<Object, Void>(){

                @Override
                protected Object defaultAction(Object o, Void aVoid) {
                    return o;
                }

                @Override
                public Object visitArray(List<? extends AnnotationValue> vals, Void aVoid) {
                    ArrayList<Object> realVals = new ArrayList<Object>();
                    for (AnnotationValue annotationValue : vals) {
                        realVals.add(annotationValue.accept(this, aVoid));
                    }
                    return realVals;
                }

                @Override
                public Object visitType(TypeMirror t, Void aVoid) {
                    return t;
                }
            };
        }
        return this.annotationValueExtractor;
    }

    protected void printWarning(String msg) {
        System.out.println("[WARN] " + this.getClass().getName() + " : " + msg);
    }

    protected void printInfo(String msg) {
        System.out.println("[INFO] " + this.getClass().getName() + " : " + msg);
    }

    protected void printDebug(String msg) {
        if (this.verbose) {
            System.out.println("[DEBUG] " + this.getClass().getName() + " : " + msg);
        }
    }
}

