/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.navigation.NavigationTreeContextHelper;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavigationTreeHelper
extends NavigationTreeContextHelper {
    private static final Log log = LogFactory.getLog(NavigationTreeHelper.class);

    public abstract NavigationTreeModel createTreeModel(JAXXContext var1);

    public abstract NavigationTreeHandler createTreeHandler(JAXXObject var1);

    public NavigationTreeHelper(String contextPrefix) {
        super(contextPrefix);
    }

    public Object getContextValue(JAXXContext context, String path) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        NavigationTreeModel treeModel = this.getSafeTreeModel(context);
        return treeModel.getBean(path);
    }

    public NavigationTreeNode findNode(JAXXContext context, String path) {
        NavigationTreeModel treeModel = this.getSafeTreeModel(context);
        return treeModel.findNode(path);
    }

    public NavigationTreeNode findNode(JAXXContext context, String path, String regex) {
        NavigationTreeModel treeModel = this.getSafeTreeModel(context);
        return treeModel.findNode(path, regex);
    }

    public NavigationTreeNode findNode(JAXXContext context, String path, Pattern regex) {
        NavigationTreeModel treeModel = this.getSafeTreeModel(context);
        return treeModel.findNode(path, regex);
    }

    public NavigationTreeNode findNode(JAXXContext context, String path, String regex, String suffix) {
        NavigationTreeModel treeModel = this.getSafeTreeModel(context);
        NavigationTreeNode navigationTreeNode = treeModel.findNode(path, regex);
        if (navigationTreeNode != null && suffix != null) {
            navigationTreeNode = treeModel.findNode(navigationTreeNode, suffix);
        }
        return navigationTreeNode;
    }

    public NavigationTreeNode findNode(JAXXContext context, String path, Pattern regex, String suffix) {
        NavigationTreeModel treeModel = this.getSafeTreeModel(context);
        NavigationTreeNode navigationTreeNode = treeModel.findNode(path, regex);
        if (navigationTreeNode != null && suffix != null) {
            navigationTreeNode = treeModel.findNode(navigationTreeNode, suffix);
        }
        return navigationTreeNode;
    }

    public void selectNode(JAXXContext context, String path) {
        NavigationTreeNode node = this.findNode(context, path);
        if (log.isDebugEnabled()) {
            log.debug((Object)(path + " :: " + node));
        }
        if (node != null) {
            this.selectNode(context, node);
        }
    }

    public void selectNode(JAXXContext context, NavigationTreeNode node) {
        NavigationTreeModel navigationModel = this.getSafeTreeModel(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)node);
        }
        TreePath path = new TreePath(navigationModel.getPathToRoot(node));
        JTree tree = this.getSafeTree(context);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public void gotoParentNode(JAXXContext context) {
        NavigationTreeNode node = this.getSelectedNode(context);
        if (node == null) {
            throw new NullPointerException("no selected node in context");
        }
        node = node.getParent();
        this.selectNode(context, node);
    }

    public NavigationTreeNode getParentNode(NavigationTreeNode current, Class<?> beanClass) {
        if (current == null) {
            return null;
        }
        if (beanClass.isAssignableFrom(current.getInternalClass())) {
            return current;
        }
        return this.getParentNode(current.getParent(), beanClass);
    }

    public void gotoChildNode(JAXXContext context, int childIndex) {
        NavigationTreeNode node = this.getSelectedNode(context);
        if (node == null) {
            throw new NullPointerException("no selected node in context");
        }
        node = node.getChildAt(childIndex);
        this.selectNode(context, node);
    }

    public void repaintNode(JAXXContext context, NavigationTreeNode node) {
        this.repaintNode(context, node, false);
    }

    public void repaintNode(JAXXContext context, NavigationTreeNode node, boolean deep) {
        NavigationTreeModel navigationModel = this.getSafeTreeModel(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)node);
        }
        navigationModel.nodeChanged(node);
        if (deep) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                NavigationTreeNode child = (NavigationTreeNode)e.nextElement();
                this.repaintNode(context, child, true);
            }
        }
    }

    public NavigationTreeModel getSafeTreeModel(JAXXContext context) throws NullPointerException {
        NavigationTreeModel treeModel = this.getTreeModel(context);
        if (treeModel == null) {
            throw new NullPointerException("could not find tree model with key " + this.getTreeModelContextEntry() + " in context " + context);
        }
        return treeModel;
    }

    public JTree getSafeTree(JAXXContext context) throws NullPointerException {
        JTree tree = this.getTree(context);
        if (tree == null) {
            throw new NullPointerException("could not find tree with key " + this.getTreeContextEntry() + " in context " + context);
        }
        return tree;
    }
}

