/*
 * #%L
 * Pollen :: VoteCounting strategy :: Normal
 * $Id: NormalVoteCountingStrategy.java 3710 2012-09-29 21:18:12Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.3/pollen-votecounting-normal/src/main/java/org/chorem/pollen/votecounting/NormalVoteCountingStrategy.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting;

import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;

import java.util.Map;
import java.util.Set;

/**
 * Vote counting strategy for {@link NormalVoteCounting}.
 * <p/>
 * This is a very basic vote counting:
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class NormalVoteCountingStrategy extends AbstractVoteCountingStrategy {

    @Override
    public VoteCountingResult votecount(Set<Voter> voters) {

        // get empty result by choice
        Map<String, ChoiceScore> scores = newEmptyChoiceScoreMap(voters);

        for (Voter voter : voters) {

            // add this voter votes to result
            addVoterChoices(voter, scores);
        }

        // order scores (using their value) and return result
        VoteCountingResult result = orderByValues(scores.values());
        return result;
    }

    protected void addVoterChoices(Voter voter,
                                   Map<String, ChoiceScore> scores) {

        double voterWeight = voter.getWeight();

        for (VoteForChoice voteForChoice : voter.getVoteForChoices()) {
            Double voteValue = voteForChoice.getVoteValue();
            if (voteValue != null) {

                // get score for choice
                ChoiceScore score = scores.get(voteForChoice.getChoiceId());

                // compute score to add
                double scoreToAdd = voteValue * voterWeight;

                // add to score this weighted vote
                score.addScoreValue(scoreToAdd);
            }
        }
    }

}
