package org.chorem.pollen.votecounting;

/*
 * #%L
 * Pollen :: VoteCounting :: Instant Runoff
 * $Id: InstantRunoffVoteCounting.java 3715 2012-10-01 05:11:10Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5/pollen-votecounting-instant-runoff/src/main/java/org/chorem/pollen/votecounting/InstantRunoffVoteCounting.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.chorem.pollen.votecounting.model.ChoiceToVoteRenderType;

import java.util.Locale;

import static org.nuiton.i18n.I18n.l_;
import static org.nuiton.i18n.I18n.n_;

/**
 * Coombs vote counting entry point.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.6
 */
public class InstantRunoffVoteCounting extends AbstractVoteCounting<InstantRunoffVoteCountingStrategy> {

    public static final int ID = 5;

    public InstantRunoffVoteCounting() {
        super(ID,
              InstantRunoffVoteCountingStrategy.class,
              n_("pollen.voteCountingType.instantRunoff"),
              n_("pollen.voteCountingType.instantRunoff.shortHelp"),
              n_("pollen.voteCountingType.instantRunoff.help")
        );
    }

    @Override
    public String getTotalVoteValueNotValidMessage(Locale locale) {
        // no validation on total value, so no message
        return null;
    }

    @Override
    public String getVoteValueNotValidMessage(Locale locale,
                                              String choiceName,
                                              String voteValue) {
        return l_(locale, "pollen.error.vote.invalidInstantRunoffVoteValue",
                  choiceName,
                  voteValue);
    }

    @Override
    public String getDisplayVoteValue(Integer voteValue) {
        return voteValue == null ? "" : String.valueOf(voteValue);
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public boolean isChoiceInVote(Integer voteValue) {
        return voteValue != null && voteValue > 0 && voteValue < 100;
    }

    @Override
    public boolean isVoteValueNull(Integer voteValue) {
        return voteValue == null;
    }

    @Override
    public boolean isVoteValueValid(Integer voteValue) {
        return voteValue != null && voteValue > 0;
    }

    @Override
    public boolean isTotalVoteValueValid(int totalValues) {
        // no validation on total value
        return true;
    }
}
