/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.search.FlagTerm;
import jakarta.mail.search.SearchTerm;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail2.core.EmailException;
import org.chorem.pollen.persistence.PollenDao;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Report;
import org.chorem.pollen.persistence.topia.TopiaIdFactory;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.mail.PollenEmailKeyType;
import org.chorem.pollen.services.service.mail.PollenMailReturnContext;
import org.chorem.pollen.services.service.mail.PollenMailType;
import org.nuiton.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailBoxService
extends PollenServiceSupport {
    private static final Logger log = LoggerFactory.getLogger(MailBoxService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMailBox() {
        Store store = null;
        if (StringUtils.isNotBlank((CharSequence)this.getPollenServiceConfig().getMailBoxHost())) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Open session ...");
                }
                store = this.openSession();
                Folder folder = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Open folder ...");
                    }
                    folder = this.openFolder(store);
                    if (log.isDebugEnabled()) {
                        log.debug("Process folder ...");
                    }
                    this.processFolder(folder);
                    if (log.isDebugEnabled()) {
                        log.debug("Done.");
                    }
                    this.closeQuietly(folder);
                }
                catch (Throwable throwable) {
                    this.closeQuietly(folder);
                    throw throwable;
                }
                this.closeQuietly(store);
            }
            catch (MessagingException e) {
                try {
                    log.error("une erreur est survenue pendant la traitement de la bo\u00eete {}", (Object)this.getPollenServiceConfig().getMailBoxUser(), (Object)e);
                    this.closeQuietly(store);
                }
                catch (Throwable throwable) {
                    this.closeQuietly(store);
                    throw throwable;
                }
            }
        }
    }

    private Store openSession() throws MessagingException {
        Properties properties = new Properties();
        properties.put("mail.host", this.getPollenServiceConfig().getMailBoxHost());
        properties.put("mail.store.protocol", this.getPollenServiceConfig().getMailBoxProtocol());
        Session session = Session.getInstance((Properties)properties);
        Store store = session.getStore();
        store.connect(this.getPollenServiceConfig().getMailBoxUser(), this.getPollenServiceConfig().getMailBoxPassword());
        return store;
    }

    private Folder openFolder(Store store) throws MessagingException {
        Folder defaultFolder = store.getDefaultFolder();
        Folder inboxFolder = defaultFolder.getFolder("INBOX");
        inboxFolder.open(2);
        return inboxFolder;
    }

    protected void processFolder(Folder folder) throws MessagingException {
        Flags flags = new Flags();
        flags.add(Flags.Flag.FLAGGED);
        FlagTerm searchNewMessages = new FlagTerm(flags, false);
        Object[] messages = folder.search((SearchTerm)searchNewMessages);
        if (ArrayUtils.isNotEmpty((Object[])messages)) {
            if (log.isDebugEnabled()) {
                log.debug("{} messages to process ...", (Object)messages.length);
            }
            Stream.of(messages).forEach(this::processMessage);
            folder.setFlags((Message[])messages, flags, true);
        } else if (log.isDebugEnabled()) {
            log.debug("No messages.");
        }
    }

    protected void processMessage(Message message) {
        block9: {
            try {
                String mailId;
                Object[] tos;
                if (log.isInfoEnabled()) {
                    log.info("Processing message \"{}\" received at {} ...", (Object)message.getSubject(), (Object)message.getReceivedDate());
                }
                if (ArrayUtils.isNotEmpty((Object[])(tos = message.getHeader("To"))) && StringUtils.isNotBlank((CharSequence)(mailId = this.getMailId((String)tos[0])))) {
                    PollenMailType mailType;
                    Optional<BiConsumer<MailBoxService, PollenMailReturnContext>> action;
                    if (log.isInfoEnabled()) {
                        log.info("Found mail id : {}", (Object)mailId);
                    }
                    PollenMailReturnContext context = this.extractMessageContext(message, mailId);
                    if (log.isInfoEnabled()) {
                        log.info("Computed mail context : {}", (Object)context);
                    }
                    if ((action = (mailType = context.getMailType()).getAction()).isEmpty()) {
                        if (log.isInfoEnabled()) {
                            log.info("PollenMailType {} has no action, nothing to do", (Object)mailType);
                        }
                    } else {
                        action.get().accept(this, context);
                    }
                }
            }
            catch (MessagingException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error("error on read message on mail box", (Throwable)e);
            }
        }
    }

    protected PollenMailReturnContext extractMessageContext(Message message, String mailId) {
        PollenMailReturnContext context;
        block4: {
            if (log.isDebugEnabled()) {
                log.debug("Extract context for mailId : {} ...", (Object)mailId);
            }
            context = new PollenMailReturnContext();
            context.setMessage(message);
            Object[] parts = mailId.split("\\+");
            if (parts.length > 0) {
                try {
                    PollenMailType pollenEmailType = PollenMailType.valueOf(parts[0]);
                    context.setMailType(pollenEmailType);
                    String[] ids = (String[])ArrayUtils.subarray((Object[])parts, (int)1, (int)parts.length);
                    context.setPoll(this.findEntity(ids, Poll.class));
                    context.setChoice(this.findEntity(ids, Choice.class));
                    context.setUser(this.findEntity(ids, PollenUser.class));
                    context.setReport(this.findEntity(ids, Report.class));
                    context.setComment(this.findEntity(ids, Comment.class));
                    context.setPrincipal(this.findEntity(ids, PollenPrincipal.class));
                }
                catch (IllegalArgumentException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error("unknown pollen email type {}", (Object)parts[0], (Object)e);
                }
            }
        }
        return context;
    }

    protected <E extends PollenEntity> E findEntity(String[] ids, Class<E> type) {
        PollenEmailKeyType keyType = PollenEmailKeyType.valueOfType(type);
        return (E)((PollenEntity)Stream.of(ids).filter(id -> id.startsWith(keyType.name())).findFirst().map(id -> id.replaceFirst(keyType.name(), "")).map(id -> this.findEntity(type, (String)id)).orElse(null));
    }

    protected <E extends PollenEntity> E findEntity(Class<E> type, String reduceId) {
        String topiaId = TopiaIdFactory.newTopiaId(type, (String)reduceId);
        PollenDao dao = this.getPersistenceContext().getDao(type);
        return (E)dao.forTopiaIdEquals(topiaId).findUnique();
    }

    protected void forwardToCreatorAction(Poll poll, Message message) {
        String email = poll.getCreator().getEmail();
        if (StringUtils.isNotBlank((CharSequence)email)) {
            if (log.isInfoEnabled()) {
                log.info("Forward to {}", (Object)email);
            }
            try {
                this.getEmailService().forward(message, Collections.singleton(email), I18n.l((Locale)this.getLocale(), (String)"pollen.service.mailBox.forward.poll.subject", (Object[])new Object[0]), I18n.l((Locale)this.getLocale(), (String)"pollen.service.mailBox.forward.poll.body", (Object[])new Object[0]), this.getPollenServiceConfig().getSmtpFrom());
            }
            catch (MessagingException | EmailException e) {
                if (log.isErrorEnabled()) {
                    log.error("Error on forward message", e);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn("No poll creator email for forward message");
        }
    }

    protected void undeliveredFlagPollenPrincipal(PollenPrincipal pollenPrincipal, Message message) {
        if (this.isUndeliveredMessage(message)) {
            if (log.isInfoEnabled()) {
                log.info("Set undelivered flag to {}", (Object)pollenPrincipal.getTopiaId());
            }
            pollenPrincipal.setInvalid(true);
            this.commit();
        }
    }

    protected boolean isUndeliveredMessage(Message message) {
        try {
            return message.getSubject().contains("Undelivered Mail Returned to Sender");
        }
        catch (MessagingException e) {
            if (log.isErrorEnabled()) {
                log.error("error on read message on mail box", (Throwable)e);
            }
            return false;
        }
    }

    protected String getMailId(String address) {
        String decodeAddress;
        String domainFrom;
        String userFrom;
        String mailId;
        block5: {
            InternetAddress fromAddress;
            mailId = null;
            String smtpFrom = this.getPollenServiceConfig().getSmtpFrom();
            try {
                fromAddress = new InternetAddress(smtpFrom);
            }
            catch (AddressException e) {
                throw new PollenTechnicalException("Error on smtp from address", e);
            }
            String[] emailSplit = fromAddress.getAddress().split("@");
            userFrom = emailSplit[0];
            domainFrom = emailSplit[1];
            decodeAddress = address;
            try {
                InternetAddress internetAddress = new InternetAddress(address);
                decodeAddress = internetAddress.getAddress();
            }
            catch (AddressException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error("address parse error : {}", (Object)address, (Object)e);
            }
        }
        if (decodeAddress.startsWith(userFrom + "+") && decodeAddress.endsWith("@" + domainFrom)) {
            mailId = decodeAddress.replace(userFrom + "+", "").replace("@" + domainFrom, "");
        }
        return mailId;
    }

    private void closeQuietly(Store store) {
        block3: {
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error("error occured while trying to disconnect from IMAP server", (Throwable)e);
                }
            }
        }
    }

    private void closeQuietly(Folder inboxFolder) {
        block3: {
            if (inboxFolder != null) {
                try {
                    inboxFolder.close(false);
                }
                catch (MessagingException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error("error occured while trying to close folder", (Throwable)e);
                }
            }
        }
    }
}

