package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ResultDAOAbstract<E extends Result> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Result.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.Result;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_NAME, v);
        return result;
    }

    public E findByResultValue(String v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_RESULT_VALUE, v);
        return result;
    }

    public List<E> findAllByResultValue(String v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_RESULT_VALUE, v);
        return result;
    }

    public E findByByGroup(boolean v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_BY_GROUP, v);
        return result;
    }

    public List<E> findAllByByGroup(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_BY_GROUP, v);
        return result;
    }

    public E findByVoteCountingType(int v) throws TopiaException {
        E result = findByProperty(Result.PROPERTY_VOTE_COUNTING_TYPE, v);
        return result;
    }

    public List<E> findAllByVoteCountingType(int v) throws TopiaException {
        List<E> result = findAllByProperty(Result.PROPERTY_VOTE_COUNTING_TYPE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Poll.class) {
            PollDAO dao = (PollDAO)
                getContext().getDAO(Poll.class);
            tmp = dao.findAllContainsResult(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Poll.class, entity);
        if (!list.isEmpty()) {
            result.put(Poll.class, list);
        }

        return result;
    }

} //ResultDAOAbstract<E extends Result>
