/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import org.chorem.pollen.business.dto.ResultListDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.common.VoteCountingType;

/**
 * Interface du service de gestion de résultats.
 *
 * @author fdesbois
 * @version $Id: ServiceResults.java 2836 2010-01-11 12:46:59Z schorlet $
 */
public interface ServiceResults {

    /**
     * Récupère les résultats d'un sondage.
     *
     * @param pollId identifiant du sondage
     * @return resultats, null si le sondage n'est pas fermé
     */
    public ResultListDTO getAllResults(String pollId);

    /**
     * Récupère les résultats d'un sondage pour un seul type de dépouillement.
     *
     * @param pollId identifiant du sondage
     * @param voteCounting : type de dépouillement
     * @return results, null si le sondage n'est pas fermé ou ne peut être
     *         dépouillé de cette façon
     */
    public ResultListDTO getResultsByVoteCounting(String pollId,
            VoteCountingType voteCounting);

    /**
     * Récupère les résultats d'un sondage avec le dépouillement normal sans
     * gestion des groupes. Utile si PollType == GROUP.
     *
     * @param pollId identifiant du sondage
     * @return results
     */
    public ResultListDTO getNormalResults(String pollId);

    /**
     * Récupère les résultats d'un sondage avec le dépouillement normal avec
     * gestion des groupes. Possible uniquement si PollType == GROUP.
     *
     * @param pollId identifiant du sondage
     * @return results si PollType == GROUP, null sinon
     */
    public ResultListDTO getGroupResults(String pollId);

    /**
     * Export d'un sondage au format XML.
     *
     * @param pollId identifiant ToPIA du sondage
     * @return chemin du fichier créé sur le serveur
     */
    public String exportPoll(String pollId);

    /**
     * Import d'un fichier XML.
     *
     * @param filePath chemin du fichier à importer
     * @return identifiant du sondage nouvellement importé
     */
    public String importPoll(String filePath);

    /**
     * Import d'un fichier XML.
     *
     * @param filePath chemin du fichier à importer
     * @param user l'utilisateur important le fichier
     * @return identifiant du sondage nouvellement importé
     */
    public String importPoll(String filePath, UserDTO user);
}