/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import java.util.List;
import java.util.Map;

import org.chorem.pollen.business.dto.PollDTO;

/**
 * Interface du service de gestion des sondages.
 *
 * @author enema
 * @version $Id: ServicePoll.java 2694 2009-08-06 14:47:22Z nrannou $
 */
public interface ServicePoll {

    /**
     * Création d'un sondage
     *
     * @param poll le sondage
     * @return identifiant du sondage créé
     */
    public String createPoll(PollDTO poll);

    /**
     * Mise à jour du sondage
     *
     * @param poll le sondage
     * @return true si le sondage a été mise à jour
     */
    public boolean updatePoll(PollDTO poll);

    /**
     * Suppression du sondage
     *
     * @param pollId le sondage
     * @return true si le sondage a été supprimé
     */
    public boolean deletePoll(String pollId);

    /**
     * Récupération d'un sondage à partir de son identifiant ToPIA
     *
     * @param pollId identifiant topia du sondage
     * @return le sondage
     */
    public PollDTO findPollById(String pollId);

    /**
     * Récupération d'un sondage à partir de son identifiant.
     *
     * @param pollId identifiant du sondage
     * @return le sondage
     */
    public PollDTO findPollByPollId(String pollId);

    /**
     * Récupération d'un sondage par son nom
     *
     * @param pollName nom du sondage
     * @return liste de sondages
     */
    public List<PollDTO> findPollsByName(String pollName);

    /**
     * Récupération des sondages d'un utilisateur
     *
     * @param userId Le créateur du sondage
     * @return liste de sondages
     */
    public List<PollDTO> findPollsByUser(String userId);

    /**
     * Récupération des sondages auxquels un utilisateur a participé.
     *
     * @param userId L'identifiant de l'utilisateur
     * @return liste de sondages
     */
    public List<PollDTO> findParticipatedPolls(String userId);

    /**
     * Récupération des sondages auxquels un utilisateur est invité.
     *
     * @param userId L'identifiant de l'utilisateur
     * @return liste de sondages
     */
    public List<PollDTO> findInvitedPolls(String userId);

    /**
     * Récupération des sondages en cours.
     *
     * @param withEndDate sélectionner uniquement les sondages ayant une date de
     *            fin
     * @return liste de sondages
     */
    public List<PollDTO> findRunningPolls(boolean withEndDate);

    /**
     * Récupération des sondages
     *
     * @param properties filtre
     * @return liste de sondages
     */
    public List<PollDTO> selectPolls(Map<String, Object> properties);

    /**
     * Ajout d'un vote à un sondage
     *
     * @param pollId identifiant topia du sondage
     * @param voteId l'identiiant topiaId du vote
     * @return true si le vote a été ajouté
     */
    public boolean addVoteToPoll(String pollId, String voteId);
}