/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.chorem.pollen.business.dto.CommentDTO;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.nuiton.topia.TopiaException;

/**
 * Gestion de la conversion des dtos Comment en entité et vice-versa.
 *
 * @author enema
 * @version $Id: DataCommentConverter.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class DataCommentConverter extends DataConverter {

    /**
     * Création d'un commentaire de sondage à partir d'un dto commentaire.
     *
     * @param commentDTO le dto choix
     * @param eComment l'entité choix
     */
    public void populateCommentEntity(CommentDTO commentDTO, Comment eComment)
            throws TopiaException {
        eComment.setText(commentDTO.getText());
        eComment.setPostDate(commentDTO.getPostDate());

        if (commentDTO.getPollId().length() > 0) {
            PollDAO pollDAO = PollenModelDAOHelper
                    .getPollDAO(super.transaction);
            Poll pollEntity = pollDAO.findByTopiaId(commentDTO.getPollId());
            eComment.setPoll(pollEntity);
        }
        if (commentDTO.getPollAccountId().length() > 0) {
            PollAccountDAO pollAccountDAO = PollenModelDAOHelper
                    .getPollAccountDAO(super.transaction);
            PollAccount pollAccountEntity = pollAccountDAO
                    .findByTopiaId(commentDTO.getPollAccountId());
            eComment.setPollAccount(pollAccountEntity);
        }
    }

    /**
     * Créer un DTO à partir d'un objet comment.
     *
     * @param eComment l'objet comment à transformer
     * @return le commentDTO créé
     */
    public CommentDTO createCommentDTO(Comment eComment) {
        CommentDTO commentDTO = new CommentDTO();
        commentDTO.setId(eComment.getTopiaId());
        commentDTO.setText(eComment.getText());
        commentDTO.setPostDate(eComment.getPostDate());

        if (eComment.getPoll() != null) {
            commentDTO.setPollId(eComment.getPoll().getTopiaId());
        }
        if (eComment.getPollAccount() != null) {
            commentDTO
                    .setPollAccountId(eComment.getPollAccount().getVotingId());
        }

        return commentDTO;
    }

    /**
     * Retourne une liste de dtos comment à partir d'une collection d'entités.
     *
     * @param cComments collection des entités comment
     * @return la liste des dtos comment
     */
    public List<CommentDTO> createCommentDTOs(Collection<Comment> cComments) {
        List<CommentDTO> results = new ArrayList<CommentDTO>();
        CommentDTO dto;
        for (Comment c : cComments) {
            dto = this.createCommentDTO(c);
            results.add(dto);
        }
        return results;
    }
}
