/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"comment"},
  numFields={"weight"}
)        
public interface Vote extends TopiaEntity {

    public static final String WEIGHT = "weight";

    public static final String COMMENT = "comment";

    public static final String CHOICE_VOTE_TO_CHOICE = "choiceVoteToChoice";

    public static final String POLL = "poll";

    public static final String POLL_ACCOUNT = "pollAccount";

    public static final String VOTING_LIST = "votingList";

    /**
     * @param weight La valeur de l'attribut weight à positionner.
     */
    public void setWeight(double weight);

    /**
     * @return La valeur de l'attribut weight.
     */
    public double getWeight();

    /**
     * @param comment La valeur de l'attribut comment à positionner.
     */
    public void setComment(java.lang.String comment);

    /**
     * @return La valeur de l'attribut comment.
     */
    public java.lang.String getComment();

    /**
     * @param voteToChoice L'instance de VoteToChoice à ajouter.
     */
    public void addChoiceVoteToChoice(org.chorem.pollen.business.persistence.VoteToChoice voteToChoice);

    /**
     * @param voteToChoice Les instances de VoteToChoice à ajouter.
     */
    public void addAllChoiceVoteToChoice(java.util.List<org.chorem.pollen.business.persistence.VoteToChoice> voteToChoice);

    /**
     * @param voteToChoice La Collection de VoteToChoice à positionner.
     */
    public void setChoiceVoteToChoice(java.util.List<org.chorem.pollen.business.persistence.VoteToChoice> voteToChoice);

    /**
     * @param voteToChoice L'instance de VoteToChoice à retirer.
     */
    public void removeChoiceVoteToChoice(org.chorem.pollen.business.persistence.VoteToChoice voteToChoice);

    /**
     * Vide la Collection de VoteToChoice.
     */
    public void clearChoiceVoteToChoice();

    /**
     * @return La liste des attributs VoteToChoice.
     */
    public java.util.List<org.chorem.pollen.business.persistence.VoteToChoice> getChoiceVoteToChoice();

    /**
     * Recupère l'attribut choice à partir de son topiaId.
     *
     * @param topiaId le topia id de l'attribut recherchée
     * 
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.VoteToChoice getChoiceVoteToChoiceByTopiaId(String topiaId);

    /**
     * @return L'attribut VoteToChoice associé à la valeur <code>value</code> de l'attribut choice.
     */
    public org.chorem.pollen.business.persistence.VoteToChoice getChoiceVoteToChoice(org.chorem.pollen.business.persistence.Choice value);

    /**
     * @return Le nombre d'éléments de la collection choice.
     */
    public int sizeChoiceVoteToChoice();
  
    /**
     * @return <code>true</code> si la collection choiceVoteToChoice est vide.
     */
    public boolean isChoiceVoteToChoiceEmpty();
    /**
     * @param poll La valeur de l'attribut poll à positionner.
     */
    public void setPoll(org.chorem.pollen.business.persistence.Poll poll);

    /**
     * @return La valeur de l'attribut poll.
     */
    public org.chorem.pollen.business.persistence.Poll getPoll();

    /**
     * @param pollAccount La valeur de l'attribut pollAccount à positionner.
     */
    public void setPollAccount(org.chorem.pollen.business.persistence.PollAccount pollAccount);

    /**
     * @return La valeur de l'attribut pollAccount.
     */
    public org.chorem.pollen.business.persistence.PollAccount getPollAccount();

    /**
     * @param votingList La valeur de l'attribut votingList à positionner.
     */
    public void setVotingList(org.chorem.pollen.business.persistence.VotingList votingList);

    /**
     * @return La valeur de l'attribut votingList.
     */
    public org.chorem.pollen.business.persistence.VotingList getVotingList();

} //Vote
