/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Classe DTO représentant un votant.
 *
 * @author amine
 * @author rannou
 * @version $Id: PollAccountDTO.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class PollAccountDTO implements Serializable {

    private String id = "";

    private String votingId = "";

    private String userId = "";

    private String email = "";

    private double weight = 1;

    private boolean hasVoted = false;

    private String votingListId = "";

    private String personListId = "";

    private List<VoteDTO> voteDTOs = new ArrayList<VoteDTO>();

    public PollAccountDTO() {

    }

    public PollAccountDTO(String id) {
        this.id = id;
    }

    public PollAccountDTO(String votingId, String email, String personListId,
            String votingListId, String userId) {
        super();
        this.votingId = votingId;
        this.email = email;
        this.personListId = personListId;
        this.votingListId = votingListId;
        this.userId = userId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVotingId() {
        return votingId;
    }

    public void setVotingId(String votingId) {
        this.votingId = votingId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public double getWeight() {
        return weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public boolean isHasVoted() {
        return hasVoted;
    }

    public void setHasVoted(boolean hasVoted) {
        this.hasVoted = hasVoted;
    }

    public String getVotingListId() {
        return votingListId;
    }

    public void setVotingListId(String votingListId) {
        this.votingListId = votingListId;
    }

    public String getPersonListId() {
        return personListId;
    }

    public void setPersonListId(String personListId) {
        this.personListId = personListId;
    }

    public List<VoteDTO> getVoteDTOs() {
        return voteDTOs;
    }

    public void setVoteDTOs(List<VoteDTO> voteDTOs) {
        this.voteDTOs = voteDTOs;
    }

}
