/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business;

import java.util.List;
import java.util.Map;

import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.persistence.PreventRule;
import org.nuiton.topia.TopiaContext;

/**
 * Interface de gestion des règles de notification.
 *
 * @author rannou
 * @version $Id: ServicePreventRule.java 2613 2009-06-30 13:32:57Z nrannou $
 */
public interface ServicePreventRule {

    /**
     * Création d'une règle de notification.
     *
     * @param preventRule le dto de la règle
     * @return l'identifiant de la règle
     */
    public String createPreventRule(PreventRuleDTO preventRule);

    /**
     * Création des règles de notification du sondage
     *
     * @param preventRules les dtos des règles
     * @param pollId l'identifiant du sondage
     * @param transaction la transaction du sondage
     * @return les règles créées
     */
    public List<PreventRule> createPreventRules(
            List<PreventRuleDTO> preventRules, String pollId,
            TopiaContext transaction);

    /**
     * Mise à jour d'une règle de notification.
     *
     * @param preventRuleDTO le dto de la règle
     * @return true si la règle a été mise à jours
     */
    public boolean updatePreventRule(PreventRuleDTO preventRuleDTO);

    /**
     * Suppression d'une règle de notification.
     *
     * @param preventRuleId l'identifiant de la règle
     * @return true si la règle a été mise à jours
     */
    public boolean deletePreventRule(String preventRuleId);

    /**
     * Recherche d'un règle de notification par son identifiant.
     *
     * @param preventRuleId l'identifiant de la règle
     * @return la règle
     */
    public PreventRuleDTO findPreventRuleById(String preventRuleId);

    /**
     * Recherche de toutes les règles de notification.
     *
     * @param properties filtre sur les champs de la table preventRule
     * @return les règles
     */
    public List<PreventRuleDTO> selectPreventRules(
            Map<String, Object> properties);
}
