/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.chorem.callao.entity.Journal;
import org.chorem.callao.entity.Transaction;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class JournalAbstract
extends TopiaEntityAbstract
implements Journal {
    private String label;
    private String prefix;
    public String description;
    public Collection<Transaction> transaction;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Journal.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Journal.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "label", String.class, (Object)this.label);
        visitor.visit((TopiaEntity)this, "prefix", String.class, (Object)this.prefix);
        visitor.visit((TopiaEntity)this, "description", String.class, (Object)this.description);
        visitor.visit((TopiaEntity)this, "transaction", Collection.class, Transaction.class, this.transaction);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<Transaction> tmp = new ArrayList<Transaction>();
        if (this.getTransaction() != null) {
            tmp.addAll(this.getTransaction());
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }

    @Override
    public void setLabel(String value) {
        String _oldValue = this.label;
        this.fireOnPreWrite("label", _oldValue, value);
        this.label = value;
        this.fireOnPostWrite("label", _oldValue, value);
    }

    @Override
    public String getLabel() {
        this.fireOnPreRead("label", this.label);
        String result = this.label;
        this.fireOnPostRead("label", this.label);
        return result;
    }

    @Override
    public void setPrefix(String value) {
        String _oldValue = this.prefix;
        this.fireOnPreWrite("prefix", _oldValue, value);
        this.prefix = value;
        this.fireOnPostWrite("prefix", _oldValue, value);
    }

    @Override
    public String getPrefix() {
        this.fireOnPreRead("prefix", this.prefix);
        String result = this.prefix;
        this.fireOnPostRead("prefix", this.prefix);
        return result;
    }

    @Override
    public void setDescription(String value) {
        String _oldValue = this.description;
        this.fireOnPreWrite("description", _oldValue, value);
        this.description = value;
        this.fireOnPostWrite("description", _oldValue, value);
    }

    @Override
    public String getDescription() {
        this.fireOnPreRead("description", this.description);
        String result = this.description;
        this.fireOnPostRead("description", this.description);
        return result;
    }

    @Override
    public void addTransaction(Transaction transaction) {
        this.fireOnPreWrite("transaction", null, transaction);
        if (this.transaction == null) {
            this.transaction = new ArrayList<Transaction>();
        }
        transaction.setJournal(this);
        this.transaction.add(transaction);
        this.fireOnPostWrite("transaction", this.transaction.size(), null, transaction);
    }

    @Override
    public void addAllTransaction(Collection<Transaction> values) {
        if (values == null) {
            return;
        }
        for (Transaction item : values) {
            this.addTransaction(item);
        }
    }

    @Override
    public Transaction getTransactionByTopiaId(String topiaId) {
        return (Transaction)TopiaEntityHelper.getEntityByTopiaId(this.transaction, (String)topiaId);
    }

    @Override
    public void setTransaction(Collection<Transaction> values) {
        Collection<Transaction> _oldValue = this.transaction;
        this.fireOnPreWrite("transaction", _oldValue, values);
        this.transaction = values;
        this.fireOnPostWrite("transaction", _oldValue, values);
    }

    @Override
    public void removeTransaction(Transaction value) {
        this.fireOnPreWrite("transaction", value, null);
        if (this.transaction == null || !this.transaction.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setJournal(null);
        this.fireOnPostWrite("transaction", this.transaction.size() + 1, value, null);
    }

    @Override
    public void clearTransaction() {
        if (this.transaction == null) {
            return;
        }
        for (Transaction item : this.transaction) {
            item.setJournal(null);
        }
        ArrayList<Transaction> _oldValue = new ArrayList<Transaction>(this.transaction);
        this.fireOnPreWrite("transaction", _oldValue, this.transaction);
        this.transaction.clear();
        this.fireOnPostWrite("transaction", _oldValue, this.transaction);
    }

    @Override
    public Collection<Transaction> getTransaction() {
        return this.transaction;
    }

    @Override
    public int sizeTransaction() {
        if (this.transaction == null) {
            return 0;
        }
        return this.transaction.size();
    }

    @Override
    public boolean isTransactionEmpty() {
        int size = this.sizeTransaction();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("label", (Object)this.label).append("prefix", (Object)this.prefix).append("description", (Object)this.description).toString();
        return result;
    }
}

