/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link TimeSpan}.
 */
public abstract class TimeSpanAbstract extends TopiaEntityAbstract implements TimeSpan {

    private Date beginTimeSpan;

    private Date endTimeSpan;

    private boolean locked;

    public Period period;

    public Collection<Transaction> transaction;

    /**
     * Constructeur de TimeSpanAbstract par défaut.
     */
    public TimeSpanAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TimeSpan.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TimeSpan.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "beginTimeSpan", Date.class, beginTimeSpan);
        visitor.visit(this, "endTimeSpan", Date.class, endTimeSpan);
        visitor.visit(this, "locked", boolean.class, locked);
        visitor.visit(this, "period", Period.class, period);
        visitor.visit(this, "transaction", Collection.class, Transaction.class, transaction);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see TimeSpan#setBeginTimeSpan(Date)
     */
    @Override
    public void setBeginTimeSpan(Date value) {
        Date _oldValue = this.beginTimeSpan;
        fireOnPreWrite("beginTimeSpan", _oldValue, value);
        this.beginTimeSpan = value;
        fireOnPostWrite("beginTimeSpan", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TimeSpan#getBeginTimeSpan()
     */
    @Override
    public Date getBeginTimeSpan() {
        fireOnPreRead("beginTimeSpan", beginTimeSpan);
        Date result = this.beginTimeSpan;
        fireOnPostRead("beginTimeSpan", beginTimeSpan);
        return result;
    }

    /* (non-Javadoc)
     * @see TimeSpan#setEndTimeSpan(Date)
     */
    @Override
    public void setEndTimeSpan(Date value) {
        Date _oldValue = this.endTimeSpan;
        fireOnPreWrite("endTimeSpan", _oldValue, value);
        this.endTimeSpan = value;
        fireOnPostWrite("endTimeSpan", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TimeSpan#getEndTimeSpan()
     */
    @Override
    public Date getEndTimeSpan() {
        fireOnPreRead("endTimeSpan", endTimeSpan);
        Date result = this.endTimeSpan;
        fireOnPostRead("endTimeSpan", endTimeSpan);
        return result;
    }

    /* (non-Javadoc)
     * @see TimeSpan#setLocked(boolean)
     */
    @Override
    public void setLocked(boolean value) {
        boolean _oldValue = this.locked;
        fireOnPreWrite("locked", _oldValue, value);
        this.locked = value;
        fireOnPostWrite("locked", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TimeSpan#getLocked()
     */
    @Override
    public boolean getLocked() {
        fireOnPreRead("locked", locked);
        boolean result = this.locked;
        fireOnPostRead("locked", locked);
        return result;
    }

    /* (non-Javadoc)
     * @see TimeSpan#setPeriod(Period)
     */
    @Override
    public void setPeriod(Period value) {
        Period _oldValue = this.period;
        fireOnPreWrite("period", _oldValue, value);
        this.period = value;
        fireOnPostWrite("period", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TimeSpan#getPeriod()
     */
    @Override
    public Period getPeriod() {
        fireOnPreRead("period", period);
        Period result = this.period;
        fireOnPostRead("period", period);
        return result;
    }

    /* (non-Javadoc)
     * @see TimeSpan#addTransaction(Transaction)
     */
    @Override
    public void addTransaction(Transaction transaction) {
        fireOnPreWrite("transaction", null, transaction);
        if (this.transaction == null) {
            this.transaction = new ArrayList<Transaction>();
        }
        transaction.setTimeSpan(this);
        this.transaction.add(transaction);
        fireOnPostWrite("transaction", this.transaction.size(), null, transaction);
    }

    /* (non-Javadoc)
     * @see TimeSpan#addAllTransaction(Collection<Transaction>)
     */
    @Override
    public void addAllTransaction(Collection<Transaction> values) {
        if (values == null) {
            return;
        }
        for (Transaction item : values) {
            addTransaction(item);
        }
    }

    /* (non-Javadoc)
     * @see TimeSpan#getTransactionByTopiaId(String)
     */
    @Override
    public Transaction getTransactionByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(transaction, topiaId);
    }
 
    /* (non-Javadoc)
     * @see TimeSpan#setTransaction(Collection<Transaction>)
     */
    @Override
    public void setTransaction(Collection<Transaction> values) {
        Collection<Transaction> _oldValue = transaction;
        fireOnPreWrite("transaction", _oldValue, values);
        transaction = values;
        fireOnPostWrite("transaction", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see TimeSpan#removeTransaction(Transaction)
     */
    @Override
    public void removeTransaction(Transaction value) {
        fireOnPreWrite("transaction", value, null);
        if ((this.transaction == null) || (!this.transaction.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setTimeSpan(null);
        fireOnPostWrite("transaction", this.transaction.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see TimeSpan#clearTransaction()
     */
    @Override
    public void clearTransaction() {
        if (this.transaction == null) {
            return;
        }
        for (Transaction item : this.transaction) {
            item.setTimeSpan(null);
        }
        Collection<Transaction> _oldValue = new ArrayList<Transaction>(this.transaction);
        fireOnPreWrite("transaction", _oldValue, this.transaction);
        this.transaction.clear();
        fireOnPostWrite("transaction", _oldValue, this.transaction);
    }

    /* (non-Javadoc)
     * @see TimeSpan#getTransaction()
     */
    @Override
    public Collection<Transaction> getTransaction() {
        return transaction;
    }

    /* (non-Javadoc)
     * @see TimeSpan#sizeTransaction()
     */
    @Override
    public int sizeTransaction() {
        if (transaction == null) {
            return 0;
        }
        return transaction.size();
    }

    /* (non-Javadoc)
     * @see TimeSpan#isTransactionEmpty()
     */
    @Override
    public boolean isTransactionEmpty() {
        int size = sizeTransaction();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("beginTimeSpan", this.beginTimeSpan).
            append("endTimeSpan", this.endTimeSpan).
            append("locked", this.locked).
         toString();
        return result;
    }
        
} //TimeSpanAbstract
