/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class ScmReport
extends AbstractProjectInfoReport {
    protected ScmManager scmManager;
    private String checkoutDirectoryName;
    private String anonymousConnection;
    private String developerConnection;
    private String webAccessUrl;

    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.scm.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.scm.description");
    }

    public void executeReport(Locale locale) {
        ScmRenderer r = new ScmRenderer(this.getLog(), this.scmManager, this.getSink(), this.getProject().getModel(), this.i18n, locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection);
        r.render();
    }

    public String getOutputName() {
        return "source-repository";
    }

    private static class ScmRenderer
    extends AbstractMavenReportRenderer {
        private Log log;
        private Model model;
        private I18N i18n;
        private Locale locale;
        private ScmManager scmManager;
        private String anonymousConnection;
        private String devConnection;
        private String checkoutDirectoryName;
        private String webAccessUrl;

        ScmRenderer(Log log, ScmManager scmManager, Sink sink, Model model, I18N i18n, Locale locale, String checkoutDirName, String webAccessUrl, String anonymousConnection, String devConnection) {
            super(sink);
            this.log = log;
            this.scmManager = scmManager;
            this.model = model;
            this.i18n = i18n;
            this.locale = locale;
            this.checkoutDirectoryName = checkoutDirName;
            this.webAccessUrl = webAccessUrl;
            this.anonymousConnection = anonymousConnection;
            this.devConnection = devConnection;
        }

        public String getTitle() {
            return this.i18n.getString("project-info-report", this.locale, "report.scm.title");
        }

        public void renderBody() {
            Scm scm = this.model.getScm();
            if (scm == null) {
                this.startSection(this.getTitle());
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.noscm"));
                this.endSection();
                return;
            }
            if (StringUtils.isEmpty((String)this.anonymousConnection) && StringUtils.isEmpty((String)this.devConnection) && StringUtils.isEmpty((String)scm.getUrl())) {
                this.startSection(this.getTitle());
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.noscm"));
                this.endSection();
                return;
            }
            ScmRepository anonymousRepository = this.getScmRepository(this.anonymousConnection);
            ScmRepository devRepository = this.getScmRepository(this.devConnection);
            this.renderOverViewSection(anonymousRepository);
            this.renderWebAccesSection(this.webAccessUrl);
            this.renderAnonymousAccessSection(anonymousRepository);
            this.renderDeveloperAccessSection(devRepository);
            this.renderAccessBehindFirewallSection(devRepository);
            this.renderAccessThroughProxySection(anonymousRepository, devRepository);
        }

        private void renderOverViewSection(ScmRepository anonymousRepository) {
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.overview.title"));
            if (ScmRenderer.isScmSystem(anonymousRepository, "clearcase")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.clearcase.intro"));
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "cvs")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.cvs.intro"));
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "perforce")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.perforce.intro"));
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "starteam")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.starteam.intro"));
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.svn.intro"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.general.intro"));
            }
            this.endSection();
        }

        private void renderWebAccesSection(String scmUrl) {
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.webaccess.title"));
            if (StringUtils.isEmpty((String)scmUrl)) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.webaccess.nourl"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.webaccess.url"));
                this.verbatimLink(scmUrl, scmUrl);
            }
            this.endSection();
        }

        private void renderAnonymousAccessSection(ScmRepository anonymousRepository) {
            if (ScmRenderer.isScmSystem(anonymousRepository, "clearcase") || ScmRenderer.isScmSystem(anonymousRepository, "perforce") || ScmRenderer.isScmSystem(anonymousRepository, "starteam") || StringUtils.isEmpty((String)this.anonymousConnection)) {
                return;
            }
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.anonymousaccess.title"));
            if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "cvs")) {
                CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessCVS(cvsRepo);
            } else if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessSVN(svnRepo);
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.anonymousaccess.general.intro"));
                this.verbatimText(this.anonymousConnection.substring(4));
            }
            this.endSection();
        }

        private void renderDeveloperAccessSection(ScmRepository devRepository) {
            if (StringUtils.isEmpty((String)this.devConnection)) {
                return;
            }
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.title"));
            if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "clearcase")) {
                this.developerAccessClearCase();
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "cvs")) {
                CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessCVS(cvsRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "perforce")) {
                PerforceScmProviderRepository perforceRepo = (PerforceScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessPerforce(perforceRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "starteam")) {
                StarteamScmProviderRepository starteamRepo = (StarteamScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessStarteam(starteamRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessSVN(svnRepo);
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.general.intro"));
                this.verbatimText(this.devConnection.substring(4));
            }
            this.endSection();
        }

        private void renderAccessBehindFirewallSection(ScmRepository devRepository) {
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.accessbehindfirewall.title"));
            if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessbehindfirewall.svn.intro"));
                StringBuffer sb = new StringBuffer();
                sb.append("$ svn checkout ").append(svnRepo.getUrl());
                sb.append(" ").append(this.checkoutDirectoryName);
                this.verbatimText(sb.toString());
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "cvs")) {
                this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.accessbehindfirewall.cvs.intro"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessbehindfirewall.general.intro"));
            }
            this.endSection();
        }

        private void renderAccessThroughProxySection(ScmRepository anonymousRepository, ScmRepository devRepository) {
            if (ScmRenderer.isScmSystem(anonymousRepository, "svn") || ScmRenderer.isScmSystem(devRepository, "svn")) {
                this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.accessthroughtproxy.title"));
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessthroughtproxy.svn.intro1"));
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessthroughtproxy.svn.intro2"));
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessthroughtproxy.svn.intro3"));
                StringBuffer sb = new StringBuffer();
                sb.append("[global]");
                sb.append("\n");
                sb.append("http-proxy-host = your.proxy.name").append("\n");
                sb.append("http-proxy-port = 3128").append("\n");
                this.verbatimText(sb.toString());
                this.endSection();
            }
        }

        private void developerAccessClearCase() {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.clearcase.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ cleartool checkout ");
            this.verbatimText(command.toString());
        }

        private void anonymousAccessCVS(CvsScmProviderRepository cvsRepo) {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.anonymousaccess.cvs.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ cvs -d ").append(cvsRepo.getCvsRoot()).append(" login");
            command.append("\n");
            command.append("$ cvs -z3 -d ").append(cvsRepo.getCvsRoot());
            command.append(" co ").append(cvsRepo.getModule());
            this.verbatimText(command.toString());
        }

        private void developerAccessCVS(CvsScmProviderRepository cvsRepo) {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.cvs.intro"));
            String cvsRoot = StringUtils.replace((String)cvsRepo.getCvsRoot(), (String)cvsRepo.getUser(), (String)"username");
            StringBuffer command = new StringBuffer();
            command.append("$ cvs -d ").append(cvsRoot).append(" login");
            command.append("\n");
            command.append("$ cvs -z3 -d ").append(cvsRoot).append(" co ").append(cvsRepo.getModule());
            this.verbatimText(command.toString());
        }

        private void developerAccessPerforce(PerforceScmProviderRepository perforceRepo) {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.perforce.intro"));
            StringBuffer command = new StringBuffer();
            command.append("$ p4");
            if (!StringUtils.isEmpty((String)perforceRepo.getHost())) {
                command.append(" -H ").append(perforceRepo.getHost());
            }
            if (perforceRepo.getPort() > 0) {
                command.append(" -p ").append(perforceRepo.getPort());
            }
            command.append(" -u username");
            command.append(" -P password");
            command.append(" ");
            command.append(perforceRepo.getPath());
            command.append("\n");
            command.append("$ p4 submit -c \"A comment\"");
            this.verbatimText(command.toString());
        }

        private void developerAccessStarteam(StarteamScmProviderRepository starteamRepo) {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.starteam.intro"));
            StringBuffer command = new StringBuffer();
            String fullUrl = StringUtils.replace((String)starteamRepo.getFullUrl(), (String)starteamRepo.getUser(), (String)"username");
            fullUrl = StringUtils.replace((String)fullUrl, (String)starteamRepo.getPassword(), (String)"password");
            command.append("$ stcmd co -x -nologo -stop -p ");
            command.append(fullUrl);
            command.append(" -is");
            command.append("\n");
            command.append("$ stcmd ci -x -nologo -stop -p ");
            command.append(fullUrl);
            command.append(" -f NCI -is");
            this.verbatimText(command.toString());
        }

        private void anonymousAccessSVN(SvnScmProviderRepository svnRepo) {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.anonymousaccess.svn.intro"));
            StringBuffer sb = new StringBuffer();
            sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.checkoutDirectoryName);
            this.verbatimText(sb.toString());
        }

        private void developerAccessSVN(SvnScmProviderRepository svnRepo) {
            if (svnRepo.getUrl() != null) {
                if (svnRepo.getUrl().startsWith("https://")) {
                    this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro1.https"));
                } else if (svnRepo.getUrl().startsWith("svn://")) {
                    this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro1.svn"));
                } else if (svnRepo.getUrl().startsWith("svn+ssh://")) {
                    this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro1.svnssh"));
                } else {
                    this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro1.other"));
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.checkoutDirectoryName);
            this.verbatimText(sb.toString());
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro2"));
            sb = new StringBuffer();
            sb.append("$ svn commit --username your-username -m \"A message\"");
            this.verbatimText(sb.toString());
        }

        public ScmRepository getScmRepository(String scmUrl) {
            ScmRepository repo;
            block13: {
                if (StringUtils.isEmpty((String)scmUrl)) {
                    return null;
                }
                repo = null;
                ArrayList<String> messages = new ArrayList<String>();
                try {
                    messages.addAll(this.scmManager.validateScmRepository(scmUrl));
                }
                catch (Exception e) {
                    messages.add(e.getMessage());
                }
                if (messages.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    boolean isIntroAdded = false;
                    Iterator it = messages.iterator();
                    while (it.hasNext()) {
                        String msg = it.next().toString();
                        if (msg.startsWith("No such provider")) continue;
                        if (!isIntroAdded) {
                            sb.append("This SCM url '" + scmUrl + "' is invalid due to the following errors:");
                            sb.append("\n");
                            isIntroAdded = true;
                        }
                        sb.append(" * ");
                        sb.append(msg);
                        sb.append("\n");
                    }
                    if (StringUtils.isNotEmpty((String)sb.toString())) {
                        sb.append("For more information about SCM URL Format, please refer to: http://maven.apache.org/scm/scm-url-format.html");
                        throw new IllegalArgumentException(sb.toString());
                    }
                }
                try {
                    repo = this.scmManager.makeScmRepository(scmUrl);
                }
                catch (NoSuchScmProviderException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
                catch (ScmRepositoryException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            return repo;
        }

        private static boolean isScmSystem(ScmRepository scmRepository, String scmProvider) {
            if (StringUtils.isEmpty((String)scmProvider)) {
                return false;
            }
            return scmRepository != null && scmProvider.equalsIgnoreCase(scmRepository.getProvider());
        }
    }
}

