/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.ObjectAlreadyExistsException;
import net.sf.webdav.exceptions.ObjectNotFoundException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.fromcatalina.RequestUtil;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.AbstractMethod;
import net.sf.webdav.methods.DeterminableMethod;
import net.sf.webdav.methods.DoDelete;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoCopy
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoCopy.class);
    private IWebdavStore _store;
    private ResourceLocks _resourceLocks;
    private DoDelete _doDelete;
    private boolean _readOnly;

    public DoCopy(IWebdavStore store, ResourceLocks resourceLocks, DoDelete doDelete, boolean readOnly) {
        this._store = store;
        this._resourceLocks = resourceLocks;
        this._doDelete = doDelete;
        this._readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        String path = this.getRelativePath(req);
        if (!this._readOnly) {
            String tempLockOwner = "doCopy" + System.currentTimeMillis() + req.toString();
            if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                try {
                    if (this.copyResource(transaction, req, resp)) return;
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(409, req.getRequestURI());
                    return;
                }
                catch (ObjectNotFoundException e) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean copyResource(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws WebdavException, IOException, LockFailedException {
        String lockOwner;
        String destinationPath = this.parseDestinationHeader(req, resp);
        if (destinationPath == null) {
            return false;
        }
        String path = this.getRelativePath(req);
        if (path.equals(destinationPath)) {
            resp.sendError(403);
            return false;
        }
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        String parentDestinationPath = this.getParentPath(this.getCleanPath(destinationPath));
        if (!this.checkLocks(transaction, req, resp, this._resourceLocks, parentDestinationPath)) {
            resp.setStatus(423);
            return false;
        }
        if (!this.checkLocks(transaction, req, resp, this._resourceLocks, destinationPath)) {
            resp.setStatus(423);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        if (this._resourceLocks.lock(transaction, destinationPath, lockOwner = "copyResource" + System.currentTimeMillis() + req.toString(), false, 0, 10, true)) {
            StoredObject destinationSo = null;
            try {
                StoredObject copySo = this._store.getStoredObject(transaction, path);
                if (copySo == null) {
                    resp.sendError(404);
                    boolean bl = false;
                    return bl;
                }
                if (copySo.isNullResource()) {
                    String methodsAllowed = DeterminableMethod.determineMethodsAllowed(copySo);
                    resp.addHeader("Allow", methodsAllowed);
                    resp.sendError(405);
                    boolean bl = false;
                    return bl;
                }
                errorList = new Hashtable();
                destinationSo = this._store.getStoredObject(transaction, destinationPath);
                if (overwrite) {
                    if (destinationSo != null) {
                        this._doDelete.deleteResource(transaction, destinationPath, errorList, req, resp);
                    } else {
                        resp.setStatus(201);
                    }
                } else {
                    if (destinationSo != null) {
                        resp.sendError(412);
                        boolean bl = false;
                        return bl;
                    }
                    resp.setStatus(201);
                }
                this.copy(transaction, path, destinationPath, errorList, req, resp);
                if (errorList.isEmpty()) return true;
                this.sendReport(req, resp, errorList);
                return true;
            }
            finally {
                this._resourceLocks.unlockTemporaryLockedObjects(transaction, destinationPath, lockOwner);
            }
        } else {
            resp.sendError(500);
            return false;
        }
    }

    private void copy(ITransaction transaction, String sourcePath, String destinationPath, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException, IOException {
        StoredObject sourceSo = this._store.getStoredObject(transaction, sourcePath);
        if (sourceSo.isResource()) {
            this._store.createResource(transaction, destinationPath);
            long resourceLength = this._store.setResourceContent(transaction, destinationPath, this._store.getResourceContent(transaction, sourcePath), null, null);
            if (resourceLength != -1L) {
                StoredObject destinationSo = this._store.getStoredObject(transaction, destinationPath);
                destinationSo.setResourceLength(resourceLength);
            }
        } else if (sourceSo.isFolder()) {
            this.copyFolder(transaction, sourcePath, destinationPath, errorList, req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void copyFolder(ITransaction transaction, String sourcePath, String destinationPath, Hashtable<String, Integer> errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        this._store.createFolder(transaction, destinationPath);
        boolean infiniteDepth = true;
        String depth = req.getHeader("Depth");
        if (depth != null && depth.equals("0")) {
            infiniteDepth = false;
        }
        if (infiniteDepth) {
            String[] children = this._store.getChildrenNames(transaction, sourcePath);
            children = children == null ? new String[]{} : children;
            for (int i = children.length - 1; i >= 0; --i) {
                children[i] = "/" + children[i];
                try {
                    StoredObject childSo = this._store.getStoredObject(transaction, sourcePath + children[i]);
                    if (childSo.isResource()) {
                        this._store.createResource(transaction, destinationPath + children[i]);
                        long resourceLength = this._store.setResourceContent(transaction, destinationPath + children[i], this._store.getResourceContent(transaction, sourcePath + children[i]), null, null);
                        if (resourceLength == -1L) continue;
                        StoredObject destinationSo = this._store.getStoredObject(transaction, destinationPath + children[i]);
                        destinationSo.setResourceLength(resourceLength);
                        continue;
                    }
                    this.copyFolder(transaction, sourcePath + children[i], destinationPath + children[i], errorList, req, resp);
                    continue;
                }
                catch (AccessDeniedException e) {
                    errorList.put(destinationPath + children[i], new Integer(403));
                    continue;
                }
                catch (ObjectNotFoundException e) {
                    errorList.put(destinationPath + children[i], new Integer(404));
                    continue;
                }
                catch (ObjectAlreadyExistsException e) {
                    errorList.put(destinationPath + children[i], new Integer(409));
                    continue;
                }
                catch (WebdavException e) {
                    errorList.put(destinationPath + children[i], new Integer(500));
                }
            }
        }
    }

    private String parseDestinationHeader(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return null;
        }
        int protocolIndex = (destinationPath = RequestUtil.URLDecode(destinationPath, "UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = this.normalize(destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        return destinationPath;
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }
}

