/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IInlineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public abstract class PDFInlineStackingLM
extends PDFStackingLM
implements IInlineStackingLayoutManager {
    protected List children = new ArrayList();

    @Override
    public List getChildren() {
        return this.children;
    }

    public PDFInlineStackingLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    protected void addChild(PDFAbstractLM child) {
        this.children.add(child);
        this.child = child;
    }

    @Override
    protected void cancelChildren() throws BirtException {
        int i = 0;
        while (i < this.children.size()) {
            ILayoutManager child = (ILayoutManager)this.children.get(i);
            child.cancel();
            ++i;
        }
    }

    @Override
    protected boolean hasNextChild() {
        return true;
    }

    @Override
    public void autoPageBreak() {
        int i = 0;
        while (i < this.children.size()) {
            PDFAbstractLM childLM = (PDFAbstractLM)this.children.get(i);
            childLM.autoPageBreak();
            ++i;
        }
        this.closeLayout();
        this.submitRoot();
    }

    @Override
    protected boolean clearCache() {
        return true;
    }

    protected void verticalAlign() {
        Iterator iter = this.root.getChildren();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            IStyle childStyle = child.getStyle();
            String vAlign = childStyle.getVerticalAlign();
            if (childStyle == null) continue;
            int spacing = this.root.getHeight() - child.getAllocatedHeight();
            if (spacing < 0) {
                spacing = 0;
            }
            if ("baseline".equalsIgnoreCase(vAlign)) {
                int lineHeight = this.parent.getLineHeight();
                if (lineHeight > 0) {
                    child.setPosition(child.getX(), child.getY() + this.getMaxBaseLine() - child.getBaseLine() + spacing / 2);
                    continue;
                }
                child.setPosition(child.getX(), child.getY() + this.getMaxBaseLine() - child.getBaseLine());
                continue;
            }
            if ("bottom".equalsIgnoreCase(vAlign)) {
                child.setPosition(child.getX(), spacing + child.getY());
                continue;
            }
            if (!"middle".equalsIgnoreCase(vAlign)) continue;
            child.setPosition(child.getX(), spacing / 2 + child.getY());
        }
    }

    private int getMaxBaseLine() {
        int maxChildrenBaseLine = this.root.getMaxChildrenBaseLine();
        if (maxChildrenBaseLine == 0) {
            Iterator iter = this.root.getChildren();
            int maxChildrenBaseLineBelow = this.root.getMaxChildrenBaseLineBelow();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                maxChildrenBaseLine = Math.max(maxChildrenBaseLine, child.getBaseLine());
                maxChildrenBaseLineBelow = Math.max(maxChildrenBaseLineBelow, child.getAllocatedHeight() - child.getBaseLine());
            }
            this.root.setContentHeight(Math.max(this.root.getContentHeight(), maxChildrenBaseLine + maxChildrenBaseLineBelow));
            this.root.setMaxChildrenBaseLine(maxChildrenBaseLine);
            this.root.setMaxChildrenBaseLineBelow(maxChildrenBaseLineBelow);
        }
        return maxChildrenBaseLine;
    }
}

