/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

public class CompareUtil {
    public static int compare(Object[] objs1, Object[] objs2) {
        boolean[] asc = new boolean[objs1.length];
        Arrays.fill(asc, true);
        return CompareUtil.compare(objs1, objs2, asc);
    }

    public static int compare(Object[] objs1, Object[] objs2, boolean[] asc) {
        int result = 0;
        int i = 0;
        while (i < objs1.length) {
            Object temp1 = objs1[i];
            Object temp2 = objs2[i];
            result = CompareUtil.compare(temp1, temp2) * (asc[i] ? 1 : -1);
            if (result != 0) break;
            ++i;
        }
        return result;
    }

    public static int compare(Object temp1, Object temp2) {
        try {
            return ScriptEvalUtil.compare(temp1, temp2);
        }
        catch (DataException dataException) {
            throw new IllegalArgumentException();
        }
    }

    public static void sort(IDiskArray array, Comparator comparator, IStructureCreator creator) throws IOException {
        DiskSortedStack ss = new DiskSortedStack(4096, false, comparator, creator);
        int i = 0;
        while (i < array.size()) {
            ss.push(array.get(i));
            ++i;
        }
        array.clear();
        i = 0;
        while (i < ss.size()) {
            array.add(ss.pop());
            ++i;
        }
    }
}

