/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryGearService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryPersonService;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryVesselService;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class GenericformatImportPersistenceHelper {
    private final GenericFormatContextSupport importContext;
    private final PersistenceService persistenceService;
    private final ReferentialTemporaryGearService referentialTemporaryGearService;
    private final ReferentialTemporaryPersonService referentialTemporaryPersonService;
    private final ReferentialTemporarySpeciesService referentialTemporarySpeciesService;
    private final ReferentialTemporaryVesselService referentialTemporaryVesselService;
    private final ProtocolImportExportService protocolImportExportService;
    private final Caracteristic copyIndividualObservationModeCaracteristic;
    private final Caracteristic weightMeasuredCaracteristic;
    private final Caracteristic pmfmIdCaracteristic;
    private final Caracteristic sampleCodeCaracteristic;

    public GenericformatImportPersistenceHelper(TuttiServiceContext context, GenericFormatContextSupport importContext) {
        this.importContext = importContext;
        this.persistenceService = context.getService(PersistenceService.class);
        this.referentialTemporaryGearService = context.getService(ReferentialTemporaryGearService.class);
        this.referentialTemporaryPersonService = context.getService(ReferentialTemporaryPersonService.class);
        this.referentialTemporarySpeciesService = context.getService(ReferentialTemporarySpeciesService.class);
        this.referentialTemporaryVesselService = context.getService(ReferentialTemporaryVesselService.class);
        this.protocolImportExportService = context.getService(ProtocolImportExportService.class);
        this.weightMeasuredCaracteristic = this.persistenceService.getWeightMeasuredCaracteristic();
        this.copyIndividualObservationModeCaracteristic = this.persistenceService.getCopyIndividualObservationModeCaracteristic();
        this.pmfmIdCaracteristic = this.persistenceService.getPmfmIdCaracteristic();
        this.sampleCodeCaracteristic = this.persistenceService.getSampleCodeCaracteristic();
    }

    public Set<FishingOperation> getFishingOperations(Integer cruiseId) {
        List<FishingOperation> allFishingOperation = this.persistenceService.getAllFishingOperation(cruiseId);
        return Sets.newLinkedHashSet(allFishingOperation);
    }

    public void deleteAllAttachments(ObjectTypeCode objectTypeCode, Integer objectId) {
        this.persistenceService.deleteAllAttachment(objectTypeCode, objectId);
    }

    public void persistAttachments(Integer objectId, Collection<AttachmentRow> attachmentRows) {
        if (this.importContext.getImportRequest().isImportAttachments() && CollectionUtils.isNotEmpty(attachmentRows)) {
            for (AttachmentRow attachmentRow : attachmentRows) {
                Attachment attachment = attachmentRow.toAttachment(objectId);
                File attachmentFile = this.importContext.getImportRequest().getArchive().extractAttachment(attachment.getPath());
                this.persistenceService.createAttachment(attachment, attachmentFile);
            }
        }
    }

    public Cruise createCruise(Cruise cruise) {
        return this.persistenceService.createCruise(cruise);
    }

    public Cruise saveCruise(Cruise cruise) {
        return this.persistenceService.saveCruise(cruise, false, false);
    }

    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        this.persistenceService.saveGearCaracteristics(gear, cruise);
    }

    public FishingOperation createFishingOperation(FishingOperation fishingOperation) {
        return this.persistenceService.createFishingOperation(fishingOperation);
    }

    public FishingOperation saveFishingOperation(FishingOperation fishingOperation) {
        return this.persistenceService.saveFishingOperation(fishingOperation);
    }

    public CatchBatch getExistingCatchBatch(Integer operationId) {
        boolean withCatchBatch = this.isWithCatchBatch(operationId);
        CatchBatch catchBatch = withCatchBatch ? this.persistenceService.getCatchBatchFromFishingOperation(operationId) : null;
        return catchBatch;
    }

    public boolean isWithCatchBatch(Integer operationId) {
        return this.persistenceService.isFishingOperationWithCatchBatch(operationId);
    }

    public CatchBatch createCatchBatch(CatchBatch catchBatch) {
        return this.persistenceService.createCatchBatch(catchBatch);
    }

    public CatchBatch saveCatchBatch(CatchBatch catchBatch) {
        return this.persistenceService.saveCatchBatch(catchBatch);
    }

    public SpeciesBatch createSpeciesBatch(SpeciesBatch batch, Integer parentId) {
        return this.persistenceService.createSpeciesBatch(batch, parentId, false);
    }

    public void saveSpeciesBatchFrequency(Integer batchId, List<SpeciesBatchFrequency> frequencies) {
        this.persistenceService.saveSpeciesBatchFrequency(batchId, frequencies);
    }

    public void deleteSpeciesBatchForFishingOperation(Integer fishingOperationId) {
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, false);
        for (SpeciesBatch batch : rootSpeciesBatch.getChildren()) {
            this.persistenceService.deleteSpeciesBatch(batch.getIdAsInt());
        }
    }

    public SpeciesBatch createBenthosBatch(SpeciesBatch batch, Integer parentId) {
        return this.persistenceService.createBenthosBatch(batch, parentId, false);
    }

    public void saveBenthosBatchFrequency(Integer batchId, List<SpeciesBatchFrequency> frequencies) {
        this.persistenceService.saveBenthosBatchFrequency(batchId, frequencies);
    }

    public void deleteBenthosBatchForFishingOperation(Integer fishingOperationId) {
        BatchContainer<SpeciesBatch> rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, false);
        for (SpeciesBatch batch : rootBenthosBatch.getChildren()) {
            this.persistenceService.deleteBenthosBatch(batch.getIdAsInt());
        }
    }

    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch marineLitterBatch) {
        return this.persistenceService.createMarineLitterBatch(marineLitterBatch);
    }

    public void deleteMarineLitterForFishingOperation(Integer fishingOperationId) {
        BatchContainer<MarineLitterBatch> rootMarineLitters = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
        for (MarineLitterBatch batch : rootMarineLitters.getChildren()) {
            this.persistenceService.deleteMarineLitterBatch(batch.getIdAsInt());
        }
    }

    public AccidentalBatch createAccidentalBatch(AccidentalBatch accidentalBatch) {
        return this.persistenceService.createAccidentalBatch(accidentalBatch);
    }

    public void deleteAccidentalBatchForFishingOperation(Integer fishingOperationId) {
        this.persistenceService.deleteAccidentalBatchForFishingOperation(fishingOperationId);
    }

    public void setSampleCategoryModel(SampleCategoryModel sampleCategoryModel) {
        this.persistenceService.setSampleCategoryModel(sampleCategoryModel);
    }

    public ReferentialImportRequest<Gear, Integer> createGearImportRequest() {
        return this.referentialTemporaryGearService.createReferentialImportRequest();
    }

    public ReferentialImportResult<Gear> importGears(ReferentialImportRequest<Gear, Integer> referentialImportRequest) {
        return this.referentialTemporaryGearService.executeImportRequest(referentialImportRequest);
    }

    public ReferentialImportRequest<Person, Integer> createPersonImportRequest() {
        return this.referentialTemporaryPersonService.createReferentialImportRequest();
    }

    public ReferentialImportResult<Person> importPersons(ReferentialImportRequest<Person, Integer> referentialImportRequest) {
        return this.referentialTemporaryPersonService.executeImportRequest(referentialImportRequest);
    }

    public ReferentialImportRequest<Vessel, String> createVesselsImportRequest() {
        return this.referentialTemporaryVesselService.createReferentialImportRequest();
    }

    public ReferentialImportResult<Vessel> importVessels(ReferentialImportRequest<Vessel, String> referentialImportRequest) {
        return this.referentialTemporaryVesselService.executeImportRequest(referentialImportRequest);
    }

    public ReferentialImportRequest<Species, Integer> createSpeciesImportRequest() {
        return this.referentialTemporarySpeciesService.createReferentialImportRequest();
    }

    public ReferentialImportResult<Species> importSpecies(ReferentialImportRequest<Species, Integer> referentialImportRequest) {
        return this.referentialTemporarySpeciesService.executeImportRequest(referentialImportRequest);
    }

    public TuttiProtocol importProtocol(File file) {
        return this.protocolImportExportService.importProtocol(file);
    }

    public List<Species> getAllReferentSpecies() {
        return this.persistenceService.getAllReferentSpecies();
    }

    public TuttiProtocol createProtocol(TuttiProtocol tuttiProtocol) {
        TuttiProtocol createdProtocol = this.persistenceService.createProtocol(tuttiProtocol);
        this.persistenceService.setProtocol(createdProtocol);
        return createdProtocol;
    }

    public String getProtocolFirstAvailableName(String protocolOriginalName) {
        return this.persistenceService.getFirstAvailableName(protocolOriginalName);
    }

    public Map<Integer, Integer> getAllObsoleteReferentTaxons() {
        return this.persistenceService.getAllObsoleteReferentTaxons();
    }

    public void deleteIndividualObservationBatchForFishingOperation(Integer fishingOperationId) {
        this.persistenceService.deleteAllIndividualObservationsForFishingOperation(fishingOperationId);
    }

    public List<IndividualObservationBatch> createIndividualObservationBatch(FishingOperation fishingOperation, ImmutableList<IndividualObservationBatch> individualObservationBatch) {
        return this.persistenceService.createIndividualObservationBatches(fishingOperation, (Collection<IndividualObservationBatch>)individualObservationBatch);
    }

    public Caracteristic getCaracteristic(Integer caracteristicId) {
        return this.persistenceService.getCaracteristic(caracteristicId);
    }

    public Caracteristic getCopyIndividualObservationModeCaracteristic() {
        return this.copyIndividualObservationModeCaracteristic;
    }

    public Caracteristic getPmfmIdCaracteristic() {
        return this.pmfmIdCaracteristic;
    }

    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.weightMeasuredCaracteristic;
    }

    public Caracteristic getSampleCodeCaracteristic() {
        return this.sampleCodeCaracteristic;
    }
}

