/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.BenthosWeightComputingException;
import fr.ifremer.tutti.service.catches.CatchWeightComputingException;
import fr.ifremer.tutti.service.catches.MarineLitterWeightComputingException;
import fr.ifremer.tutti.service.catches.SpeciesWeightComputingException;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.util.Numbers;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.decorator.Decorator;
import org.nuiton.validator.NuitonValidatorResult;

public class WeightComputingService
extends AbstractTuttiService {
    protected PersistenceService persistenceService;
    protected ValidationService validationService;
    protected DecoratorService decoratorService;
    private Decorator<Species> speciesDecorator;
    private int currentSpeciesRowIndex;
    private int currentBenthosRowIndex;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.validationService = this.getService(ValidationService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public void computeCatchBatchWeights(CatchBatch catchBatch, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<SpeciesBatch> rootBenthosBatch, BatchContainer<MarineLitterBatch> rootMarineLitterBatch) {
        Float computedTotalWeight;
        Float marineLitterTotalWeight;
        Float benthosInertWeight;
        Float speciesInertWeight;
        Float speciesTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float speciesTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        if (rootSpeciesBatch != null) {
            Pair<Float, Float> pair = this.computeTotalComputedSortedAndUnsortedWeights(rootSpeciesBatch);
            speciesTotalComputedSortedWeight = (Float)pair.getLeft();
            speciesTotalComputedUnsortedWeight = (Float)pair.getRight();
        }
        if ((speciesInertWeight = catchBatch.getSpeciesTotalInertWeight()) != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + speciesInertWeight.floatValue());
        } else {
            catchBatch.setSpeciesTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        Float speciesLivingNotItemizedWeight = catchBatch.getSpeciesTotalLivingNotItemizedWeight();
        if (speciesLivingNotItemizedWeight != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + speciesLivingNotItemizedWeight.floatValue());
        } else {
            catchBatch.setSpeciesTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setSpeciesTotalSampleSortedComputedWeight(WeightUnit.KG.round(speciesTotalComputedSortedWeight));
        Float speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedWeight();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = speciesTotalComputedSortedWeight;
            catchBatch.setSpeciesTotalSortedComputedWeight(WeightUnit.KG.round(speciesTotalSortedWeight));
        } else if (WeightUnit.KG.isSmallerThan(speciesTotalSortedWeight.floatValue(), speciesTotalComputedSortedWeight.floatValue())) {
            throw SpeciesWeightComputingException.forIncoherentTotalSorted(this.getSpeciesWeightUnit(), speciesTotalSortedWeight, speciesTotalComputedSortedWeight);
        }
        catchBatch.setSpeciesTotalUnsortedComputedWeight(WeightUnit.KG.round(speciesTotalComputedUnsortedWeight));
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedComputedWeight();
        }
        Float benthosTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float benthosTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        if (rootBenthosBatch != null) {
            Pair<Float, Float> pair = this.computeTotalComputedSortedAndUnsortedWeights(rootBenthosBatch);
            benthosTotalComputedSortedWeight = (Float)pair.getLeft();
            benthosTotalComputedUnsortedWeight = (Float)pair.getRight();
        }
        if ((benthosInertWeight = catchBatch.getBenthosTotalInertWeight()) != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + benthosInertWeight.floatValue());
        } else {
            catchBatch.setBenthosTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        Float benthosLivingNotItemizedWeight = catchBatch.getBenthosTotalLivingNotItemizedWeight();
        if (benthosLivingNotItemizedWeight != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + benthosLivingNotItemizedWeight.floatValue());
        } else {
            catchBatch.setBenthosTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setBenthosTotalSampleSortedComputedWeight(WeightUnit.KG.round(benthosTotalComputedSortedWeight));
        Float benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedWeight();
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = benthosTotalComputedSortedWeight;
            catchBatch.setBenthosTotalSortedComputedWeight(WeightUnit.KG.round(benthosTotalSortedWeight));
        } else if (WeightUnit.KG.isSmallerThan(benthosTotalSortedWeight.floatValue(), benthosTotalComputedSortedWeight.floatValue())) {
            throw BenthosWeightComputingException.forIncoherentTotalSorted(this.getBenthosWeightUnit(), benthosTotalSortedWeight, benthosTotalComputedSortedWeight);
        }
        catchBatch.setBenthosTotalUnsortedComputedWeight(WeightUnit.KG.round(benthosTotalComputedUnsortedWeight));
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedComputedWeight();
        }
        Float marineLitterTotalComputedWeight = Float.valueOf(0.0f);
        if (rootMarineLitterBatch != null) {
            for (MarineLitterBatch row : rootMarineLitterBatch.getChildren()) {
                Float rowWeight = row.getWeight();
                if (rowWeight == null) {
                    marineLitterTotalComputedWeight = null;
                    break;
                }
                marineLitterTotalComputedWeight = Float.valueOf(marineLitterTotalComputedWeight.floatValue() + rowWeight.floatValue());
            }
        }
        if (marineLitterTotalComputedWeight != null) {
            marineLitterTotalComputedWeight = WeightUnit.KG.round(marineLitterTotalComputedWeight);
            catchBatch.setMarineLitterTotalComputedWeight(marineLitterTotalComputedWeight);
        }
        if ((marineLitterTotalWeight = catchBatch.getMarineLitterTotalWeight()) != null && marineLitterTotalComputedWeight != null && WeightUnit.KG.isSmallerThan(marineLitterTotalWeight.floatValue(), marineLitterTotalComputedWeight.floatValue())) {
            throw MarineLitterWeightComputingException.forIncoherentTotal(this.getMarineLitterWeightUnit(), marineLitterTotalWeight, marineLitterTotalComputedWeight);
        }
        Float totalUnsortedWeight = Float.valueOf(catchBatch.getSpeciesTotalUnsortedComputedWeight().floatValue() + catchBatch.getBenthosTotalUnsortedComputedWeight().floatValue());
        Float totalSortedSortedWeight = Float.valueOf(speciesTotalSortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        catchBatch.setCatchTotalSortedSortedComputedWeight(WeightUnit.KG.round(totalSortedSortedWeight));
        catchBatch.setCatchTotalUnsortedComputedWeight(WeightUnit.KG.round(totalUnsortedWeight));
        Float totalWeight = catchBatch.getCatchTotalWeight();
        Float rejectedWeight = catchBatch.getCatchTotalRejectedWeight();
        if (rejectedWeight == null && totalWeight != null) {
            computedTotalWeight = WeightUnit.KG.round(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedSortedWeight.floatValue()));
            if (WeightUnit.KG.isNotEquals(totalWeight.floatValue(), computedTotalWeight.floatValue())) {
                throw CatchWeightComputingException.forIncoherentTotal(this.getCatchWeightUnit(), totalWeight, computedTotalWeight);
            }
            catchBatch.setCatchTotalRejectedComputedWeight(WeightUnit.KG.round(Float.valueOf(totalWeight.floatValue() - totalUnsortedWeight.floatValue() - totalSortedSortedWeight.floatValue())));
        } else if (totalWeight == null) {
            if (rejectedWeight == null) {
                rejectedWeight = Float.valueOf(0.0f);
                catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(0.0f));
            }
            catchBatch.setCatchTotalComputedWeight(WeightUnit.KG.round(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedSortedWeight.floatValue() + rejectedWeight.floatValue())));
        } else {
            computedTotalWeight = WeightUnit.KG.round(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedSortedWeight.floatValue() + rejectedWeight.floatValue()));
            if (WeightUnit.KG.isNotEquals(totalWeight.floatValue(), computedTotalWeight.floatValue())) {
                throw CatchWeightComputingException.forIncoherentTotalWithRejected(this.getCatchWeightUnit(), totalWeight, computedTotalWeight);
            }
        }
        Float totalSortedWeight = totalSortedSortedWeight;
        if (rejectedWeight != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + rejectedWeight.floatValue());
        }
        catchBatch.setCatchTotalSortedComputedWeight(WeightUnit.KG.round(totalSortedWeight));
        Float catchRate = WeightUnit.KG.isZero(totalSortedSortedWeight.floatValue()) ? Float.valueOf(0.0f) : Float.valueOf(totalSortedWeight.floatValue() / totalSortedSortedWeight.floatValue());
        Float speciesTotalWeight = Float.valueOf(speciesTotalSortedWeight.floatValue() * catchRate.floatValue() + speciesTotalComputedUnsortedWeight.floatValue());
        catchBatch.setSpeciesTotalComputedWeight(WeightUnit.KG.round(speciesTotalWeight));
        Float benthosTotalWeight = Float.valueOf(benthosTotalSortedWeight.floatValue() * catchRate.floatValue() + benthosTotalComputedUnsortedWeight.floatValue());
        catchBatch.setBenthosTotalComputedWeight(WeightUnit.KG.round(benthosTotalWeight));
    }

    public BatchContainer<SpeciesBatch> getComputedSpeciesBatches(Integer operationId) {
        BatchContainer<SpeciesBatch> rootSpeciesBatch = null;
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operationId, false);
            this.currentSpeciesRowIndex = 0;
            if (rootSpeciesBatch != null) {
                rootSpeciesBatch.getChildren().forEach(this::computeSpeciesBatch);
            }
        }
        return rootSpeciesBatch;
    }

    public Float computeSpeciesBatch(SpeciesBatch batch) {
        Float result = null;
        int thisIndex = this.currentSpeciesRowIndex++;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        NuitonValidatorResult validation = this.validationService.validateEditSpeciesBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            throw SpeciesWeightComputingException.forValidationMessage(this.getSpeciesWeightUnit(), (String)messages.get(0), this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), batch.getWeight(), batch.getSampleCategoryWeight(), thisIndex);
        }
        List children = batch.getChildBatchs();
        if (batch.sizeChildBatchs() > 0) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatch child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if ((sum = WeightUnit.KG.round(sum)) != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(sum);
                } else {
                    if (WeightUnit.KG.isSmallerThan(categoryWeight.floatValue(), sum.floatValue())) {
                        throw SpeciesWeightComputingException.forIncoherentParentCategoryWeight(this.getSpeciesWeightUnit(), this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), categoryWeight, sum, thisIndex);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getIdAsInt());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = this.sumFrequenciesWeight(frequencies);
                if (categoryWeight != null || rowWeight == null) {
                    if (rowWeight != null && frequencyWeight != null && WeightUnit.KG.isNotEquals(rowWeight.floatValue(), frequencyWeight.floatValue())) {
                        throw SpeciesWeightComputingException.forIncoherentRowWeightFrequency(this.getSpeciesWeightUnit(), this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), frequencyWeight, rowWeight, thisIndex);
                    }
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(frequencyWeight);
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && WeightUnit.KG.isNotEquals(frequencyWeight.floatValue(), categoryWeight.floatValue())) {
                        if (WeightUnit.KG.isGreaterThan(frequencyWeight.floatValue(), categoryWeight.floatValue())) {
                            throw SpeciesWeightComputingException.forIncoherentCategoryWeight(this.getSpeciesWeightUnit(), this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), frequencyWeight, categoryWeight, thisIndex);
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(frequencyWeight);
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
                Integer frequencyNumber = this.sumFrequenciesNumber(frequencies);
                batch.setComputedNumber(frequencyNumber);
            } else {
                result = categoryWeight;
            }
        }
        if (WeightUnit.KG.isNullOrZero(result)) {
            throw SpeciesWeightComputingException.forNoWeight(this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), thisIndex);
        }
        return WeightUnit.KG.round(result);
    }

    public BatchContainer<SpeciesBatch> getComputedBenthosBatches(Integer operationId) {
        BatchContainer<SpeciesBatch> rootBenthosBatch = null;
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            rootBenthosBatch = this.persistenceService.getRootBenthosBatch(operationId, false);
            this.currentBenthosRowIndex = 0;
            if (rootBenthosBatch != null) {
                rootBenthosBatch.getChildren().forEach(this::computeBenthosBatch);
            }
        }
        return rootBenthosBatch;
    }

    public Float computeBenthosBatch(SpeciesBatch batch) {
        Float result = null;
        int thisIndex = this.currentBenthosRowIndex++;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        NuitonValidatorResult validation = this.validationService.validateEditBenthosBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            throw BenthosWeightComputingException.forValidationMessage(this.getBenthosWeightUnit(), (String)messages.get(0), this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), batch.getWeight(), batch.getSampleCategoryWeight(), thisIndex);
        }
        List children = batch.getChildBatchs();
        if (!batch.isChildBatchsEmpty()) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatch child : children) {
                Float weight = this.computeBenthosBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if ((sum = WeightUnit.KG.round(sum)) != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(sum);
                } else {
                    if (WeightUnit.KG.isSmallerThan(categoryWeight.floatValue(), sum.floatValue())) {
                        throw BenthosWeightComputingException.forIncoherentParentCategoryWeight(this.getBenthosWeightUnit(), this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), categoryWeight, sum, thisIndex);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllBenthosBatchFrequency(batch.getIdAsInt());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = this.sumFrequenciesWeight(frequencies);
                if (categoryWeight != null || rowWeight == null) {
                    if (rowWeight != null && frequencyWeight != null && WeightUnit.KG.isNotEquals(rowWeight.floatValue(), frequencyWeight.floatValue())) {
                        throw BenthosWeightComputingException.forIncoherentRowWeightFrequency(this.getBenthosWeightUnit(), this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), rowWeight, categoryWeight, thisIndex);
                    }
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(frequencyWeight);
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && WeightUnit.KG.isNotEquals(frequencyWeight.floatValue(), categoryWeight.floatValue())) {
                        if (WeightUnit.KG.isGreaterThan(frequencyWeight.floatValue(), categoryWeight.floatValue())) {
                            throw BenthosWeightComputingException.forIncoherentCategoryWeight(this.getBenthosWeightUnit(), this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), frequencyWeight, categoryWeight, thisIndex);
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(frequencyWeight);
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
                Integer frequencyNumber = this.sumFrequenciesNumber(frequencies);
                batch.setComputedNumber(frequencyNumber);
            } else {
                result = categoryWeight;
            }
        }
        if (WeightUnit.KG.isNullOrZero(result)) {
            throw BenthosWeightComputingException.forNoWeight(this.decorateSpecies(batch.getSpecies()), this.getCategoryLabel(batch.getSampleCategoryId()), this.decorateCategoryValue(batch.getSampleCategoryValue()), thisIndex);
        }
        return WeightUnit.KG.round(result);
    }

    public BatchContainer<MarineLitterBatch> getComputedMarineLitterBatches(Integer fishingOperationId, Float marineLitterWeight) {
        BatchContainer<MarineLitterBatch> rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
        if (rootMarineLitterBatch != null) {
            boolean checkWeight = marineLitterWeight == null;
            List children = rootMarineLitterBatch.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                MarineLitterBatch batch = (MarineLitterBatch)children.get(i);
                if (!checkWeight || !WeightUnit.KG.isNullOrZero(batch.getWeight())) continue;
                throw MarineLitterWeightComputingException.forNoWeight(i);
            }
        }
        return rootMarineLitterBatch;
    }

    private Pair<Float, Float> computeTotalComputedSortedAndUnsortedWeights(BatchContainer<SpeciesBatch> rootSpeciesBatch) {
        SpeciesBatch speciesBatch;
        Float weight;
        Float speciesTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float speciesTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        Iterator iterator = rootSpeciesBatch.getChildren().iterator();
        while (iterator.hasNext() && (weight = (Float)Numbers.getValueOrComputedValue((Number)(speciesBatch = (SpeciesBatch)iterator.next()).getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight())) != null) {
            if (this.persistenceService.isVracBatch(speciesBatch)) {
                speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + weight.floatValue());
                continue;
            }
            speciesTotalComputedUnsortedWeight = Float.valueOf(speciesTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
        }
        return Pair.of((Object)speciesTotalComputedSortedWeight, (Object)speciesTotalComputedUnsortedWeight);
    }

    private String getCategoryLabel(Integer sampleCategoryId) {
        SampleCategoryModelEntry category = this.context.getSampleCategoryModel().getCategoryById(sampleCategoryId);
        return category.getLabel();
    }

    private Integer sumFrequenciesNumber(List<SpeciesBatchFrequency> frequencies) {
        Integer frequencyNumber = 0;
        for (SpeciesBatchFrequency frequency : frequencies) {
            Integer c = frequency.getNumber();
            frequencyNumber = frequencyNumber + c;
        }
        return frequencyNumber;
    }

    private Float sumFrequenciesWeight(List<SpeciesBatchFrequency> frequencies) {
        Float frequencyWeight = Float.valueOf(0.0f);
        for (SpeciesBatchFrequency frequency : frequencies) {
            Float w = frequency.getWeight();
            if (w == null) {
                frequencyWeight = null;
                break;
            }
            if (frequencyWeight == null) continue;
            frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
        }
        frequencyWeight = WeightUnit.KG.round(frequencyWeight);
        return frequencyWeight;
    }

    private String decorateSpecies(Species species) {
        if (this.speciesDecorator == null) {
            this.speciesDecorator = this.decoratorService.getDecoratorByType(Species.class);
        }
        return this.speciesDecorator.toString((Object)species);
    }

    private String decorateCategoryValue(Serializable sampleCategoryValue) {
        return this.decoratorService.getDecorator(sampleCategoryValue).toString((Object)sampleCategoryValue);
    }

    private WeightUnit getSpeciesWeightUnit() {
        return this.context.getConfig().getSpeciesWeightUnit();
    }

    private WeightUnit getBenthosWeightUnit() {
        return this.context.getConfig().getBenthosWeightUnit();
    }

    private WeightUnit getMarineLitterWeightUnit() {
        return this.context.getConfig().getMarineLitterWeightUnit();
    }

    private WeightUnit getCatchWeightUnit() {
        return WeightUnit.KG;
    }
}

