/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Pattern;
import org.eclipse.birt.core.data.DateFormatFactory;
import org.eclipse.birt.core.data.PatternKey;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;

public class DateFormatISO8601 {
    private static Pattern T_PATTERN = Pattern.compile("T");

    public static Date parse(String source, TimeZone timeZone) throws BirtException, ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        Date resultDate = null;
        SimpleDateFormat simpleDateFormatter = DateFormatFactory.getPatternInstance(PatternKey.getPatterKey(source = DateFormatISO8601.cleanDate(source)));
        if (simpleDateFormatter != null) {
            SimpleDateFormat dateFormat = simpleDateFormatter;
            TimeZone savedTimeZone = null;
            try {
                if (timeZone != null) {
                    savedTimeZone = dateFormat.getTimeZone();
                    dateFormat.setTimeZone(timeZone);
                }
                Date date = resultDate = dateFormat.parse(source);
                return date;
            }
            catch (ParseException parseException) {
            }
            finally {
                if (savedTimeZone != null) {
                    dateFormat.setTimeZone(savedTimeZone);
                }
            }
        }
        if (resultDate == null) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
        return resultDate;
    }

    public static String format(Date date) throws BirtException {
        String result = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormatter = DateFormatFactory.getPatternInstance(PatternKey.getPatterKey("yyyy-MM-dd HH:mm:ss.sZ"));
        if (simpleDateFormatter != null) {
            try {
                result = simpleDateFormatter.format(date);
                return result;
            }
            catch (Exception exception) {}
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{date.toString(), "ISO8601 Format"});
    }

    private static String cleanDate(String s) {
        int zoneIndex;
        if ((s = s.trim()).indexOf(84) < 12) {
            s = T_PATTERN.matcher(s).replaceFirst(" ");
        }
        if ((zoneIndex = s.indexOf(90)) == s.length() - 1) {
            return s.substring(0, zoneIndex).trim();
        }
        return s;
    }

    private static int getZoneIndex(String s) {
        int index = s.indexOf(43);
        if (index > 0) {
            return index;
        }
        index = s.indexOf(45);
        if (index <= 0) {
            return index;
        }
        index = s.indexOf(45, index + 1);
        if (index <= 0) {
            return index;
        }
        index = s.indexOf(45, index + 1);
        return index;
    }
}

