/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sampling;

import com.google.common.base.MoreObjects;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinition;
import fr.ifremer.tutti.service.sampling.CruiseSamplingInternalCache;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingContext;
import java.util.Objects;

public class IndividualObservationSamplingStatus {
    private final IndividualObservationSamplingContext individualObservationSamplingContext;
    private final int individualObservationCountInCruise;
    private final int samplingCountInCruise;
    private final int individualObservationCountInFishingOperation;
    private final int samplingCountInFishingOperation;
    private final int individualObservationCountInZone;
    private final int samplingCountInZone;
    private final boolean needSampling;

    public IndividualObservationSamplingStatus(IndividualObservationSamplingContext individualObservationSamplingContext, boolean computeSampling, CruiseSamplingInternalCache.SamplingData cruiseSamplingData, CruiseSamplingInternalCache.SamplingData zoneSamplingData, CruiseSamplingInternalCache.SamplingData fishingOperationSamplingData) {
        boolean needSampling;
        Objects.requireNonNull(individualObservationSamplingContext);
        Objects.requireNonNull(cruiseSamplingData);
        Objects.requireNonNull(zoneSamplingData);
        Objects.requireNonNull(fishingOperationSamplingData);
        this.individualObservationSamplingContext = individualObservationSamplingContext;
        this.samplingCountInCruise = cruiseSamplingData.getSamplingCount();
        this.individualObservationCountInCruise = cruiseSamplingData.getIndividualObservationCount();
        this.samplingCountInZone = zoneSamplingData.getSamplingCount();
        this.individualObservationCountInZone = zoneSamplingData.getIndividualObservationCount();
        this.samplingCountInFishingOperation = fishingOperationSamplingData.getSamplingCount();
        this.individualObservationCountInFishingOperation = fishingOperationSamplingData.getIndividualObservationCount();
        if (computeSampling && !this.isNotUsingSampling() && !this.isOneTotalCountIsAttained()) {
            int samplingInterval = individualObservationSamplingContext.getCalcifiedPiecesSamplingDefinition().getSamplingInterval();
            needSampling = this.individualObservationCountInCruise == 1 || samplingInterval == 1 || this.individualObservationCountInCruise % samplingInterval == 1;
        } else {
            needSampling = false;
        }
        this.needSampling = needSampling;
    }

    public IndividualObservationSamplingContext getIndividualObservationSamplingContext() {
        return this.individualObservationSamplingContext;
    }

    public boolean isNeedSampling() {
        return this.needSampling;
    }

    public CalcifiedPiecesSamplingDefinition getCalcifiedPiecesSamplingDefinition() {
        return this.individualObservationSamplingContext.getCalcifiedPiecesSamplingDefinition();
    }

    public int getSamplingCountInCruise() {
        return this.samplingCountInCruise;
    }

    public int getSamplingCountInFishingOperation() {
        return this.samplingCountInFishingOperation;
    }

    public int getSamplingCountInZone() {
        return this.samplingCountInZone;
    }

    public int getIndividualObservationCountInCruise() {
        return this.individualObservationCountInCruise;
    }

    public int getIndividualObservationCountInFishingOperation() {
        return this.individualObservationCountInFishingOperation;
    }

    public int getIndividualObservationCountInZone() {
        return this.individualObservationCountInZone;
    }

    public Integer getTotalSamplingRequiredInCruise() {
        return this.getCalcifiedPiecesSamplingDefinition().getMaxByLenghtStep();
    }

    public Integer getTotalSamplingRequiredInFishingOperation() {
        return this.getCalcifiedPiecesSamplingDefinition().getOperationLimitation();
    }

    public Integer getTotalSamplingRequiredInZone() {
        return this.getCalcifiedPiecesSamplingDefinition().getZoneLimitation();
    }

    public boolean isTotalInCruiseAttained() {
        Integer totalSamplingRequiredInCruise = this.getTotalSamplingRequiredInCruise();
        return totalSamplingRequiredInCruise != null && totalSamplingRequiredInCruise > 0 && this.getSamplingCountInCruise() >= totalSamplingRequiredInCruise;
    }

    public boolean isTotalInFishingOperationAttained() {
        Integer totalSamplingRequiredInFishingOperation = this.getTotalSamplingRequiredInFishingOperation();
        return totalSamplingRequiredInFishingOperation != null && totalSamplingRequiredInFishingOperation > 0 && this.getSamplingCountInFishingOperation() >= totalSamplingRequiredInFishingOperation;
    }

    public boolean isTotalInZoneAttained() {
        Integer totalSamplingRequiredInZone = this.getTotalSamplingRequiredInZone();
        return totalSamplingRequiredInZone != null && totalSamplingRequiredInZone > 0 && this.getSamplingCountInZone() >= totalSamplingRequiredInZone;
    }

    public boolean isOneTotalCountIsAttained() {
        return this.isTotalInCruiseAttained() || this.isTotalInZoneAttained() || this.isTotalInFishingOperationAttained();
    }

    public boolean isTotalInCruiseNotUsed() {
        Integer totalSamplingRequiredInCruise = this.getTotalSamplingRequiredInCruise();
        return totalSamplingRequiredInCruise != null && totalSamplingRequiredInCruise == 0;
    }

    public boolean isTotalInFishingOperationNotUsed() {
        Integer totalSamplingRequiredInFishingOperation = this.getTotalSamplingRequiredInFishingOperation();
        return totalSamplingRequiredInFishingOperation != null && totalSamplingRequiredInFishingOperation == 0;
    }

    public boolean isTotalInZoneNotUsed() {
        Integer totalSamplingRequiredInZone = this.getTotalSamplingRequiredInZone();
        return totalSamplingRequiredInZone != null && totalSamplingRequiredInZone == 0;
    }

    public boolean isNotUsingSampling() {
        return this.isTotalInCruiseNotUsed() && this.isTotalInFishingOperationNotUsed() && this.isTotalInZoneNotUsed();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("individualObservationSamplingContext", (Object)this.individualObservationSamplingContext).add("individualObservationCountInCruise", this.getIndividualObservationCountInCruise()).add("samplingCountInCruise", this.samplingCountInCruise).add("individualObservationCountInFishingOperation", this.getIndividualObservationCountInFishingOperation()).add("samplingCountInFishingOperation", this.samplingCountInFishingOperation).add("individualObservationCountInZone", this.getIndividualObservationCountInZone()).add("samplingCountInZone", this.samplingCountInZone).add("needSampling", this.needSampling).toString();
    }
}

