/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class FloatValue
extends Value
implements CSSPrimitiveValue {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.ENGLISH));
    protected static final String[] UNITS = new String[]{"", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc", "deg", "rad", "grad", "ms", "s", "Hz", "kHz", ""};
    protected float floatValue;
    protected short unitType;

    public static String getCssText(short unit, float value) {
        if (unit < 0 || unit >= UNITS.length) {
            throw new DOMException(12, "");
        }
        String s = FORMATTER.format(value);
        return String.valueOf(s) + UNITS[unit - 1];
    }

    public FloatValue(short unitType, float floatValue) {
        this.unitType = unitType;
        this.floatValue = floatValue;
    }

    @Override
    public short getPrimitiveType() {
        return this.unitType;
    }

    @Override
    public float getFloatValue() {
        return this.floatValue;
    }

    @Override
    public float getFloatValue(short unitType) {
        return FloatValue.convertFloatValue(unitType, this);
    }

    @Override
    public String getCssText() {
        return FloatValue.getCssText(this.unitType, this.floatValue);
    }

    public String toString() {
        return this.getCssText();
    }

    public static float convertFloatValue(short unitType, FloatValue value) {
        switch (unitType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                if (value.getPrimitiveType() != unitType) break;
                return value.getFloatValue();
            }
            case 6: {
                return FloatValue.toCentimeters(unitType, value.getFloatValue());
            }
            case 7: {
                return FloatValue.toMillimeters(unitType, value.getFloatValue());
            }
            case 8: {
                return FloatValue.toInches(unitType, value.getFloatValue());
            }
            case 9: {
                return FloatValue.toPoints(unitType, value.getFloatValue());
            }
            case 10: {
                return FloatValue.toPicas(unitType, value.getFloatValue());
            }
            case 11: {
                return FloatValue.toDegrees(unitType, value.getFloatValue());
            }
            case 12: {
                return FloatValue.toRadians(unitType, value.getFloatValue());
            }
            case 13: {
                return FloatValue.toGradians(unitType, value.getFloatValue());
            }
            case 14: {
                return FloatValue.toMilliseconds(unitType, value.getFloatValue());
            }
            case 15: {
                return FloatValue.toSeconds(unitType, value.getFloatValue());
            }
            case 16: {
                return FloatValue.toHertz(unitType, value.getFloatValue());
            }
            case 17: {
                return FloatValue.tokHertz(unitType, value.getFloatValue());
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toCentimeters(int type, float value) {
        switch (type) {
            case 6: {
                return value;
            }
            case 7: {
                return value / 10.0f;
            }
            case 8: {
                return value * 2.54f;
            }
            case 9: {
                return value * 2.54f / 72.0f;
            }
            case 10: {
                return value * 2.54f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toInches(int type, float value) {
        switch (type) {
            case 6: {
                return value / 2.54f;
            }
            case 7: {
                return value / 25.4f;
            }
            case 8: {
                return value;
            }
            case 9: {
                return value / 72.0f;
            }
            case 10: {
                return value / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMillimeters(int unit, float value) {
        switch (unit) {
            case 6: {
                return value * 10.0f;
            }
            case 7: {
                return value;
            }
            case 8: {
                return value * 25.4f;
            }
            case 9: {
                return value * 25.4f / 72.0f;
            }
            case 10: {
                return value * 25.4f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPoints(int unit, float value) {
        switch (unit) {
            case 6: {
                return value * 72.0f / 2.54f;
            }
            case 7: {
                return value * 72.0f / 25.4f;
            }
            case 8: {
                return value * 72.0f;
            }
            case 9: {
                return value;
            }
            case 10: {
                return value * 12.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPicas(int unit, float value) {
        switch (unit) {
            case 6: {
                return value * 6.0f / 2.54f;
            }
            case 7: {
                return value * 6.0f / 25.4f;
            }
            case 8: {
                return value * 6.0f;
            }
            case 9: {
                return value / 12.0f;
            }
            case 10: {
                return value;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toDegrees(int unit, float value) {
        switch (unit) {
            case 11: {
                return value;
            }
            case 12: {
                return (float)((double)(value * 180.0f) / Math.PI);
            }
            case 13: {
                return value * 9.0f / 5.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toRadians(int unit, float value) {
        switch (unit) {
            case 11: {
                return value * 5.0f / 9.0f;
            }
            case 12: {
                return value;
            }
            case 13: {
                return (float)((double)(value * 100.0f) / Math.PI);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toGradians(int unit, float value) {
        switch (unit) {
            case 11: {
                return (float)((double)value * Math.PI / 180.0);
            }
            case 12: {
                return (float)((double)value * Math.PI / 100.0);
            }
            case 13: {
                return value;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMilliseconds(int unit, float value) {
        switch (unit) {
            case 14: {
                return value;
            }
            case 15: {
                return value * 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toSeconds(int unit, float value) {
        switch (unit) {
            case 14: {
                return value / 1000.0f;
            }
            case 15: {
                return value;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toHertz(int unit, float value) {
        switch (unit) {
            case 16: {
                return value;
            }
            case 17: {
                return value / 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float tokHertz(int unit, float value) {
        switch (unit) {
            case 16: {
                return value * 1000.0f;
            }
            case 17: {
                return value;
            }
        }
        throw new DOMException(15, "");
    }

    public boolean equals(Object value) {
        if (value instanceof FloatValue) {
            FloatValue f = (FloatValue)value;
            if (this.floatValue == f.floatValue && this.unitType == f.unitType) {
                return true;
            }
        }
        return false;
    }
}

